/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.SootField;
import soot.SootFieldRef;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.FieldGetInst;
import soot.grimp.PrecedenceTest;
import soot.jimple.ConvertToBaf;
import soot.jimple.InstanceFieldRef;
import soot.jimple.JimpleToBafContext;
import soot.jimple.RefSwitch;
import soot.tagkit.Tag;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInstanceFieldRef
implements InstanceFieldRef,
ConvertToBaf {
    protected SootFieldRef fieldRef;
    ValueBox baseBox;

    protected AbstractInstanceFieldRef(ValueBox baseBox, SootFieldRef fieldRef) {
        if (fieldRef.isStatic()) {
            throw new RuntimeException("wrong static-ness");
        }
        this.baseBox = baseBox;
        this.fieldRef = fieldRef;
    }

    @Override
    public abstract Object clone();

    public String toString() {
        return this.baseBox.getValue().toString() + "." + this.fieldRef.getSignature();
    }

    @Override
    public void toString(UnitPrinter up) {
        if (PrecedenceTest.needsBrackets(this.baseBox, this)) {
            up.literal("(");
        }
        this.baseBox.toString(up);
        if (PrecedenceTest.needsBrackets(this.baseBox, this)) {
            up.literal(")");
        }
        up.literal(".");
        up.fieldRef(this.fieldRef);
    }

    @Override
    public Value getBase() {
        return this.baseBox.getValue();
    }

    @Override
    public ValueBox getBaseBox() {
        return this.baseBox;
    }

    @Override
    public void setBase(Value base) {
        this.baseBox.setValue(base);
    }

    @Override
    public SootFieldRef getFieldRef() {
        return this.fieldRef;
    }

    @Override
    public void setFieldRef(SootFieldRef fieldRef) {
        this.fieldRef = fieldRef;
    }

    @Override
    public SootField getField() {
        return this.fieldRef.resolve();
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> useBoxes = new ArrayList<ValueBox>();
        useBoxes.addAll(this.baseBox.getValue().getUseBoxes());
        useBoxes.add(this.baseBox);
        return useBoxes;
    }

    @Override
    public Type getType() {
        return this.fieldRef.type();
    }

    @Override
    public void apply(Switch sw) {
        ((RefSwitch)sw).caseInstanceFieldRef(this);
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof AbstractInstanceFieldRef) {
            AbstractInstanceFieldRef fr = (AbstractInstanceFieldRef)o;
            return fr.getField().equals(this.getField()) && fr.baseBox.getValue().equivTo(this.baseBox.getValue());
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.getField().equivHashCode() * 101 + this.baseBox.getValue().equivHashCode() + 17;
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        ((ConvertToBaf)((Object)this.getBase())).convertToBaf(context, out);
        FieldGetInst u = Baf.v().newFieldGetInst(this.fieldRef);
        out.add(u);
        Unit currentUnit = context.getCurrentUnit();
        Iterator<Tag> it = currentUnit.getTags().iterator();
        while (it.hasNext()) {
            u.addTag(it.next());
        }
    }
}

