/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import soot.FloatType;
import soot.Type;
import soot.jimple.ConstantSwitch;
import soot.jimple.IntConstant;
import soot.jimple.NumericConstant;
import soot.jimple.RealConstant;
import soot.util.Switch;

public class FloatConstant
extends RealConstant {
    public final float value;

    private FloatConstant(float value) {
        this.value = value;
    }

    public static FloatConstant v(float value) {
        return new FloatConstant(value);
    }

    public boolean equals(Object c) {
        return c instanceof FloatConstant && ((FloatConstant)c).value == this.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public NumericConstant add(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return FloatConstant.v(this.value + ((FloatConstant)c).value);
    }

    public NumericConstant subtract(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return FloatConstant.v(this.value - ((FloatConstant)c).value);
    }

    public NumericConstant multiply(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return FloatConstant.v(this.value * ((FloatConstant)c).value);
    }

    public NumericConstant divide(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return FloatConstant.v(this.value / ((FloatConstant)c).value);
    }

    public NumericConstant remainder(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return FloatConstant.v(this.value % ((FloatConstant)c).value);
    }

    public NumericConstant equalEqual(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return IntConstant.v(this.value == ((FloatConstant)c).value ? 1 : 0);
    }

    public NumericConstant notEqual(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return IntConstant.v(this.value != ((FloatConstant)c).value ? 1 : 0);
    }

    public NumericConstant lessThan(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return IntConstant.v(this.value < ((FloatConstant)c).value ? 1 : 0);
    }

    public NumericConstant lessThanOrEqual(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return IntConstant.v(this.value <= ((FloatConstant)c).value ? 1 : 0);
    }

    public NumericConstant greaterThan(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return IntConstant.v(this.value > ((FloatConstant)c).value ? 1 : 0);
    }

    public NumericConstant greaterThanOrEqual(NumericConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        return IntConstant.v(this.value >= ((FloatConstant)c).value ? 1 : 0);
    }

    public IntConstant cmpg(RealConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        float cValue = ((FloatConstant)c).value;
        if (this.value < cValue) {
            return IntConstant.v(-1);
        }
        if (this.value == cValue) {
            return IntConstant.v(0);
        }
        return IntConstant.v(1);
    }

    public IntConstant cmpl(RealConstant c) {
        if (!(c instanceof FloatConstant)) {
            throw new IllegalArgumentException("FloatConstant expected");
        }
        float cValue = ((FloatConstant)c).value;
        if (this.value > cValue) {
            return IntConstant.v(1);
        }
        if (this.value == cValue) {
            return IntConstant.v(0);
        }
        return IntConstant.v(-1);
    }

    public NumericConstant negate() {
        return FloatConstant.v(-this.value);
    }

    public String toString() {
        String floatString = new Float(this.value).toString();
        if (floatString.equals("NaN") || floatString.equals("Infinity") || floatString.equals("-Infinity")) {
            return "#" + floatString + "F";
        }
        return floatString + "F";
    }

    public Type getType() {
        return FloatType.v();
    }

    public void apply(Switch sw) {
        ((ConstantSwitch)sw).caseFloatConstant(this);
    }
}

