/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.structuredAnalysis;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.Local;
import soot.Value;
import soot.dava.internal.AST.ASTDoWhileNode;
import soot.dava.internal.AST.ASTForLoopNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTUnaryBinaryCondition;
import soot.dava.internal.AST.ASTUnconditionalLoopNode;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.toolkits.base.AST.structuredAnalysis.DavaFlowSet;
import soot.dava.toolkits.base.AST.structuredAnalysis.StructuredAnalysis;
import soot.dava.toolkits.base.AST.traversals.AllDefinitionsFinder;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReachingDefs
extends StructuredAnalysis {
    Object toAnalyze;

    public ReachingDefs(Object analyze) {
        this.toAnalyze = analyze;
        DavaFlowSet temp = (DavaFlowSet)this.process(analyze, new DavaFlowSet());
    }

    @Override
    public DavaFlowSet emptyFlowSet() {
        return new DavaFlowSet();
    }

    @Override
    public Object newInitialFlow() {
        DavaFlowSet initial = new DavaFlowSet();
        AllDefinitionsFinder defFinder = new AllDefinitionsFinder();
        ((ASTNode)this.toAnalyze).apply(defFinder);
        List<DefinitionStmt> allDefs = defFinder.getAllDefs();
        Iterator<DefinitionStmt> defIt = allDefs.iterator();
        while (defIt.hasNext()) {
            initial.add(defIt.next());
        }
        return initial;
    }

    @Override
    public void setMergeType() {
        this.MERGETYPE = 1;
    }

    @Override
    public Object cloneFlowSet(Object flowSet) {
        if (flowSet instanceof DavaFlowSet) {
            return ((DavaFlowSet)flowSet).clone();
        }
        throw new RuntimeException("cloneFlowSet not implemented for other flowSet types");
    }

    @Override
    public Object processUnaryBinaryCondition(ASTUnaryBinaryCondition cond, Object input) {
        if (!(input instanceof DavaFlowSet)) {
            throw new RuntimeException("processCondition is not implemented for other flowSet types");
        }
        DavaFlowSet inSet = (DavaFlowSet)input;
        return inSet;
    }

    @Override
    public Object processSynchronizedLocal(Local local, Object input) {
        if (!(input instanceof DavaFlowSet)) {
            throw new RuntimeException("processCondition is not implemented for other flowSet types");
        }
        DavaFlowSet inSet = (DavaFlowSet)input;
        return inSet;
    }

    @Override
    public Object processSwitchKey(Value key, Object input) {
        if (!(input instanceof DavaFlowSet)) {
            throw new RuntimeException("processCondition is not implemented for other flowSet types");
        }
        DavaFlowSet inSet = (DavaFlowSet)input;
        return inSet;
    }

    @Override
    public Object processStatement(Stmt s, Object input) {
        if (!(input instanceof DavaFlowSet)) {
            throw new RuntimeException("processStatement is not implemented for other flowSet types");
        }
        DavaFlowSet inSet = (DavaFlowSet)input;
        if (inSet == this.NOPATH) {
            return inSet;
        }
        if (s instanceof DefinitionStmt) {
            DavaFlowSet toReturn = (DavaFlowSet)this.cloneFlowSet(inSet);
            Value leftOp = ((DefinitionStmt)s).getLeftOp();
            if (leftOp instanceof Local) {
                this.kill(toReturn, (Local)leftOp);
                this.gen(toReturn, (DefinitionStmt)s);
                return toReturn;
            }
        }
        return input;
    }

    public void gen(DavaFlowSet in, DefinitionStmt s) {
        in.add(s);
    }

    public void kill(DavaFlowSet in, Local redefined) {
        String redefinedLocalName = redefined.getName();
        List list = in.toList();
        for (DefinitionStmt tempStmt : list) {
            String storedLocalName;
            Value leftOp = tempStmt.getLeftOp();
            if (!(leftOp instanceof Local) || redefinedLocalName.compareTo(storedLocalName = ((Local)leftOp).getName()) != 0) continue;
            in.remove(tempStmt);
        }
    }

    public List<DefinitionStmt> getReachingDefs(Local local, Object node) {
        ArrayList<DefinitionStmt> toReturn = new ArrayList<DefinitionStmt>();
        Object beforeSet = null;
        beforeSet = node instanceof ASTWhileNode || node instanceof ASTDoWhileNode || node instanceof ASTUnconditionalLoopNode || node instanceof ASTForLoopNode ? this.getAfterSet(node) : this.getBeforeSet(node);
        if (beforeSet == null) {
            throw new RuntimeException("Could not get reaching defs of node");
        }
        if (!(beforeSet instanceof DavaFlowSet)) {
            throw new RuntimeException("Reaching def set is not a Dava FlowSet");
        }
        DavaFlowSet beforeSetReaching = (DavaFlowSet)beforeSet;
        List allReachingDefs = beforeSetReaching.toList();
        for (Object temp : allReachingDefs) {
            if (!(temp instanceof DefinitionStmt)) {
                throw new RuntimeException("Not an instanceof DefinitionStmt" + temp);
            }
            DefinitionStmt stmt = (DefinitionStmt)temp;
            Value leftOp = stmt.getLeftOp();
            if (leftOp.toString().compareTo(local.toString()) != 0) continue;
            toReturn.add(stmt);
        }
        return toReturn;
    }

    public void reachingDefsToString(Object node) {
        ArrayList toReturn = new ArrayList();
        Object beforeSet = null;
        beforeSet = node instanceof ASTWhileNode || node instanceof ASTDoWhileNode || node instanceof ASTUnconditionalLoopNode || node instanceof ASTForLoopNode ? this.getAfterSet(node) : this.getBeforeSet(node);
        if (beforeSet == null) {
            throw new RuntimeException("Could not get reaching defs of node");
        }
        if (!(beforeSet instanceof DavaFlowSet)) {
            throw new RuntimeException("Reaching def set is not a Dava FlowSet");
        }
        DavaFlowSet beforeSetReaching = (DavaFlowSet)beforeSet;
        List allReachingDefs = beforeSetReaching.toList();
        Iterator it = allReachingDefs.iterator();
        while (it.hasNext()) {
            System.out.println("Reaching def:" + it.next());
        }
    }
}

