/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.internal.asg;

import java.util.LinkedList;
import java.util.List;
import soot.G;
import soot.dava.internal.SET.SETNode;
import soot.jimple.Stmt;
import soot.util.IterableSet;

public class AugmentedStmt {
    public List bpreds;
    public List bsuccs;
    public List cpreds;
    public List csuccs;
    public SETNode myNode;
    private final IterableSet dominators;
    private IterableSet reachers;
    private Stmt s;

    public AugmentedStmt(Stmt s) {
        this.s = s;
        this.dominators = new IterableSet();
        this.reachers = new IterableSet();
        this.reset_PredsSuccs();
    }

    public void set_Stmt(Stmt s) {
        this.s = s;
    }

    public boolean add_BPred(AugmentedStmt bpred) {
        if (!this.add_CPred(bpred)) {
            return false;
        }
        if (this.bpreds.contains(bpred)) {
            this.cpreds.remove(bpred);
            return false;
        }
        this.bpreds.add(bpred);
        return true;
    }

    public boolean add_BSucc(AugmentedStmt bsucc) {
        if (!this.add_CSucc(bsucc)) {
            return false;
        }
        if (this.bsuccs.contains(bsucc)) {
            this.csuccs.remove(bsucc);
            return false;
        }
        this.bsuccs.add(bsucc);
        return true;
    }

    public boolean add_CPred(AugmentedStmt cpred) {
        if (!this.cpreds.contains(cpred)) {
            this.cpreds.add(cpred);
            return true;
        }
        return false;
    }

    public boolean add_CSucc(AugmentedStmt csucc) {
        if (!this.csuccs.contains(csucc)) {
            this.csuccs.add(csucc);
            return true;
        }
        return false;
    }

    public boolean remove_BPred(AugmentedStmt bpred) {
        if (!this.remove_CPred(bpred)) {
            return false;
        }
        if (this.bpreds.contains(bpred)) {
            this.bpreds.remove(bpred);
            return true;
        }
        this.cpreds.add(bpred);
        return false;
    }

    public boolean remove_BSucc(AugmentedStmt bsucc) {
        if (!this.remove_CSucc(bsucc)) {
            return false;
        }
        if (this.bsuccs.contains(bsucc)) {
            this.bsuccs.remove(bsucc);
            return true;
        }
        this.csuccs.add(bsucc);
        return false;
    }

    public boolean remove_CPred(AugmentedStmt cpred) {
        if (this.cpreds.contains(cpred)) {
            this.cpreds.remove(cpred);
            return true;
        }
        return false;
    }

    public boolean remove_CSucc(AugmentedStmt csucc) {
        if (this.csuccs.contains(csucc)) {
            this.csuccs.remove(csucc);
            return true;
        }
        return false;
    }

    public Stmt get_Stmt() {
        return this.s;
    }

    public IterableSet get_Dominators() {
        return this.dominators;
    }

    public IterableSet get_Reachers() {
        return this.reachers;
    }

    public void set_Reachability(IterableSet reachers) {
        this.reachers = reachers;
    }

    public void dump() {
        G.v().out.println(this.toString());
    }

    public String toString() {
        return "(" + this.s.toString() + " @ " + this.hashCode() + ")";
    }

    public void reset_PredsSuccs() {
        this.bpreds = new LinkedList();
        this.bsuccs = new LinkedList();
        this.cpreds = new LinkedList();
        this.csuccs = new LinkedList();
    }

    public Object clone() {
        return new AugmentedStmt((Stmt)this.s.clone());
    }
}

