/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.internal.AST;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Local;
import soot.SootClass;
import soot.UnitPrinter;
import soot.dava.internal.AST.ASTLabeledNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.SET.SETNodeLabel;
import soot.dava.toolkits.base.AST.ASTAnalysis;
import soot.dava.toolkits.base.AST.TryContentsFinder;
import soot.dava.toolkits.base.AST.analysis.Analysis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTTryNode
extends ASTLabeledNode {
    private List<Object> tryBody;
    private List<Object> catchList;
    private Map<Object, Object> exceptionMap;
    private Map<Object, Object> paramMap;
    private container tryBodyContainer;

    public ASTTryNode(SETNodeLabel label, List<Object> tryBody, List<Object> catchList, Map<Object, Object> exceptionMap, Map<Object, Object> paramMap) {
        super(label);
        this.tryBody = tryBody;
        this.tryBodyContainer = new container(tryBody);
        this.catchList = new ArrayList<Object>();
        Iterator<Object> cit = catchList.iterator();
        while (cit.hasNext()) {
            this.catchList.add(new container(cit.next()));
        }
        this.exceptionMap = new HashMap<Object, Object>();
        for (container container2 : this.catchList) {
            this.exceptionMap.put(container2, exceptionMap.get(container2.o));
        }
        this.paramMap = new HashMap<Object, Object>();
        for (container container3 : this.catchList) {
            this.paramMap.put(container3, paramMap.get(container3.o));
        }
        this.subBodies.add(this.tryBodyContainer);
        cit = this.catchList.iterator();
        while (cit.hasNext()) {
            this.subBodies.add(cit.next());
        }
    }

    public void replaceTryBody(List<Object> tryBody) {
        this.tryBody = tryBody;
        this.tryBodyContainer = new container(tryBody);
        List oldSubBodies = this.subBodies;
        this.subBodies = new ArrayList();
        this.subBodies.add(this.tryBodyContainer);
        Iterator oldIt = oldSubBodies.iterator();
        oldIt.next();
        while (oldIt.hasNext()) {
            this.subBodies.add(oldIt.next());
        }
    }

    @Override
    protected void perform_AnalysisOnSubBodies(ASTAnalysis a) {
        if (a instanceof TryContentsFinder) {
            for (container subBody : this.subBodies) {
                for (ASTNode n : (List)subBody.o) {
                    n.perform_Analysis(a);
                    TryContentsFinder.v().add_ExceptionSet(subBody, TryContentsFinder.v().get_ExceptionSet(n));
                }
            }
            a.analyseASTNode(this);
        } else {
            super.perform_AnalysisOnSubBodies(a);
        }
    }

    public boolean isEmpty() {
        return this.tryBody.isEmpty();
    }

    public List<Object> get_TryBody() {
        return this.tryBody;
    }

    public container get_TryBodyContainer() {
        return this.tryBodyContainer;
    }

    public List<Object> get_CatchList() {
        return this.catchList;
    }

    public Map<Object, Object> get_ExceptionMap() {
        return this.exceptionMap;
    }

    public Map<Object, Object> get_ParamMap() {
        return this.paramMap;
    }

    public Set<Object> get_ExceptionSet() {
        HashSet<Object> s = new HashSet<Object>();
        Iterator<Object> it = this.catchList.iterator();
        while (it.hasNext()) {
            s.add(this.exceptionMap.get(it.next()));
        }
        return s;
    }

    @Override
    public Object clone() {
        ArrayList<Object> newCatchList = new ArrayList<Object>();
        Iterator<Object> it = this.catchList.iterator();
        while (it.hasNext()) {
            newCatchList.add(((container)it.next()).o);
        }
        return new ASTTryNode(this.get_Label(), this.tryBody, newCatchList, this.exceptionMap, this.paramMap);
    }

    @Override
    public void toString(UnitPrinter up) {
        this.label_toString(up);
        up.literal("try");
        up.newline();
        up.literal("{");
        up.newline();
        up.incIndent();
        this.body_toString(up, this.tryBody);
        up.decIndent();
        up.literal("}");
        up.newline();
        for (container container2 : this.catchList) {
            up.literal("catch");
            up.literal(" ");
            up.literal("(");
            up.type(((SootClass)this.exceptionMap.get(container2)).getType());
            up.literal(" ");
            up.local((Local)this.paramMap.get(container2));
            up.literal(")");
            up.newline();
            up.literal("{");
            up.newline();
            up.incIndent();
            this.body_toString(up, (List)container2.o);
            up.decIndent();
            up.literal("}");
            up.newline();
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.label_toString());
        b.append("try");
        b.append("\n");
        b.append("{");
        b.append("\n");
        b.append(this.body_toString(this.tryBody));
        b.append("}");
        b.append("\n");
        for (container container2 : this.catchList) {
            b.append("catch (");
            b.append(((SootClass)this.exceptionMap.get(container2)).getName());
            b.append(" ");
            b.append(((Local)this.paramMap.get(container2)).getName());
            b.append(")");
            b.append("\n");
            b.append("{");
            b.append("\n");
            b.append(this.body_toString((List)container2.o));
            b.append("}");
            b.append("\n");
        }
        return b.toString();
    }

    @Override
    public void apply(Analysis a) {
        a.caseASTTryNode(this);
    }

    public class container {
        public Object o;

        public container(Object o) {
            this.o = o;
        }

        public void replaceBody(Object newBody) {
            this.o = newBody;
        }
    }
}

