/*
 * Decompiled with CFR 0.152.
 */
package soot.dava;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.LongType;
import soot.Modifier;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.dava.Dava;
import soot.dava.DavaBody;
import soot.dava.DavaUnitPrinter;
import soot.dava.DecompilationException;
import soot.dava.internal.AST.ASTNode;
import soot.dava.toolkits.base.renamer.RemoveFullyQualifiedName;
import soot.options.Options;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.StringConstantValueTag;
import soot.tagkit.Tag;
import soot.util.IterableSet;

public class DavaPrinter {
    public DavaPrinter(Singletons.Global g) {
    }

    public static DavaPrinter v() {
        return G.v().soot_dava_DavaPrinter();
    }

    private void printStatementsInBody(Body body, PrintWriter out) {
        PatchingChain<Unit> units;
        if (Options.v().verbose()) {
            System.out.println("Printing " + body.getMethod().getName());
        }
        if ((units = ((DavaBody)body).getUnits()).size() != 1) {
            throw new RuntimeException("DavaBody AST doesn't have single root.");
        }
        DavaUnitPrinter up = new DavaUnitPrinter((DavaBody)body);
        ((ASTNode)units.getFirst()).toString(up);
        out.print(((Object)up).toString());
    }

    public void printTo(SootClass cl, PrintWriter out) {
        Iterator<SootMethod> methodIt;
        Iterator<SootClass> interfaceIt;
        IterableSet importList = new IterableSet();
        String curPackage = cl.getJavaPackageName();
        if (!curPackage.equals("")) {
            out.println("package " + curPackage + ";");
            out.println();
        }
        if (cl.hasSuperclass()) {
            SootClass superClass = cl.getSuperclass();
            importList.add(superClass.toString());
        }
        Iterator<SootClass> interfaceIt2 = cl.getInterfaces().iterator();
        while (interfaceIt2.hasNext()) {
            String interfacePackage = interfaceIt2.next().toString();
            if (importList.contains(interfacePackage)) continue;
            importList.add(interfacePackage);
        }
        Iterator<SootMethod> methodIt2 = cl.methodIterator();
        while (methodIt2.hasNext()) {
            String returnPackage;
            Type t2;
            SootMethod dm = methodIt2.next();
            if (dm.hasActiveBody()) {
                importList = importList.union(((DavaBody)dm.getActiveBody()).getImportList());
            }
            Iterator<SootClass> eit = dm.getExceptions().iterator();
            while (eit.hasNext()) {
                String thrownPackage = eit.next().toString();
                if (importList.contains(thrownPackage)) continue;
                importList.add(thrownPackage);
            }
            for (Type t2 : dm.getParameterTypes()) {
                String paramPackage;
                if (!(t2 instanceof RefType) || importList.contains(paramPackage = ((RefType)t2).getSootClass().toString())) continue;
                importList.add(paramPackage);
            }
            t2 = dm.getReturnType();
            if (!(t2 instanceof RefType) || importList.contains(returnPackage = ((RefType)t2).getSootClass().toString())) continue;
            importList.add(returnPackage);
        }
        for (SootField f : cl.getFields()) {
            String fieldPackage;
            Type t;
            if (f.isPhantom() || !((t = f.getType()) instanceof RefType) || importList.contains(fieldPackage = ((RefType)t).getSootClass().toString())) continue;
            importList.add(fieldPackage);
        }
        Iterator pit = importList.iterator();
        ArrayList<String> toImport = new ArrayList<String>();
        while (pit.hasNext()) {
            String temp = (String)pit.next();
            if (temp.indexOf("java.lang") > -1) {
                String tempClassName = RemoveFullyQualifiedName.getClassName(temp);
                if (temp.equals("java.lang." + tempClassName)) continue;
            }
            if (curPackage.length() > 0 && temp.indexOf(curPackage) > -1 || cl.toString().equals(temp)) continue;
            toImport.add(temp);
        }
        for (String temp : toImport) {
            if (RemoveFullyQualifiedName.containsMultiple(toImport.iterator(), temp, null)) {
                if (temp.lastIndexOf(46) > -1) {
                    temp = temp.substring(0, temp.lastIndexOf(46));
                    out.println("import " + temp + ".*;");
                    continue;
                }
                throw new DecompilationException("Cant find the DOT . for fullyqualified name");
            }
            if (temp.lastIndexOf(46) == -1) continue;
            out.println("import " + temp + ";");
        }
        boolean addNewLine = false;
        addNewLine = true;
        if (addNewLine) {
            out.println();
        }
        Dava.v().set_CurrentPackageContext(importList);
        Dava.v().set_CurrentPackage(curPackage);
        String classPrefix = "";
        classPrefix = classPrefix + " " + Modifier.toString(cl.getModifiers());
        classPrefix = classPrefix.trim();
        if (!cl.isInterface()) {
            classPrefix = classPrefix + " class";
            classPrefix = classPrefix.trim();
        }
        out.print(classPrefix + " " + cl.getShortJavaStyleName());
        if (cl.hasSuperclass() && !cl.getSuperclass().getName().equals("java.lang.Object")) {
            String superClassName = cl.getSuperclass().getName();
            superClassName = RemoveFullyQualifiedName.getReducedName(importList, superClassName, cl.getType());
            out.print(" extends " + superClassName + "");
        }
        if ((interfaceIt = cl.getInterfaces().iterator()).hasNext()) {
            if (cl.isInterface()) {
                out.print(" extends ");
            } else {
                out.print(" implements ");
            }
            out.print("" + interfaceIt.next().getName() + "");
            while (interfaceIt.hasNext()) {
                out.print(", " + interfaceIt.next().getName() + "");
            }
        }
        out.println();
        out.println("{");
        Iterator<SootField> fieldIt = cl.getFields().iterator();
        if (fieldIt.hasNext()) {
            while (fieldIt.hasNext()) {
                SootField f = fieldIt.next();
                if (f.isPhantom()) continue;
                String declaration = null;
                Type fieldType = f.getType();
                String qualifiers = Modifier.toString(f.getModifiers()) + " ";
                qualifiers = qualifiers + RemoveFullyQualifiedName.getReducedName(importList, fieldType.toString(), fieldType);
                declaration = (qualifiers = qualifiers.trim()).equals("") ? Scene.v().quotedNameOf(f.getName()) : qualifiers + " " + Scene.v().quotedNameOf(f.getName()) + "";
                if (f.isFinal() && f.isStatic()) {
                    if (fieldType instanceof DoubleType && f.hasTag("DoubleConstantValueTag")) {
                        double val = ((DoubleConstantValueTag)f.getTag("DoubleConstantValueTag")).getDoubleValue();
                        out.println("    " + declaration + " = " + val + ";");
                        continue;
                    }
                    if (fieldType instanceof FloatType && f.hasTag("FloatConstantValueTag")) {
                        float val = ((FloatConstantValueTag)f.getTag("FloatConstantValueTag")).getFloatValue();
                        out.println("    " + declaration + " = " + val + "f;");
                        continue;
                    }
                    if (fieldType instanceof LongType && f.hasTag("LongConstantValueTag")) {
                        long val = ((LongConstantValueTag)f.getTag("LongConstantValueTag")).getLongValue();
                        out.println("    " + declaration + " = " + val + "l;");
                        continue;
                    }
                    if (fieldType instanceof CharType && f.hasTag("IntegerConstantValueTag")) {
                        int val = ((IntegerConstantValueTag)f.getTag("IntegerConstantValueTag")).getIntValue();
                        out.println("    " + declaration + " = '" + (char)val + "';");
                        continue;
                    }
                    if (fieldType instanceof BooleanType && f.hasTag("IntegerConstantValueTag")) {
                        int val = ((IntegerConstantValueTag)f.getTag("IntegerConstantValueTag")).getIntValue();
                        if (val == 0) {
                            out.println("    " + declaration + " = false;");
                            continue;
                        }
                        out.println("    " + declaration + " = true;");
                        continue;
                    }
                    if ((fieldType instanceof IntType || fieldType instanceof ByteType || fieldType instanceof ShortType) && f.hasTag("IntegerConstantValueTag")) {
                        int val = ((IntegerConstantValueTag)f.getTag("IntegerConstantValueTag")).getIntValue();
                        out.println("    " + declaration + " = " + val + ";");
                        continue;
                    }
                    if (f.hasTag("StringConstantValueTag")) {
                        String val = ((StringConstantValueTag)f.getTag("StringConstantValueTag")).getStringValue();
                        out.println("    " + declaration + " = \"" + val + "\";");
                        continue;
                    }
                    out.println("    " + declaration + ";");
                    continue;
                }
                out.println("    " + declaration + ";");
            }
        }
        if ((methodIt = cl.methodIterator()).hasNext()) {
            if (cl.getMethodCount() != 0) {
                out.println();
            }
            while (methodIt.hasNext()) {
                SootMethod method = methodIt.next();
                if (method.isPhantom()) continue;
                if (!Modifier.isAbstract(method.getModifiers()) && !Modifier.isNative(method.getModifiers())) {
                    if (!method.hasActiveBody()) {
                        throw new RuntimeException("method " + method.getName() + " has no active body!");
                    }
                    this.printTo(method.getActiveBody(), out);
                    if (!methodIt.hasNext()) continue;
                    out.println();
                    continue;
                }
                out.print("    ");
                out.print(method.getDavaDeclaration());
                out.println(";");
                if (!methodIt.hasNext()) continue;
                out.println();
            }
        }
        if (G.v().SootClassNeedsDavaSuperHandlerClass.contains(cl)) {
            out.println("\n    private static class DavaSuperHandler{");
            out.println("         java.util.Vector myVector = new java.util.Vector();");
            out.println("\n         public Object get(int pos){");
            out.println("            return myVector.elementAt(pos);");
            out.println("         }");
            out.println("\n         public void store(Object obj){");
            out.println("            myVector.add(obj);");
            out.println("         }");
            out.println("    }");
        }
        out.println("}");
    }

    private void printTo(Body b, PrintWriter out) {
        b.validate();
        String decl = b.getMethod().getDavaDeclaration();
        out.println("    " + decl);
        for (Tag t : b.getMethod().getTags()) {
            if (!Options.v().print_tags_in_output()) continue;
            out.println(t);
        }
        out.println("    {");
        this.printStatementsInBody(b, out);
        out.println("    }");
    }
}

