/*
 * Decompiled with CFR 0.152.
 */
package soot.dava;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.RefType;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.ValueBox;
import soot.dava.Dava;
import soot.dava.DecompilationException;
import soot.dava.RetriggerAnalysisException;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.SET.SETNode;
import soot.dava.internal.SET.SETTopNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.asg.AugmentedStmtGraph;
import soot.dava.internal.javaRep.DCmpExpr;
import soot.dava.internal.javaRep.DCmpgExpr;
import soot.dava.internal.javaRep.DCmplExpr;
import soot.dava.internal.javaRep.DInstanceFieldRef;
import soot.dava.internal.javaRep.DIntConstant;
import soot.dava.internal.javaRep.DInterfaceInvokeExpr;
import soot.dava.internal.javaRep.DLengthExpr;
import soot.dava.internal.javaRep.DNegExpr;
import soot.dava.internal.javaRep.DNewArrayExpr;
import soot.dava.internal.javaRep.DNewInvokeExpr;
import soot.dava.internal.javaRep.DNewMultiArrayExpr;
import soot.dava.internal.javaRep.DSpecialInvokeExpr;
import soot.dava.internal.javaRep.DStaticFieldRef;
import soot.dava.internal.javaRep.DStaticInvokeExpr;
import soot.dava.internal.javaRep.DThisRef;
import soot.dava.internal.javaRep.DVirtualInvokeExpr;
import soot.dava.toolkits.base.AST.UselessTryRemover;
import soot.dava.toolkits.base.AST.transformations.ASTCleaner;
import soot.dava.toolkits.base.AST.transformations.ASTCleanerTwo;
import soot.dava.toolkits.base.AST.transformations.AndAggregator;
import soot.dava.toolkits.base.AST.transformations.BooleanConditionSimplification;
import soot.dava.toolkits.base.AST.transformations.DeInliningFinalFields;
import soot.dava.toolkits.base.AST.transformations.DecrementIncrementStmtCreation;
import soot.dava.toolkits.base.AST.transformations.FinalFieldDefinition;
import soot.dava.toolkits.base.AST.transformations.ForLoopCreator;
import soot.dava.toolkits.base.AST.transformations.IfElseSplitter;
import soot.dava.toolkits.base.AST.transformations.LocalVariableCleaner;
import soot.dava.toolkits.base.AST.transformations.LoopStrengthener;
import soot.dava.toolkits.base.AST.transformations.NewStringBufferSimplification;
import soot.dava.toolkits.base.AST.transformations.OrAggregatorFour;
import soot.dava.toolkits.base.AST.transformations.OrAggregatorOne;
import soot.dava.toolkits.base.AST.transformations.OrAggregatorTwo;
import soot.dava.toolkits.base.AST.transformations.PushLabeledBlockIn;
import soot.dava.toolkits.base.AST.transformations.ShortcutArrayInit;
import soot.dava.toolkits.base.AST.transformations.ShortcutIfGenerator;
import soot.dava.toolkits.base.AST.transformations.SuperFirstStmtHandler;
import soot.dava.toolkits.base.AST.transformations.TypeCastingError;
import soot.dava.toolkits.base.AST.transformations.UselessAbruptStmtRemover;
import soot.dava.toolkits.base.AST.transformations.UselessLabeledBlockRemover;
import soot.dava.toolkits.base.AST.traversals.ClosestAbruptTargetFinder;
import soot.dava.toolkits.base.AST.traversals.CopyPropagation;
import soot.dava.toolkits.base.finders.AbruptEdgeFinder;
import soot.dava.toolkits.base.finders.CycleFinder;
import soot.dava.toolkits.base.finders.ExceptionFinder;
import soot.dava.toolkits.base.finders.IfFinder;
import soot.dava.toolkits.base.finders.LabeledBlockFinder;
import soot.dava.toolkits.base.finders.SequenceFinder;
import soot.dava.toolkits.base.finders.SwitchFinder;
import soot.dava.toolkits.base.finders.SynchronizedBlockFinder;
import soot.dava.toolkits.base.misc.MonitorConverter;
import soot.dava.toolkits.base.misc.ThrowNullConverter;
import soot.grimp.GrimpBody;
import soot.grimp.NewInvokeExpr;
import soot.jimple.ArrayRef;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.ConditionExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.Expr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LengthExpr;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.MonitorStmt;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.ParameterRef;
import soot.jimple.Ref;
import soot.jimple.ReturnStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.UnopExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.internal.JGotoStmt;
import soot.jimple.internal.JimpleLocal;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.TrapUnitGraph;
import soot.util.IterableSet;
import soot.util.Switchable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DavaBody
extends Body {
    public boolean DEBUG = false;
    private Map pMap = new HashMap();
    private HashSet<Object> consumedConditions = new HashSet();
    private HashSet<Object> thisLocals = new HashSet();
    private IterableSet synchronizedBlockFacts = new IterableSet();
    private IterableSet exceptionFacts = new IterableSet();
    private IterableSet monitorFacts = new IterableSet();
    private IterableSet importList = new IterableSet();
    private Local controlLocal = null;
    private InstanceInvokeExpr constructorExpr = null;
    private Unit constructorUnit;
    private List caughtrefs = new LinkedList();

    DavaBody(SootMethod m) {
        super(m);
    }

    public Unit get_ConstructorUnit() {
        return this.constructorUnit;
    }

    public List get_CaughtRefs() {
        return this.caughtrefs;
    }

    public InstanceInvokeExpr get_ConstructorExpr() {
        return this.constructorExpr;
    }

    public void set_ConstructorExpr(InstanceInvokeExpr expr) {
        this.constructorExpr = expr;
    }

    public void set_ConstructorUnit(Unit s) {
        this.constructorUnit = s;
    }

    public Map get_ParamMap() {
        return this.pMap;
    }

    public void set_ParamMap(Map map) {
        this.pMap = map;
    }

    public HashSet<Object> get_ThisLocals() {
        return this.thisLocals;
    }

    public Local get_ControlLocal() {
        if (this.controlLocal == null) {
            this.controlLocal = new JimpleLocal("controlLocal", IntType.v());
            this.getLocals().add(this.controlLocal);
        }
        return this.controlLocal;
    }

    public Set<Object> get_ConsumedConditions() {
        return this.consumedConditions;
    }

    public void consume_Condition(AugmentedStmt as) {
        this.consumedConditions.add(as);
    }

    @Override
    public Object clone() {
        DavaBody b = Dava.v().newBody(this.getMethod());
        b.importBodyContentsFrom(this);
        return b;
    }

    public IterableSet get_SynchronizedBlockFacts() {
        return this.synchronizedBlockFacts;
    }

    public IterableSet get_ExceptionFacts() {
        return this.exceptionFacts;
    }

    public IterableSet get_MonitorFacts() {
        return this.monitorFacts;
    }

    public IterableSet getImportList() {
        return this.importList;
    }

    DavaBody(Body body) {
        this(body.getMethod());
        this.debug("DavaBody", "creating DavaBody for" + body.getMethod().toString());
        Dava.v().log("\nstart method " + body.getMethod().toString());
        if (this.DEBUG && body.getMethod().getExceptions().size() != 0) {
            this.debug("DavaBody", "printing NON EMPTY exception list for " + body.getMethod().toString() + " " + body.getMethod().getExceptions().toString());
        }
        this.copy_Body(body);
        AugmentedStmtGraph asg = new AugmentedStmtGraph(new BriefUnitGraph(this), new TrapUnitGraph(this));
        ExceptionFinder.v().preprocess(this, asg);
        SETTopNode SET = new SETTopNode(asg.get_ChainView());
        while (true) {
            try {
                CycleFinder.v().find(this, asg, SET);
                IfFinder.v().find(this, asg, SET);
                SwitchFinder.v().find(this, asg, SET);
                SynchronizedBlockFinder.v().find(this, asg, SET);
                ExceptionFinder.v().find(this, asg, SET);
                SequenceFinder.v().find(this, asg, SET);
                LabeledBlockFinder.v().find(this, asg, SET);
                AbruptEdgeFinder.v().find(this, asg, SET);
            }
            catch (RetriggerAnalysisException rae) {
                SET = new SETTopNode(asg.get_ChainView());
                this.consumedConditions = new HashSet();
                continue;
            }
            break;
        }
        MonitorConverter.v().convert(this);
        ThrowNullConverter.v().convert(this);
        ASTNode AST = ((SETNode)SET).emit_AST();
        this.getTraps().clear();
        this.getUnits().clear();
        this.getUnits().addLast(AST);
        do {
            G.v().ASTAnalysis_modified = false;
            AST.perform_Analysis(UselessTryRemover.v());
        } while (G.v().ASTAnalysis_modified);
        if (AST instanceof ASTMethodNode) {
            ((ASTMethodNode)AST).storeLocals(this);
            Map options = PhaseOptions.v().getPhaseOptions("db.force-recompile");
            boolean force = PhaseOptions.getBoolean(options, "enabled");
            if (force) {
                AST.apply(new SuperFirstStmtHandler((ASTMethodNode)AST));
            }
            this.debug("DavaBody", "PreInit booleans is" + G.v().SootMethodAddedByDava);
        }
        Dava.v().log("end method " + body.getMethod().toString());
    }

    public void applyBugFixes() {
        ASTNode AST = (ASTNode)this.getUnits().getFirst();
        this.debug("applyBugFixes", "Applying AST analyzes for method" + this.getMethod().toString());
        AST.apply(new ShortcutIfGenerator());
        this.debug("applyBugFixes", "after ShortcutIfGenerator" + G.v().ASTTransformations_modified);
        AST.apply(new TypeCastingError());
        this.debug("applyBugFixes", "after TypeCastingError" + G.v().ASTTransformations_modified);
    }

    public void analyzeAST() {
        ASTNode AST = (ASTNode)this.getUnits().getFirst();
        this.debug("analyzeAST", "Applying AST analyzes for method" + this.getMethod().toString());
        this.applyASTAnalyses(AST);
        this.debug("analyzeAST", "Applying structure analysis" + this.getMethod().toString());
        this.applyStructuralAnalyses(AST);
        this.debug("analyzeAST", "Applying structure analysis DONE" + this.getMethod().toString());
    }

    private void applyASTAnalyses(ASTNode AST) {
        this.debug("applyASTAnalyses", "initial one time analyses started");
        AST.apply(new BooleanConditionSimplification());
        AST.apply(new DecrementIncrementStmtCreation());
        this.debug("applyASTAnalyses", "initial one time analyses completed");
        boolean flag = true;
        int times = 0;
        G.v().ASTTransformations_modified = false;
        G.v().ASTIfElseFlipped = false;
        int countFlipping = 0;
        if (flag) {
            do {
                this.debug("applyASTAnalyses", "ITERATION");
                G.v().ASTTransformations_modified = false;
                ++times;
                AST.apply(new AndAggregator());
                this.debug("applyASTAnalyses", "after AndAggregator" + G.v().ASTTransformations_modified);
                AST.apply(new OrAggregatorOne());
                this.debug("applyASTAnalyses", "after OraggregatorOne" + G.v().ASTTransformations_modified);
                AST.apply(new OrAggregatorTwo());
                this.debug("applyASTAnalyses", "after OraggregatorTwo" + G.v().ASTTransformations_modified);
                this.debug("applyASTAnalyses", "after OraggregatorTwo ifElseFlipped is" + G.v().ASTIfElseFlipped);
                AST.apply(new OrAggregatorFour());
                this.debug("applyASTAnalyses", "after OraggregatorFour" + G.v().ASTTransformations_modified);
                AST.apply(new ASTCleaner());
                this.debug("applyASTAnalyses", "after ASTCleaner" + G.v().ASTTransformations_modified);
                AST.apply(new PushLabeledBlockIn());
                this.debug("applyASTAnalyses", "after PushLabeledBlockIn" + G.v().ASTTransformations_modified);
                AST.apply(new LoopStrengthener());
                this.debug("applyASTAnalyses", "after LoopStrengthener" + G.v().ASTTransformations_modified);
                AST.apply(new ASTCleanerTwo());
                this.debug("applyASTAnalyses", "after ASTCleanerTwo" + G.v().ASTTransformations_modified);
                AST.apply(new ForLoopCreator());
                this.debug("applyASTAnalyses", "after ForLoopCreator" + G.v().ASTTransformations_modified);
                AST.apply(new NewStringBufferSimplification());
                this.debug("applyASTAnalyses", "after NewStringBufferSimplification" + G.v().ASTTransformations_modified);
                AST.apply(new ShortcutArrayInit());
                this.debug("applyASTAnalyses", "after ShortcutArrayInit" + G.v().ASTTransformations_modified);
                AST.apply(new UselessLabeledBlockRemover());
                this.debug("applyASTAnalyses", "after UselessLabeledBlockRemover" + G.v().ASTTransformations_modified);
                if (!G.v().ASTTransformations_modified) {
                    AST.apply(new IfElseSplitter());
                    this.debug("applyASTAnalyses", "after IfElseSplitter" + G.v().ASTTransformations_modified);
                }
                if (!G.v().ASTTransformations_modified) {
                    AST.apply(new UselessAbruptStmtRemover());
                    this.debug("applyASTAnalyses", "after UselessAbruptStmtRemover" + G.v().ASTTransformations_modified);
                }
                AST.apply(new ShortcutIfGenerator());
                this.debug("applyASTAnalyses", "after ShortcutIfGenerator" + G.v().ASTTransformations_modified);
                AST.apply(new TypeCastingError());
                this.debug("applyASTAnalyses", "after TypeCastingError" + G.v().ASTTransformations_modified);
                if (G.v().ASTTransformations_modified) {
                    G.v().ASTIfElseFlipped = false;
                    countFlipping = 0;
                    this.debug("applyASTanalyses", "Transformation modified was true hence will reiterate. set flipped to false");
                    continue;
                }
                if (!G.v().ASTIfElseFlipped) continue;
                this.debug("", "ifelseflipped and transformations NOT modified");
                if (countFlipping == 0) {
                    this.debug("", "ifelseflipped and transformations NOT modified count is 0");
                    G.v().ASTIfElseFlipped = false;
                    ++countFlipping;
                    G.v().ASTTransformations_modified = true;
                    continue;
                }
                this.debug("", "ifelseflipped and transformations NOT modified count is not 0 TERMINATE");
            } while (G.v().ASTTransformations_modified);
        }
        AST.apply(ClosestAbruptTargetFinder.v());
        this.debug("applyASTAnalyses", "after ClosestAbruptTargetFinder" + G.v().ASTTransformations_modified);
        Map options = PhaseOptions.v().getPhaseOptions("db.force-recompile");
        boolean force = PhaseOptions.getBoolean(options, "enabled");
        if (force) {
            this.debug("applyASTAnalyses", "before FinalFieldDefinition" + G.v().ASTTransformations_modified);
            new FinalFieldDefinition((ASTMethodNode)AST);
            this.debug("applyASTAnalyses", "after FinalFieldDefinition" + G.v().ASTTransformations_modified);
        }
        AST.apply(new DeInliningFinalFields());
        this.debug("applyASTAnalyses", "end applyASTAnlayses" + G.v().ASTTransformations_modified);
    }

    private void applyStructuralAnalyses(ASTNode AST) {
        this.debug("applyStructureAnalyses", "invoking copy propagation");
        CopyPropagation prop = new CopyPropagation(AST);
        AST.apply(prop);
        this.debug("applyStructureAnalyses", "invoking copy propagation DONE");
        this.debug("applyStructureAnalyses", "Local Variable Cleaner started");
        AST.apply(new LocalVariableCleaner(AST));
        this.debug("applyStructureAnalyses", "Local Variable Cleaner DONE");
    }

    private void copy_Body(Body body) {
        Switchable copy;
        if (!(body instanceof GrimpBody)) {
            throw new RuntimeException("You can only create a DavaBody from a GrimpBody!");
        }
        GrimpBody grimpBody = (GrimpBody)body;
        HashMap<Switchable, Unit> bindings = new HashMap<Switchable, Unit>();
        HashMap<Unit, Unit> hashMap = new HashMap<Unit, Unit>();
        for (Unit unit : grimpBody.getUnits()) {
            copy = (Unit)unit.clone();
            this.getUnits().addLast((Unit)copy);
            bindings.put(unit, (Unit)copy);
            hashMap.put((Unit)copy, unit);
        }
        for (Unit unit : this.getUnits()) {
            Unit[] new_target_list;
            Stmt original_switch;
            Stmt s = (Stmt)unit;
            if (s instanceof TableSwitchStmt) {
                TableSwitchStmt ts = (TableSwitchStmt)s;
                original_switch = (TableSwitchStmt)hashMap.get(unit);
                ts.setDefaultTarget((Unit)bindings.get(original_switch.getDefaultTarget()));
                new_target_list = new LinkedList();
                int target_count = ts.getHighIndex() - ts.getLowIndex() + 1;
                for (int i = 0; i < target_count; ++i) {
                    new_target_list.add((Unit)bindings.get(original_switch.getTarget(i)));
                }
                ts.setTargets((List<Unit>)new_target_list);
            }
            if (!(s instanceof LookupSwitchStmt)) continue;
            LookupSwitchStmt ls = (LookupSwitchStmt)s;
            original_switch = (LookupSwitchStmt)hashMap.get(unit);
            ls.setDefaultTarget((Unit)bindings.get(original_switch.getDefaultTarget()));
            new_target_list = new Unit[original_switch.getTargetCount()];
            for (int i = 0; i < original_switch.getTargetCount(); ++i) {
                new_target_list[i] = (Unit)bindings.get(original_switch.getTarget(i));
            }
            ls.setTargets(new_target_list);
            ls.setLookupValues(original_switch.getLookupValues());
        }
        for (Local local : grimpBody.getLocals()) {
            copy = Dava.v().newLocal(local.getName(), local.getType());
            this.getLocals().addLast((Local)copy);
            bindings.put(local, (Unit)copy);
        }
        for (UnitBox unitBox : this.getAllUnitBoxes()) {
            Unit oldObject = unitBox.getUnit();
            Unit newObject = (Unit)bindings.get(oldObject);
            if (newObject == null) continue;
            unitBox.setUnit(newObject);
        }
        for (ValueBox valueBox : this.getUseAndDefBoxes()) {
            if (!(valueBox.getValue() instanceof Local)) continue;
            valueBox.setValue((Value)bindings.get(valueBox.getValue()));
        }
        for (Trap originalTrap : grimpBody.getTraps()) {
            Trap cloneTrap = (Trap)originalTrap.clone();
            Unit handlerUnit = (Unit)bindings.get(originalTrap.getHandlerUnit());
            cloneTrap.setHandlerUnit(handlerUnit);
            cloneTrap.setBeginUnit((Unit)bindings.get(originalTrap.getBeginUnit()));
            cloneTrap.setEndUnit((Unit)bindings.get(originalTrap.getEndUnit()));
            this.getTraps().add(cloneTrap);
        }
        PatchingChain<Unit> units = this.getUnits();
        Iterator<Unit> iterator = units.snapshotIterator();
        while (iterator.hasNext()) {
            JGotoStmt jgs;
            Unit u = iterator.next();
            Stmt stmt = (Stmt)u;
            if (stmt instanceof IfStmt) {
                IfStmt ifs = (IfStmt)stmt;
                JGotoStmt jgs2 = new JGotoStmt(units.getSuccOf(u));
                units.insertAfter(jgs2, u);
                JGotoStmt jumper = new JGotoStmt(ifs.getTarget());
                units.insertAfter(jumper, (Unit)jgs2);
                ifs.setTarget(jumper);
                continue;
            }
            if (stmt instanceof TableSwitchStmt) {
                TableSwitchStmt tss = (TableSwitchStmt)stmt;
                int targetCount = tss.getHighIndex() - tss.getLowIndex() + 1;
                for (int i = 0; i < targetCount; ++i) {
                    JGotoStmt jgs3 = new JGotoStmt(tss.getTarget(i));
                    units.insertAfter(jgs3, (Unit)tss);
                    tss.setTarget(i, jgs3);
                }
                jgs = new JGotoStmt(tss.getDefaultTarget());
                units.insertAfter(jgs, (Unit)tss);
                tss.setDefaultTarget(jgs);
                continue;
            }
            if (!(stmt instanceof LookupSwitchStmt)) continue;
            LookupSwitchStmt lss = (LookupSwitchStmt)stmt;
            for (int i = 0; i < lss.getTargetCount(); ++i) {
                jgs = new JGotoStmt(lss.getTarget(i));
                units.insertAfter(jgs, (Unit)lss);
                lss.setTarget(i, jgs);
            }
            JGotoStmt jgs4 = new JGotoStmt(lss.getDefaultTarget());
            units.insertAfter(jgs4, (Unit)lss);
            lss.setDefaultTarget(jgs4);
        }
        for (Trap t : this.getTraps()) {
            JGotoStmt jGotoStmt = new JGotoStmt(t.getHandlerUnit());
            units.addLast(jGotoStmt);
            t.setHandlerUnit(jGotoStmt);
        }
        Iterator<Switchable> it2 = this.getLocals().iterator();
        while (it2.hasNext()) {
            String packageName;
            Type type = it2.next().getType();
            if (!(type instanceof RefType)) continue;
            RefType rt = (RefType)type;
            String string = rt.getSootClass().toString();
            String classPackageName = packageName = rt.getSootClass().getJavaPackageName();
            if (string.lastIndexOf(46) > 0) {
                classPackageName = string.substring(0, string.lastIndexOf(46));
            }
            if (!packageName.equals(classPackageName)) {
                throw new DecompilationException("Unable to retrieve package name for identifier. Please report to developer.");
            }
            this.addToImportList(string);
        }
        for (Unit unit : this.getUnits()) {
            Stmt s = (Stmt)unit;
            if (s instanceof IfStmt) {
                this.javafy(((IfStmt)s).getConditionBox());
                continue;
            }
            if (s instanceof ThrowStmt) {
                this.javafy(((ThrowStmt)s).getOpBox());
                continue;
            }
            if (s instanceof TableSwitchStmt) {
                this.javafy(((TableSwitchStmt)s).getKeyBox());
                continue;
            }
            if (s instanceof LookupSwitchStmt) {
                this.javafy(((LookupSwitchStmt)s).getKeyBox());
                continue;
            }
            if (s instanceof MonitorStmt) {
                this.javafy(((MonitorStmt)s).getOpBox());
                continue;
            }
            if (s instanceof DefinitionStmt) {
                DefinitionStmt definitionStmt = (DefinitionStmt)s;
                this.javafy(definitionStmt.getRightOpBox());
                this.javafy(definitionStmt.getLeftOpBox());
                if (!(definitionStmt.getRightOp() instanceof IntConstant)) continue;
                definitionStmt.getRightOpBox().setValue(DIntConstant.v(((IntConstant)definitionStmt.getRightOp()).value, definitionStmt.getLeftOp().getType()));
                continue;
            }
            if (s instanceof ReturnStmt) {
                ReturnStmt returnStmt = (ReturnStmt)s;
                if (returnStmt.getOp() instanceof IntConstant) {
                    returnStmt.getOpBox().setValue(DIntConstant.v(((IntConstant)returnStmt.getOp()).value, body.getMethod().getReturnType()));
                    continue;
                }
                this.javafy(returnStmt.getOpBox());
                continue;
            }
            if (!(s instanceof InvokeStmt)) continue;
            this.javafy(((InvokeStmt)s).getInvokeExprBox());
        }
        for (Stmt stmt : this.getUnits()) {
            if (stmt instanceof IdentityStmt) {
                IdentityStmt ids = (IdentityStmt)stmt;
                Value value = ids.getRightOp();
                Value ids_leftOp = ids.getLeftOp();
                if (ids_leftOp instanceof Local && value instanceof ThisRef) {
                    Local thisLocal = (Local)ids_leftOp;
                    this.thisLocals.add(thisLocal);
                    thisLocal.setName("this");
                }
            }
            if (!(stmt instanceof DefinitionStmt)) continue;
            DefinitionStmt ds = (DefinitionStmt)stmt;
            Value value = ds.getRightOp();
            if (value instanceof ParameterRef) {
                this.pMap.put(new Integer(((ParameterRef)value).getIndex()), ds.getLeftOp());
            }
            if (!(value instanceof CaughtExceptionRef)) continue;
            this.caughtrefs.add(ds.getLeftOp());
        }
        for (Stmt stmt : this.getUnits()) {
            SootMethodRef m;
            String name;
            InstanceInvokeExpr iie;
            Value base;
            InvokeStmt ivs;
            InvokeExpr invokeExpr;
            if (!(stmt instanceof InvokeStmt) || !((invokeExpr = (ivs = (InvokeStmt)stmt).getInvokeExpr()) instanceof InstanceInvokeExpr) || !((base = (iie = (InstanceInvokeExpr)invokeExpr).getBase()) instanceof Local) || !((Local)base).getName().equals("this") || !(name = (m = iie.getMethodRef()).name()).equals("<init>") && !name.equals("<clinit>")) continue;
            if (this.constructorUnit != null) {
                throw new RuntimeException("More than one candidate for constructor found.");
            }
            this.constructorExpr = iie;
            this.constructorUnit = stmt;
        }
    }

    private void javafy(ValueBox vb) {
        Value v = vb.getValue();
        if (v instanceof Expr) {
            this.javafy_expr(vb);
        } else if (v instanceof Ref) {
            this.javafy_ref(vb);
        } else if (v instanceof Local) {
            this.javafy_local(vb);
        } else if (v instanceof Constant) {
            this.javafy_constant(vb);
        }
    }

    private void javafy_expr(ValueBox vb) {
        Expr e = (Expr)vb.getValue();
        if (e instanceof BinopExpr) {
            this.javafy_binop_expr(vb);
        } else if (e instanceof UnopExpr) {
            this.javafy_unop_expr(vb);
        } else if (e instanceof CastExpr) {
            this.javafy_cast_expr(vb);
        } else if (e instanceof NewArrayExpr) {
            this.javafy_newarray_expr(vb);
        } else if (e instanceof NewMultiArrayExpr) {
            this.javafy_newmultiarray_expr(vb);
        } else if (e instanceof InstanceOfExpr) {
            this.javafy_instanceof_expr(vb);
        } else if (e instanceof InvokeExpr) {
            this.javafy_invoke_expr(vb);
        } else if (e instanceof NewExpr) {
            this.javafy_new_expr(vb);
        }
    }

    private void javafy_ref(ValueBox vb) {
        Ref r = (Ref)vb.getValue();
        if (r instanceof StaticFieldRef) {
            String packageName;
            SootFieldRef fieldRef = ((StaticFieldRef)r).getFieldRef();
            String className = fieldRef.declaringClass().toString();
            String classPackageName = packageName = fieldRef.declaringClass().getJavaPackageName();
            if (className.lastIndexOf(46) > 0) {
                classPackageName = className.substring(0, className.lastIndexOf(46));
            }
            if (!packageName.equals(classPackageName)) {
                throw new DecompilationException("Unable to retrieve package name for identifier. Please report to developer.");
            }
            this.addToImportList(className);
            vb.setValue(new DStaticFieldRef(fieldRef, this.getMethod().getDeclaringClass().getName()));
        } else if (r instanceof ArrayRef) {
            ArrayRef ar = (ArrayRef)r;
            this.javafy(ar.getBaseBox());
            this.javafy(ar.getIndexBox());
        } else if (r instanceof InstanceFieldRef) {
            InstanceFieldRef ifr = (InstanceFieldRef)r;
            this.javafy(ifr.getBaseBox());
            vb.setValue(new DInstanceFieldRef(ifr.getBase(), ifr.getFieldRef(), this.thisLocals));
        } else if (r instanceof ThisRef) {
            ThisRef tr = (ThisRef)r;
            vb.setValue(new DThisRef((RefType)tr.getType()));
        }
    }

    private void javafy_local(ValueBox vb) {
    }

    private void javafy_constant(ValueBox vb) {
    }

    private void javafy_binop_expr(ValueBox vb) {
        BinopExpr boe = (BinopExpr)vb.getValue();
        ValueBox leftOpBox = boe.getOp1Box();
        ValueBox rightOpBox = boe.getOp2Box();
        Value leftOp = leftOpBox.getValue();
        Value rightOp = rightOpBox.getValue();
        if (rightOp instanceof IntConstant) {
            if (!(leftOp instanceof IntConstant)) {
                this.javafy(leftOpBox);
                leftOp = leftOpBox.getValue();
                if (boe instanceof ConditionExpr) {
                    rightOpBox.setValue(DIntConstant.v(((IntConstant)rightOp).value, leftOp.getType()));
                } else {
                    rightOpBox.setValue(DIntConstant.v(((IntConstant)rightOp).value, null));
                }
            }
        } else if (leftOp instanceof IntConstant) {
            this.javafy(rightOpBox);
            rightOp = rightOpBox.getValue();
            if (boe instanceof ConditionExpr) {
                leftOpBox.setValue(DIntConstant.v(((IntConstant)leftOp).value, rightOp.getType()));
            } else {
                leftOpBox.setValue(DIntConstant.v(((IntConstant)leftOp).value, null));
            }
        } else {
            this.javafy(rightOpBox);
            rightOp = rightOpBox.getValue();
            this.javafy(leftOpBox);
            leftOp = leftOpBox.getValue();
        }
        if (boe instanceof CmpExpr) {
            vb.setValue(new DCmpExpr(leftOp, rightOp));
        } else if (boe instanceof CmplExpr) {
            vb.setValue(new DCmplExpr(leftOp, rightOp));
        } else if (boe instanceof CmpgExpr) {
            vb.setValue(new DCmpgExpr(leftOp, rightOp));
        }
    }

    private void javafy_unop_expr(ValueBox vb) {
        UnopExpr uoe = (UnopExpr)vb.getValue();
        this.javafy(uoe.getOpBox());
        if (uoe instanceof LengthExpr) {
            vb.setValue(new DLengthExpr(((LengthExpr)uoe).getOp()));
        } else if (uoe instanceof NegExpr) {
            vb.setValue(new DNegExpr(((NegExpr)uoe).getOp()));
        }
    }

    private void javafy_cast_expr(ValueBox vb) {
        CastExpr ce = (CastExpr)vb.getValue();
        this.javafy(ce.getOpBox());
    }

    private void javafy_newarray_expr(ValueBox vb) {
        NewArrayExpr nae = (NewArrayExpr)vb.getValue();
        this.javafy(nae.getSizeBox());
        vb.setValue(new DNewArrayExpr(nae.getBaseType(), nae.getSize()));
    }

    private void javafy_newmultiarray_expr(ValueBox vb) {
        NewMultiArrayExpr nmae = (NewMultiArrayExpr)vb.getValue();
        for (int i = 0; i < nmae.getSizeCount(); ++i) {
            this.javafy(nmae.getSizeBox(i));
        }
        vb.setValue(new DNewMultiArrayExpr(nmae.getBaseType(), nmae.getSizes()));
    }

    private void javafy_instanceof_expr(ValueBox vb) {
        InstanceOfExpr ioe = (InstanceOfExpr)vb.getValue();
        this.javafy(ioe.getOpBox());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void javafy_invoke_expr(ValueBox vb) {
        String packageName;
        InvokeExpr ie = (InvokeExpr)vb.getValue();
        String className = ie.getMethodRef().declaringClass().toString();
        String classPackageName = packageName = ie.getMethodRef().declaringClass().getJavaPackageName();
        if (className.lastIndexOf(46) > 0) {
            classPackageName = className.substring(0, className.lastIndexOf(46));
        }
        if (!packageName.equals(classPackageName)) {
            throw new DecompilationException("Unable to retrieve package name for identifier. Please report to developer.");
        }
        this.addToImportList(className);
        for (int i = 0; i < ie.getArgCount(); ++i) {
            Value arg = ie.getArg(i);
            if (arg instanceof IntConstant) {
                ie.getArgBox(i).setValue(DIntConstant.v(((IntConstant)arg).value, ie.getMethodRef().parameterType(i)));
                continue;
            }
            this.javafy(ie.getArgBox(i));
        }
        if (ie instanceof InstanceInvokeExpr) {
            this.javafy(((InstanceInvokeExpr)ie).getBaseBox());
            if (ie instanceof VirtualInvokeExpr) {
                VirtualInvokeExpr vie = (VirtualInvokeExpr)ie;
                vb.setValue(new DVirtualInvokeExpr(vie.getBase(), vie.getMethodRef(), vie.getArgs(), this.thisLocals));
                return;
            } else if (ie instanceof SpecialInvokeExpr) {
                SpecialInvokeExpr sie = (SpecialInvokeExpr)ie;
                vb.setValue(new DSpecialInvokeExpr(sie.getBase(), sie.getMethodRef(), sie.getArgs()));
                return;
            } else {
                if (!(ie instanceof InterfaceInvokeExpr)) throw new RuntimeException("InstanceInvokeExpr " + ie + " not javafied correctly");
                InterfaceInvokeExpr iie = (InterfaceInvokeExpr)ie;
                vb.setValue(new DInterfaceInvokeExpr(iie.getBase(), iie.getMethodRef(), iie.getArgs()));
            }
            return;
        } else {
            if (!(ie instanceof StaticInvokeExpr)) throw new RuntimeException("InvokeExpr " + ie + " not javafied correctly");
            StaticInvokeExpr sie = (StaticInvokeExpr)ie;
            if (sie instanceof NewInvokeExpr) {
                NewInvokeExpr nie = (NewInvokeExpr)sie;
                RefType rt = nie.getBaseType();
                className = rt.getSootClass().toString();
                classPackageName = packageName = rt.getSootClass().getJavaPackageName();
                if (className.lastIndexOf(46) > 0) {
                    classPackageName = className.substring(0, className.lastIndexOf(46));
                }
                if (!packageName.equals(classPackageName)) {
                    throw new DecompilationException("Unable to retrieve package name for identifier. Please report to developer.");
                }
                this.addToImportList(className);
                vb.setValue(new DNewInvokeExpr((RefType)nie.getType(), nie.getMethodRef(), nie.getArgs()));
                return;
            } else {
                SootMethodRef methodRef = sie.getMethodRef();
                className = methodRef.declaringClass().toString();
                classPackageName = packageName = methodRef.declaringClass().getJavaPackageName();
                if (className.lastIndexOf(46) > 0) {
                    classPackageName = className.substring(0, className.lastIndexOf(46));
                }
                if (!packageName.equals(classPackageName)) {
                    throw new DecompilationException("Unable to retrieve package name for identifier. Please report to developer.");
                }
                this.addToImportList(className);
                vb.setValue(new DStaticInvokeExpr(methodRef, sie.getArgs()));
            }
        }
    }

    private void javafy_new_expr(ValueBox vb) {
        String packageName;
        NewExpr ne = (NewExpr)vb.getValue();
        String className = ne.getBaseType().getSootClass().toString();
        String classPackageName = packageName = ne.getBaseType().getSootClass().getJavaPackageName();
        if (className.lastIndexOf(46) > 0) {
            classPackageName = className.substring(0, className.lastIndexOf(46));
        }
        if (!packageName.equals(classPackageName)) {
            throw new DecompilationException("Unable to retrieve package name for identifier. Please report to developer.");
        }
        this.addToImportList(className);
    }

    public void addToImportList(String className) {
        if (className.equals("")) {
            return;
        }
        if (!this.importList.contains(className)) {
            this.importList.add(className);
            if (this.DEBUG) {
                System.out.println("Adding to import list: " + className);
            }
        }
    }

    public void debug(String methodName, String debug) {
        if (this.DEBUG) {
            System.out.println(methodName + "    DEBUG: " + debug);
        }
    }
}

