/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import soot.G;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.xml.TagCollector;

public class XMLAttributesPrinter {
    private String useFilename;
    private String outputDir;
    FileOutputStream streamOut = null;
    PrintWriter writerOut = null;

    private void setOutputDir(String dir) {
        this.outputDir = dir;
    }

    private String getOutputDir() {
        return this.outputDir;
    }

    public XMLAttributesPrinter(String filename, String outputDir) {
        this.setInFilename(filename);
        this.setOutputDir(outputDir);
        this.initAttributesDir();
        this.createUseFilename();
        this.initFile();
    }

    private void initFile() {
        try {
            this.streamOut = new FileOutputStream(this.getUseFilename());
            this.writerOut = new PrintWriter(new OutputStreamWriter(this.streamOut));
            this.writerOut.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            this.writerOut.println("<attributes>");
        }
        catch (IOException e1) {
            G.v().out.println(e1.getMessage());
        }
    }

    private void finishFile() {
        this.writerOut.println("</attributes>");
        this.writerOut.close();
    }

    public void printAttrs(SootClass c, TagCollector tc) {
        tc.collectKeyTags(c);
        for (SootField sf : c.getFields()) {
            tc.collectFieldTags(sf);
        }
        for (SootMethod sm : c.getMethods()) {
            tc.collectMethodTags(sm);
        }
        tc.printTags(this.writerOut);
        tc.printKeys(this.writerOut);
        this.finishFile();
    }

    public void printAttrs(SootClass c) {
        TagCollector tc = new TagCollector();
        tc.collectKeyTags(c);
        tc.collectTags(c);
        tc.printTags(this.writerOut);
        tc.printKeys(this.writerOut);
        this.finishFile();
    }

    private void initAttributesDir() {
        StringBuffer sb = new StringBuffer();
        String attrDir = "attributes";
        sb.append(this.getOutputDir());
        sb.append(System.getProperty("file.separator"));
        sb.append(attrDir);
        File dir = new File(sb.toString());
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (SecurityException se) {
                G.v().out.println("Unable to create " + attrDir);
            }
        }
    }

    private void createUseFilename() {
        String tmp = this.getInFilename();
        int slash = (tmp = tmp.substring(0, tmp.lastIndexOf(46))).lastIndexOf(System.getProperty("file.separator"));
        if (slash != -1) {
            tmp = tmp.substring(slash + 1, tmp.length());
        }
        StringBuffer sb = new StringBuffer();
        String attrDir = "attributes";
        sb.append(this.getOutputDir());
        sb.append(System.getProperty("file.separator"));
        sb.append(attrDir);
        sb.append(System.getProperty("file.separator"));
        sb.append(tmp);
        sb.append(".xml");
        this.setUseFilename(sb.toString());
    }

    private void setInFilename(String file) {
        this.useFilename = file;
    }

    private String getInFilename() {
        return this.useFilename;
    }

    private void setUseFilename(String file) {
        this.useFilename = file;
    }

    private String getUseFilename() {
        return this.useFilename;
    }
}

