/*
 * Decompiled with CFR 0.152.
 */
package soot;

import beaver.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import soot.ArrayType;
import soot.ClassSource;
import soot.G;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.BytecodeParser;
import soot.JastAddJ.CompilationUnit;
import soot.JastAddJ.JastAddJavaParser;
import soot.JastAddJ.JavaParser;
import soot.JastAddJ.Program;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SourceLocator;
import soot.Type;
import soot.javaToJimple.IInitialResolver;
import soot.options.Options;

public class SootResolver {
    private final Map<SootClass, ArrayList> classToTypesSignature = new HashMap<SootClass, ArrayList>();
    private final Map<SootClass, ArrayList> classToTypesHierarchy = new HashMap<SootClass, ArrayList>();
    private final LinkedList[] worklist = new LinkedList[4];
    protected Program program;

    public SootResolver(Singletons.Global g) {
        this.worklist[1] = new LinkedList();
        this.worklist[2] = new LinkedList();
        this.worklist[3] = new LinkedList();
        this.program = new Program();
        ASTNode.reset();
        this.program.initBytecodeReader(new BytecodeParser());
        this.program.initJavaParser(new JavaParser(){

            public CompilationUnit parse(InputStream is, String fileName) throws IOException, Parser.Exception {
                return new JastAddJavaParser().parse(is, fileName);
            }
        });
        Program.initOptions();
        this.program.addKeyValueOption("-classpath");
        Program.setValueForOption(Scene.v().getSootClassPath(), "-classpath");
        if (Options.v().src_prec() == 4) {
            this.program.setSrcPrec(1);
        } else if (Options.v().src_prec() == 1) {
            this.program.setSrcPrec(2);
        } else if (Options.v().src_prec() == 2) {
            this.program.setSrcPrec(2);
        }
        this.program.initPaths();
    }

    public static SootResolver v() {
        return G.v().soot_SootResolver();
    }

    private boolean resolveEverything() {
        return Options.v().whole_program() || Options.v().whole_shimple() || Options.v().full_resolver() || Options.v().output_format() == 13;
    }

    public SootClass makeClassRef(String className) {
        if (Scene.v().containsClass(className)) {
            return Scene.v().getSootClass(className);
        }
        SootClass newClass = new SootClass(className);
        newClass.setResolvingLevel(0);
        Scene.v().addClass(newClass);
        return newClass;
    }

    public SootClass resolveClass(String className, int desiredLevel) {
        SootClass resolvedClass = this.makeClassRef(className);
        this.addToResolveWorklist(resolvedClass, desiredLevel);
        this.processResolveWorklist();
        return resolvedClass;
    }

    private void processResolveWorklist() {
        for (int i = 3; i >= 1; --i) {
            while (!this.worklist[i].isEmpty()) {
                SootClass sc = (SootClass)this.worklist[i].removeFirst();
                if (this.resolveEverything()) {
                    if (sc.isPhantom()) {
                        this.bringToSignatures(sc);
                        continue;
                    }
                    this.bringToBodies(sc);
                    continue;
                }
                switch (i) {
                    case 3: {
                        this.bringToBodies(sc);
                        break;
                    }
                    case 2: {
                        this.bringToSignatures(sc);
                        break;
                    }
                    case 1: {
                        this.bringToHierarchy(sc);
                    }
                }
            }
        }
    }

    private void addToResolveWorklist(Type type, int level) {
        if (type instanceof RefType) {
            this.addToResolveWorklist(((RefType)type).getClassName(), level);
        } else if (type instanceof ArrayType) {
            this.addToResolveWorklist(((ArrayType)type).baseType, level);
        }
    }

    private void addToResolveWorklist(String className, int level) {
        this.addToResolveWorklist(this.makeClassRef(className), level);
    }

    private void addToResolveWorklist(SootClass sc, int desiredLevel) {
        if (sc.resolvingLevel() >= desiredLevel) {
            return;
        }
        this.worklist[desiredLevel].add(sc);
    }

    private void bringToHierarchy(SootClass sc) {
        if (sc.resolvingLevel() >= 1) {
            return;
        }
        if (Options.v().debug_resolver()) {
            G.v().out.println("bringing to HIERARCHY: " + sc);
        }
        sc.setResolvingLevel(1);
        String className = sc.getName();
        ClassSource is = SourceLocator.v().getClassSource(className);
        if (is == null) {
            if (!Scene.v().allowsPhantomRefs()) {
                throw new RuntimeException("couldn't find class: " + className + " (is your soot-class-path set properly?)");
            }
            G.v().out.println("Warning: " + className + " is a phantom class!");
            sc.setPhantomClass();
            this.classToTypesSignature.put(sc, new ArrayList());
            this.classToTypesHierarchy.put(sc, new ArrayList());
        } else {
            IInitialResolver.Dependencies dependencies = is.resolve(sc);
            this.classToTypesSignature.put(sc, new ArrayList<Type>(dependencies.typesToSignature));
            this.classToTypesHierarchy.put(sc, new ArrayList<Type>(dependencies.typesToHierarchy));
        }
        this.reResolveHierarchy(sc);
    }

    public void reResolveHierarchy(SootClass sc) {
        if (sc.hasSuperclass()) {
            this.addToResolveWorklist(sc.getSuperclass(), 1);
        }
        if (sc.hasOuterClass()) {
            this.addToResolveWorklist(sc.getOuterClass(), 1);
        }
        for (SootClass iface : sc.getInterfaces()) {
            this.addToResolveWorklist(iface, 1);
        }
    }

    private void bringToSignatures(SootClass sc) {
        if (sc.resolvingLevel() >= 2) {
            return;
        }
        this.bringToHierarchy(sc);
        if (Options.v().debug_resolver()) {
            G.v().out.println("bringing to SIGNATURES: " + sc);
        }
        sc.setResolvingLevel(2);
        for (SootField f : sc.getFields()) {
            this.addToResolveWorklist(f.getType(), 1);
        }
        for (SootMethod m : sc.getMethods()) {
            this.addToResolveWorklist(m.getReturnType(), 1);
            for (Type ptype : m.getParameterTypes()) {
                this.addToResolveWorklist(ptype, 1);
            }
            for (SootClass exception : m.getExceptions()) {
                this.addToResolveWorklist(exception, 1);
            }
        }
        if (sc.hasSuperclass()) {
            this.addToResolveWorklist(sc.getSuperclass(), 2);
        }
        for (SootClass iface : sc.getInterfaces()) {
            this.addToResolveWorklist(iface, 2);
        }
    }

    private void bringToBodies(SootClass sc) {
        if (sc.resolvingLevel() >= 3) {
            return;
        }
        this.bringToSignatures(sc);
        if (Options.v().debug_resolver()) {
            G.v().out.println("bringing to BODIES: " + sc);
        }
        sc.setResolvingLevel(3);
        Collection references = this.classToTypesHierarchy.get(sc);
        if (references == null) {
            return;
        }
        for (Object o : references) {
            if (o instanceof String) {
                this.addToResolveWorklist((String)o, 1);
                continue;
            }
            if (o instanceof Type) {
                this.addToResolveWorklist((Type)o, 1);
                continue;
            }
            throw new RuntimeException(o.toString());
        }
        references = this.classToTypesSignature.get(sc);
        if (references == null) {
            return;
        }
        for (Object o : references) {
            if (o instanceof String) {
                this.addToResolveWorklist((String)o, 2);
                continue;
            }
            if (o instanceof Type) {
                this.addToResolveWorklist((Type)o, 2);
                continue;
            }
            throw new RuntimeException(o.toString());
        }
    }

    public void reResolve(SootClass cl) {
        int resolvingLevel = cl.resolvingLevel();
        if (resolvingLevel < 1) {
            return;
        }
        this.reResolveHierarchy(cl);
        cl.setResolvingLevel(1);
        this.addToResolveWorklist(cl, resolvingLevel);
        this.processResolveWorklist();
    }

    public Program getProgram() {
        return this.program;
    }
}

