/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Binary;
import soot.JastAddJ.Body;
import soot.JastAddJ.BooleanType;
import soot.JastAddJ.Expr;
import soot.JastAddJ.GEExpr;
import soot.JastAddJ.GTExpr;
import soot.JastAddJ.TypeDecl;
import soot.Local;
import soot.Value;
import soot.jimple.Jimple;
import soot.jimple.Stmt;

public abstract class RelationalExpr
extends Binary
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    public RelationalExpr clone() throws CloneNotSupportedException {
        RelationalExpr node = (RelationalExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public void typeCheck() {
        if (!this.getLeftOperand().type().isNumericType()) {
            this.error(this.getLeftOperand().type().typeName() + " is not numeric");
        }
        if (!this.getRightOperand().type().isNumericType()) {
            this.error(this.getRightOperand().type().typeName() + " is not numeric");
        }
    }

    public Value eval(Body b) {
        return this.emitBooleanCondition(b);
    }

    public void emitEvalBranch(Body b) {
        b.setLine(this);
        if (this.isTrue()) {
            b.add(Jimple.v().newGotoStmt(this.true_label()));
        } else if (this.isFalse()) {
            b.add(Jimple.v().newGotoStmt(this.false_label()));
        } else {
            TypeDecl type = this.getLeftOperand().type();
            if (type.isNumericType()) {
                type = this.binaryNumericPromotedType();
                Value left = this.getLeftOperand().type().emitCastTo(b, this.getLeftOperand(), type);
                Value right = this.getRightOperand().type().emitCastTo(b, this.getRightOperand(), type);
                if (type.isDouble() || type.isFloat() || type.isLong()) {
                    Local l = type.isDouble() || type.isFloat() ? (this instanceof GEExpr || this instanceof GTExpr ? this.asLocal(b, Jimple.v().newCmplExpr(this.asImmediate(b, left), this.asImmediate(b, right))) : this.asLocal(b, Jimple.v().newCmpgExpr(this.asImmediate(b, left), this.asImmediate(b, right)))) : this.asLocal(b, Jimple.v().newCmpExpr(this.asImmediate(b, left), this.asImmediate(b, right)));
                    b.add(Jimple.v().newIfStmt(this.comparisonInv(b, l, BooleanType.emitConstant(false)), this.false_label()));
                    b.add(Jimple.v().newGotoStmt(this.true_label()));
                } else {
                    b.add(Jimple.v().newIfStmt(this.comparison(b, left, right), this.true_label()));
                    b.add(Jimple.v().newGotoStmt(this.false_label()));
                }
            } else {
                Value left = this.getLeftOperand().eval(b);
                Value right = this.getRightOperand().eval(b);
                b.add(Jimple.v().newIfStmt(this.comparison(b, left, right), this.true_label()));
                b.add(Jimple.v().newGotoStmt(this.false_label()));
            }
        }
    }

    public Value comparison(Body b, Value left, Value right) {
        throw new Error("comparison not supported for " + this.getClass().getName());
    }

    public Value comparisonInv(Body b, Value left, Value right) {
        throw new Error("comparisonInv not supported for " + this.getClass().getName());
    }

    public RelationalExpr() {
    }

    public RelationalExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    protected int numChildren() {
        return 2;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setLeftOperand(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getLeftOperand() {
        return (Expr)this.getChild(0);
    }

    public Expr getLeftOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void setRightOperand(Expr node) {
        this.setChild(node, 1);
    }

    public Expr getRightOperand() {
        return (Expr)this.getChild(1);
    }

    public Expr getRightOperandNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeBoolean();
    }

    public boolean definesLabel() {
        boolean definesLabel_value = this.definesLabel_compute();
        return definesLabel_value;
    }

    private boolean definesLabel_compute() {
        return false;
    }

    public Stmt Define_soot_jimple_Stmt_condition_false_label(ASTNode caller, ASTNode child) {
        if (caller == this.getRightOperandNoTransform()) {
            return this.false_label();
        }
        if (caller == this.getLeftOperandNoTransform()) {
            return this.false_label();
        }
        return this.getParent().Define_soot_jimple_Stmt_condition_false_label(this, caller);
    }

    public Stmt Define_soot_jimple_Stmt_condition_true_label(ASTNode caller, ASTNode child) {
        if (caller == this.getRightOperandNoTransform()) {
            return this.true_label();
        }
        if (caller == this.getLeftOperandNoTransform()) {
            return this.true_label();
        }
        return this.getParent().Define_soot_jimple_Stmt_condition_true_label(this, caller);
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

