/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Constant;
import soot.JastAddJ.PrimaryExpr;

public abstract class Literal
extends PrimaryExpr
implements Cloneable {
    protected String tokenString_LITERAL;
    public int LITERALstart;
    public int LITERALend;
    protected boolean constant_computed = false;
    protected Constant constant_value;

    public void flushCache() {
        super.flushCache();
        this.constant_computed = false;
        this.constant_value = null;
    }

    public Literal clone() throws CloneNotSupportedException {
        Literal node = (Literal)super.clone();
        node.constant_computed = false;
        node.constant_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    static long parseLong(String s) {
        long x = 0L;
        s = s.toLowerCase();
        boolean neg = false;
        if (s.startsWith("-")) {
            s = s.substring(1);
            neg = true;
        }
        if (s.startsWith("0x")) {
            int i;
            if ((s = s.substring(2)).length() > 16) {
                for (i = 0; i < s.length() - 16; ++i) {
                    if (s.charAt(i) == '0') continue;
                    throw new NumberFormatException("");
                }
            }
            for (i = 0; i < s.length(); ++i) {
                int c = s.charAt(i);
                if (c >= 97 && c <= 102) {
                    c = c - 97 + 10;
                } else if (c >= 48 && c <= 57) {
                    c -= 48;
                } else {
                    throw new NumberFormatException("");
                }
                x = x * 16L + (long)c;
            }
        } else if (s.startsWith("0")) {
            int i;
            if ((s = s.substring(1)).length() > 21) {
                for (i = 0; i < s.length() - 21; ++i) {
                    if (!(i == s.length() - 21 - 1 ? s.charAt(i) != '0' && s.charAt(i) != '1' : s.charAt(i) != '0')) continue;
                    throw new NumberFormatException("");
                }
            }
            for (i = 0; i < s.length(); ++i) {
                int c = s.charAt(i);
                if (c < 48 || c > 55) {
                    throw new NumberFormatException("");
                }
                x = x * 8L + (long)(c -= 48);
            }
        } else {
            long oldx = 0L;
            for (int i = 0; i < s.length(); ++i) {
                int c = s.charAt(i);
                if (c < 48 || c > 57) {
                    throw new NumberFormatException("");
                }
                x = x * 10L + (long)(c -= 48);
                if (x < oldx) {
                    boolean negMinValue;
                    boolean bl = negMinValue = i == s.length() - 1 && neg && x == Long.MIN_VALUE;
                    if (!negMinValue) {
                        throw new NumberFormatException("");
                    }
                }
                oldx = x;
            }
            if (x == Long.MIN_VALUE) {
                return x;
            }
            if (x < 0L) {
                throw new NumberFormatException("");
            }
        }
        return neg ? -x : x;
    }

    public void toString(StringBuffer s) {
        s.append(this.getLITERAL());
    }

    protected static String escape(String s) {
        StringBuffer result = new StringBuffer();
        block10: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\b': {
                    result.append("\\b");
                    continue block10;
                }
                case '\t': {
                    result.append("\\t");
                    continue block10;
                }
                case '\n': {
                    result.append("\\n");
                    continue block10;
                }
                case '\f': {
                    result.append("\\f");
                    continue block10;
                }
                case '\r': {
                    result.append("\\r");
                    continue block10;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    result.append("\\'");
                    continue block10;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block10;
                }
                default: {
                    char value = s.charAt(i);
                    if (value < ' ' || value > '~') {
                        result.append(Literal.asEscape(value));
                        continue block10;
                    }
                    result.append(s.charAt(i));
                }
            }
        }
        return result.toString();
    }

    protected static String asEscape(int value) {
        StringBuffer s = new StringBuffer("\\u");
        String hex = Integer.toHexString(value);
        for (int i = 0; i < 4 - hex.length(); ++i) {
            s.append("0");
        }
        s.append(hex);
        return s.toString();
    }

    public Literal() {
    }

    public Literal(String p0) {
        this.setLITERAL(p0);
    }

    public Literal(Symbol p0) {
        this.setLITERAL(p0);
    }

    protected int numChildren() {
        return 0;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setLITERAL(String value) {
        this.tokenString_LITERAL = value;
    }

    public void setLITERAL(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol.value;
        this.LITERALstart = symbol.getStart();
        this.LITERALend = symbol.getEnd();
    }

    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        throw new UnsupportedOperationException("ConstantExpression operation constant not supported for type " + this.getClass().getName());
    }

    public boolean isConstant() {
        boolean isConstant_value = this.isConstant_compute();
        return isConstant_value;
    }

    private boolean isConstant_compute() {
        return true;
    }

    public String dumpString() {
        String dumpString_value = this.dumpString_compute();
        return dumpString_value;
    }

    private String dumpString_compute() {
        return this.getClass().getName() + " [" + this.getLITERAL() + "]";
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

