/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Access;
import soot.JastAddJ.BodyDecl;
import soot.JastAddJ.Constant;
import soot.JastAddJ.Expr;
import soot.JastAddJ.List;
import soot.JastAddJ.Modifiers;
import soot.JastAddJ.NumericType;
import soot.JastAddJ.Opt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntegralType
extends NumericType
implements Cloneable {
    public int IDstart;
    public int IDend;
    private int getNumBodyDecl = 0;

    @Override
    public void flushCache() {
        super.flushCache();
    }

    @Override
    public IntegralType clone() throws CloneNotSupportedException {
        IntegralType node = (IntegralType)super.clone();
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public IntegralType() {
        this.setChild(new Opt(), 1);
        this.setChild(new List(), 2);
    }

    public IntegralType(Modifiers p0, String p1, Opt<Access> p2, List<BodyDecl> p3) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
    }

    public IntegralType(Modifiers p0, Symbol p1, Opt<Access> p2, List<BodyDecl> p3) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
    }

    @Override
    protected int numChildren() {
        return 3;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setModifiers(Modifiers node) {
        this.setChild(node, 0);
    }

    @Override
    public Modifiers getModifiers() {
        return (Modifiers)this.getChild(0);
    }

    @Override
    public Modifiers getModifiersNoTransform() {
        return (Modifiers)this.getChildNoTransform(0);
    }

    @Override
    public void setID(String value) {
        this.tokenString_ID = value;
    }

    @Override
    public void setID(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol.value;
        this.IDstart = symbol.getStart();
        this.IDend = symbol.getEnd();
    }

    @Override
    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    @Override
    public void setSuperClassAccessOpt(Opt<Access> opt) {
        this.setChild(opt, 1);
    }

    @Override
    public boolean hasSuperClassAccess() {
        return this.getSuperClassAccessOpt().getNumChild() != 0;
    }

    @Override
    public Access getSuperClassAccess() {
        return (Access)this.getSuperClassAccessOpt().getChild(0);
    }

    @Override
    public void setSuperClassAccess(Access node) {
        this.getSuperClassAccessOpt().setChild(node, 0);
    }

    @Override
    public Opt<Access> getSuperClassAccessOpt() {
        return (Opt)this.getChild(1);
    }

    @Override
    public Opt<Access> getSuperClassAccessOptNoTransform() {
        return (Opt)this.getChildNoTransform(1);
    }

    @Override
    public void setBodyDeclList(List<BodyDecl> list) {
        this.setChild(list, 2);
    }

    @Override
    public int getNumBodyDecl() {
        return this.getBodyDeclList().getNumChild();
    }

    @Override
    public BodyDecl getBodyDecl(int i) {
        return (BodyDecl)this.getBodyDeclList().getChild(i);
    }

    @Override
    public void addBodyDecl(BodyDecl node) {
        List<BodyDecl> list = this.getBodyDeclList();
        list.addChild(node);
    }

    @Override
    public void setBodyDecl(BodyDecl node, int i) {
        List<BodyDecl> list = this.getBodyDeclList();
        list.setChild(node, i);
    }

    @Override
    public List<BodyDecl> getBodyDecls() {
        return this.getBodyDeclList();
    }

    @Override
    public List<BodyDecl> getBodyDeclsNoTransform() {
        return this.getBodyDeclListNoTransform();
    }

    @Override
    public List<BodyDecl> getBodyDeclList() {
        return (List)this.getChild(2);
    }

    @Override
    public List<BodyDecl> getBodyDeclListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    @Override
    public Constant cast(Constant c) {
        Constant cast_Constant_value = this.cast_compute(c);
        return cast_Constant_value;
    }

    private Constant cast_compute(Constant c) {
        return Constant.create(c.intValue());
    }

    @Override
    public Constant plus(Constant c) {
        Constant plus_Constant_value = this.plus_compute(c);
        return plus_Constant_value;
    }

    private Constant plus_compute(Constant c) {
        return c;
    }

    @Override
    public Constant minus(Constant c) {
        Constant minus_Constant_value = this.minus_compute(c);
        return minus_Constant_value;
    }

    private Constant minus_compute(Constant c) {
        return Constant.create(-c.intValue());
    }

    @Override
    public Constant bitNot(Constant c) {
        Constant bitNot_Constant_value = this.bitNot_compute(c);
        return bitNot_Constant_value;
    }

    private Constant bitNot_compute(Constant c) {
        return Constant.create(~c.intValue());
    }

    @Override
    public Constant mul(Constant c1, Constant c2) {
        Constant mul_Constant_Constant_value = this.mul_compute(c1, c2);
        return mul_Constant_Constant_value;
    }

    private Constant mul_compute(Constant c1, Constant c2) {
        return Constant.create(c1.intValue() * c2.intValue());
    }

    @Override
    public Constant div(Constant c1, Constant c2) {
        Constant div_Constant_Constant_value = this.div_compute(c1, c2);
        return div_Constant_Constant_value;
    }

    private Constant div_compute(Constant c1, Constant c2) {
        return Constant.create(c1.intValue() / c2.intValue());
    }

    @Override
    public Constant mod(Constant c1, Constant c2) {
        Constant mod_Constant_Constant_value = this.mod_compute(c1, c2);
        return mod_Constant_Constant_value;
    }

    private Constant mod_compute(Constant c1, Constant c2) {
        return Constant.create(c1.intValue() % c2.intValue());
    }

    @Override
    public Constant add(Constant c1, Constant c2) {
        Constant add_Constant_Constant_value = this.add_compute(c1, c2);
        return add_Constant_Constant_value;
    }

    private Constant add_compute(Constant c1, Constant c2) {
        return Constant.create(c1.intValue() + c2.intValue());
    }

    @Override
    public Constant sub(Constant c1, Constant c2) {
        Constant sub_Constant_Constant_value = this.sub_compute(c1, c2);
        return sub_Constant_Constant_value;
    }

    private Constant sub_compute(Constant c1, Constant c2) {
        return Constant.create(c1.intValue() - c2.intValue());
    }

    @Override
    public Constant lshift(Constant c1, Constant c2) {
        Constant lshift_Constant_Constant_value = this.lshift_compute(c1, c2);
        return lshift_Constant_Constant_value;
    }

    private Constant lshift_compute(Constant c1, Constant c2) {
        return Constant.create(c1.intValue() << c2.intValue());
    }

    @Override
    public Constant rshift(Constant c1, Constant c2) {
        Constant rshift_Constant_Constant_value = this.rshift_compute(c1, c2);
        return rshift_Constant_Constant_value;
    }

    private Constant rshift_compute(Constant c1, Constant c2) {
        return Constant.create(c1.intValue() >> c2.intValue());
    }

    @Override
    public Constant urshift(Constant c1, Constant c2) {
        Constant urshift_Constant_Constant_value = this.urshift_compute(c1, c2);
        return urshift_Constant_Constant_value;
    }

    private Constant urshift_compute(Constant c1, Constant c2) {
        return Constant.create(c1.intValue() >>> c2.intValue());
    }

    @Override
    public Constant andBitwise(Constant c1, Constant c2) {
        Constant andBitwise_Constant_Constant_value = this.andBitwise_compute(c1, c2);
        return andBitwise_Constant_Constant_value;
    }

    private Constant andBitwise_compute(Constant c1, Constant c2) {
        return Constant.create(c1.intValue() & c2.intValue());
    }

    @Override
    public Constant xorBitwise(Constant c1, Constant c2) {
        Constant xorBitwise_Constant_Constant_value = this.xorBitwise_compute(c1, c2);
        return xorBitwise_Constant_Constant_value;
    }

    private Constant xorBitwise_compute(Constant c1, Constant c2) {
        return Constant.create(c1.intValue() ^ c2.intValue());
    }

    @Override
    public Constant orBitwise(Constant c1, Constant c2) {
        Constant orBitwise_Constant_Constant_value = this.orBitwise_compute(c1, c2);
        return orBitwise_Constant_Constant_value;
    }

    private Constant orBitwise_compute(Constant c1, Constant c2) {
        return Constant.create(c1.intValue() | c2.intValue());
    }

    @Override
    public Constant questionColon(Constant cond, Constant c1, Constant c2) {
        Constant questionColon_Constant_Constant_Constant_value = this.questionColon_compute(cond, c1, c2);
        return questionColon_Constant_Constant_Constant_value;
    }

    private Constant questionColon_compute(Constant cond, Constant c1, Constant c2) {
        return Constant.create(cond.booleanValue() ? c1.intValue() : c2.intValue());
    }

    @Override
    public boolean eqIsTrue(Expr left, Expr right) {
        boolean eqIsTrue_Expr_Expr_value = this.eqIsTrue_compute(left, right);
        return eqIsTrue_Expr_Expr_value;
    }

    private boolean eqIsTrue_compute(Expr left, Expr right) {
        return left.constant().intValue() == right.constant().intValue();
    }

    @Override
    public boolean ltIsTrue(Expr left, Expr right) {
        boolean ltIsTrue_Expr_Expr_value = this.ltIsTrue_compute(left, right);
        return ltIsTrue_Expr_Expr_value;
    }

    private boolean ltIsTrue_compute(Expr left, Expr right) {
        return left.constant().intValue() < right.constant().intValue();
    }

    @Override
    public boolean leIsTrue(Expr left, Expr right) {
        boolean leIsTrue_Expr_Expr_value = this.leIsTrue_compute(left, right);
        return leIsTrue_Expr_Expr_value;
    }

    private boolean leIsTrue_compute(Expr left, Expr right) {
        return left.constant().intValue() <= right.constant().intValue();
    }

    @Override
    public boolean assignableToInt() {
        boolean assignableToInt_value = this.assignableToInt_compute();
        return assignableToInt_value;
    }

    private boolean assignableToInt_compute() {
        return true;
    }

    @Override
    public boolean isIntegralType() {
        boolean isIntegralType_value = this.isIntegralType_compute();
        return isIntegralType_value;
    }

    private boolean isIntegralType_compute() {
        return true;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

