/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Access;
import soot.JastAddJ.Body;
import soot.JastAddJ.Expr;
import soot.JastAddJ.NameType;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.Value;
import soot.jimple.Jimple;

public class InstanceOfExpr
extends Expr
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    public InstanceOfExpr clone() throws CloneNotSupportedException {
        InstanceOfExpr node = (InstanceOfExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public InstanceOfExpr copy() {
        try {
            InstanceOfExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public InstanceOfExpr fullCopy() {
        InstanceOfExpr res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
        }
        return res;
    }

    public void toString(StringBuffer s) {
        this.getExpr().toString(s);
        s.append(" instanceof ");
        this.getTypeAccess().toString(s);
    }

    public void typeCheck() {
        TypeDecl relationalExpr = this.getExpr().type();
        TypeDecl referenceType = this.getTypeAccess().type();
        if (!relationalExpr.isUnknown()) {
            if (!relationalExpr.isReferenceType() && !relationalExpr.isNull()) {
                this.error("The relational expression in instance of must be reference or null type");
            }
            if (!referenceType.isReferenceType()) {
                this.error("The reference expression in instance of must be reference type");
            }
            if (!relationalExpr.castingConversionTo(referenceType)) {
                this.error("The type " + relationalExpr.typeName() + " of the relational expression " + this.getExpr() + " can not be cast into the type " + referenceType.typeName());
            }
            if (this.getExpr().isTypeAccess()) {
                this.error("The relational expression " + this.getExpr() + " must not be a type name");
            }
        }
    }

    public Value eval(Body b) {
        return Jimple.v().newInstanceOfExpr(this.asImmediate(b, this.getExpr().eval(b)), this.getTypeAccess().type().getSootType());
    }

    public InstanceOfExpr() {
    }

    public InstanceOfExpr(Expr p0, Access p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    protected int numChildren() {
        return 2;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setExpr(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getExpr() {
        return (Expr)this.getChild(0);
    }

    public Expr getExprNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void setTypeAccess(Access node) {
        this.setChild(node, 1);
    }

    public Access getTypeAccess() {
        return (Access)this.getChild(1);
    }

    public Access getTypeAccessNoTransform() {
        return (Access)this.getChildNoTransform(1);
    }

    public boolean isConstant() {
        boolean isConstant_value = this.isConstant_compute();
        return isConstant_value;
    }

    private boolean isConstant_compute() {
        return false;
    }

    public boolean isDAafterFalse(Variable v) {
        boolean isDAafterFalse_Variable_value = this.isDAafterFalse_compute(v);
        return isDAafterFalse_Variable_value;
    }

    private boolean isDAafterFalse_compute(Variable v) {
        return this.isDAafter(v);
    }

    public boolean isDAafterTrue(Variable v) {
        boolean isDAafterTrue_Variable_value = this.isDAafterTrue_compute(v);
        return isDAafterTrue_Variable_value;
    }

    private boolean isDAafterTrue_compute(Variable v) {
        return this.isDAafter(v);
    }

    public boolean isDAafter(Variable v) {
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.getExpr().isDAafter(v);
    }

    public boolean isDUafter(Variable v) {
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.getExpr().isDUafter(v);
    }

    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeBoolean();
    }

    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getTypeAccessNoTransform()) {
            return NameType.TYPE_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

