/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Body;
import soot.JastAddJ.BooleanLiteral;
import soot.JastAddJ.BranchTargetStmt;
import soot.JastAddJ.BreakStmt;
import soot.JastAddJ.ContinueStmt;
import soot.JastAddJ.Expr;
import soot.JastAddJ.ExprStmt;
import soot.JastAddJ.List;
import soot.JastAddJ.Opt;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.Stmt;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.JastAddJ.VariableDeclaration;
import soot.JastAddJ.VariableScope;
import soot.jimple.Jimple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForStmt
extends BranchTargetStmt
implements Cloneable,
VariableScope {
    private int getNumInitStmt = 0;
    private int getNumUpdateStmt = 0;
    protected Map targetOf_ContinueStmt_values;
    protected Map targetOf_BreakStmt_values;
    protected Map isDUbeforeCondition_Variable_visited;
    protected Set isDUbeforeCondition_Variable_computed = new HashSet(4);
    protected Set isDUbeforeCondition_Variable_initialized = new HashSet(4);
    protected Map isDUbeforeCondition_Variable_values = new HashMap(4);
    protected Map localLookup_String_values;
    protected Map localVariableDeclaration_String_values;
    protected boolean cond_label_computed = false;
    protected soot.jimple.Stmt cond_label_value;
    protected boolean begin_label_computed = false;
    protected soot.jimple.Stmt begin_label_value;
    protected boolean update_label_computed = false;
    protected soot.jimple.Stmt update_label_value;
    protected boolean end_label_computed = false;
    protected soot.jimple.Stmt end_label_value;
    protected Map lookupVariable_String_values;

    @Override
    public void flushCache() {
        super.flushCache();
        this.targetOf_ContinueStmt_values = null;
        this.targetOf_BreakStmt_values = null;
        this.isDAafter_Variable_values = null;
        this.isDUafter_Variable_values = null;
        this.isDUbeforeCondition_Variable_visited = new HashMap(4);
        this.localLookup_String_values = null;
        this.localVariableDeclaration_String_values = null;
        this.canCompleteNormally_computed = false;
        this.cond_label_computed = false;
        this.cond_label_value = null;
        this.begin_label_computed = false;
        this.begin_label_value = null;
        this.update_label_computed = false;
        this.update_label_value = null;
        this.end_label_computed = false;
        this.end_label_value = null;
        this.lookupVariable_String_values = null;
    }

    @Override
    public ForStmt clone() throws CloneNotSupportedException {
        ForStmt node = (ForStmt)super.clone();
        node.targetOf_ContinueStmt_values = null;
        node.targetOf_BreakStmt_values = null;
        node.isDAafter_Variable_values = null;
        node.isDUafter_Variable_values = null;
        node.isDUbeforeCondition_Variable_visited = new HashMap(4);
        node.localLookup_String_values = null;
        node.localVariableDeclaration_String_values = null;
        node.canCompleteNormally_computed = false;
        node.cond_label_computed = false;
        node.cond_label_value = null;
        node.begin_label_computed = false;
        node.begin_label_value = null;
        node.update_label_computed = false;
        node.update_label_value = null;
        node.end_label_computed = false;
        node.end_label_value = null;
        node.lookupVariable_String_values = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ForStmt copy() {
        try {
            ForStmt node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ForStmt fullCopy() {
        ForStmt res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
        }
        return res;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append("for(");
        if (this.getNumInitStmt() > 0) {
            if (this.getInitStmt(0) instanceof VariableDeclaration) {
                int i;
                int minDimension = Integer.MAX_VALUE;
                for (int i2 = 0; i2 < this.getNumInitStmt(); ++i2) {
                    VariableDeclaration v = (VariableDeclaration)this.getInitStmt(i2);
                    minDimension = Math.min(minDimension, v.type().dimension());
                }
                VariableDeclaration v = (VariableDeclaration)this.getInitStmt(0);
                v.getModifiers().toString(s);
                s.append(v.type().elementType().typeName());
                for (i = minDimension; i > 0; --i) {
                    s.append("[]");
                }
                for (i = 0; i < this.getNumInitStmt(); ++i) {
                    if (i != 0) {
                        s.append(",");
                    }
                    v = (VariableDeclaration)this.getInitStmt(i);
                    s.append(" " + v.name());
                    for (int j = v.type().dimension() - minDimension; j > 0; --j) {
                        s.append("[]");
                    }
                    if (!v.hasInit()) continue;
                    s.append(" = ");
                    v.getInit().toString(s);
                }
            } else if (this.getInitStmt(0) instanceof ExprStmt) {
                ExprStmt stmt = (ExprStmt)this.getInitStmt(0);
                stmt.getExpr().toString(s);
                for (int i = 1; i < this.getNumInitStmt(); ++i) {
                    s.append(", ");
                    stmt = (ExprStmt)this.getInitStmt(i);
                    stmt.getExpr().toString(s);
                }
            } else {
                throw new Error("Unexpected initializer in for loop: " + this.getInitStmt(0));
            }
        }
        s.append("; ");
        if (this.hasCondition()) {
            this.getCondition().toString(s);
        }
        s.append("; ");
        if (this.getNumUpdateStmt() > 0) {
            ExprStmt stmt = (ExprStmt)this.getUpdateStmt(0);
            stmt.getExpr().toString(s);
            for (int i = 1; i < this.getNumUpdateStmt(); ++i) {
                s.append(", ");
                stmt = (ExprStmt)this.getUpdateStmt(i);
                stmt.getExpr().toString(s);
            }
        }
        s.append(") ");
        this.getStmt().toString(s);
    }

    @Override
    public void typeCheck() {
        TypeDecl cond;
        if (this.hasCondition() && !(cond = this.getCondition().type()).isBoolean()) {
            this.error("the type of \"" + this.getCondition() + "\" is " + cond.name() + " which is not boolean");
        }
    }

    @Override
    public void jimplify2(Body b) {
        int i;
        for (i = 0; i < this.getNumInitStmt(); ++i) {
            this.getInitStmt(i).jimplify2(b);
        }
        b.addLabel(this.cond_label());
        this.getCondition().emitEvalBranch(b);
        if (this.getCondition().canBeTrue()) {
            b.addLabel(this.begin_label());
            this.getStmt().jimplify2(b);
            b.addLabel(this.update_label());
            for (i = 0; i < this.getNumUpdateStmt(); ++i) {
                this.getUpdateStmt(i).jimplify2(b);
            }
            b.setLine(this);
            b.add(Jimple.v().newGotoStmt(this.cond_label()));
        }
        if (this.canCompleteNormally()) {
            b.addLabel(this.end_label());
        }
    }

    public ForStmt() {
        this.setChild(new List(), 0);
        this.setChild(new Opt(), 1);
        this.setChild(new List(), 2);
    }

    public ForStmt(List<Stmt> p0, Opt<Expr> p1, List<Stmt> p2, Stmt p3) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
        this.setChild(p2, 2);
        this.setChild(p3, 3);
    }

    @Override
    protected int numChildren() {
        return 4;
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    public void setInitStmtList(List<Stmt> list) {
        this.setChild(list, 0);
    }

    public int getNumInitStmt() {
        return this.getInitStmtList().getNumChild();
    }

    public Stmt getInitStmt(int i) {
        return (Stmt)this.getInitStmtList().getChild(i);
    }

    public void addInitStmt(Stmt node) {
        List<Stmt> list = this.getInitStmtList();
        list.addChild(node);
    }

    public void setInitStmt(Stmt node, int i) {
        List<Stmt> list = this.getInitStmtList();
        list.setChild(node, i);
    }

    public List<Stmt> getInitStmts() {
        return this.getInitStmtList();
    }

    public List<Stmt> getInitStmtsNoTransform() {
        return this.getInitStmtListNoTransform();
    }

    public List<Stmt> getInitStmtList() {
        return (List)this.getChild(0);
    }

    public List<Stmt> getInitStmtListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setConditionOpt(Opt<Expr> opt) {
        this.setChild(opt, 1);
    }

    public boolean hasCondition() {
        return this.getConditionOpt().getNumChild() != 0;
    }

    public Expr getCondition() {
        return (Expr)this.getConditionOpt().getChild(0);
    }

    public void setCondition(Expr node) {
        this.getConditionOpt().setChild(node, 0);
    }

    public Opt<Expr> getConditionOpt() {
        return (Opt)this.getChild(1);
    }

    public Opt<Expr> getConditionOptNoTransform() {
        return (Opt)this.getChildNoTransform(1);
    }

    public void setUpdateStmtList(List<Stmt> list) {
        this.setChild(list, 2);
    }

    public int getNumUpdateStmt() {
        return this.getUpdateStmtList().getNumChild();
    }

    public Stmt getUpdateStmt(int i) {
        return (Stmt)this.getUpdateStmtList().getChild(i);
    }

    public void addUpdateStmt(Stmt node) {
        List<Stmt> list = this.getUpdateStmtList();
        list.addChild(node);
    }

    public void setUpdateStmt(Stmt node, int i) {
        List<Stmt> list = this.getUpdateStmtList();
        list.setChild(node, i);
    }

    public List<Stmt> getUpdateStmts() {
        return this.getUpdateStmtList();
    }

    public List<Stmt> getUpdateStmtsNoTransform() {
        return this.getUpdateStmtListNoTransform();
    }

    public List<Stmt> getUpdateStmtList() {
        return (List)this.getChild(2);
    }

    public List<Stmt> getUpdateStmtListNoTransform() {
        return (List)this.getChildNoTransform(2);
    }

    public void setStmt(Stmt node) {
        this.setChild(node, 3);
    }

    public Stmt getStmt() {
        return (Stmt)this.getChild(3);
    }

    public Stmt getStmtNoTransform() {
        return (Stmt)this.getChildNoTransform(3);
    }

    @Override
    public boolean targetOf(ContinueStmt stmt) {
        ContinueStmt _parameters = stmt;
        if (this.targetOf_ContinueStmt_values == null) {
            this.targetOf_ContinueStmt_values = new HashMap(4);
        }
        if (this.targetOf_ContinueStmt_values.containsKey(_parameters)) {
            return (Boolean)this.targetOf_ContinueStmt_values.get(_parameters);
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean targetOf_ContinueStmt_value = this.targetOf_compute(stmt);
        if (isFinal && num == boundariesCrossed) {
            this.targetOf_ContinueStmt_values.put(_parameters, targetOf_ContinueStmt_value);
        }
        return targetOf_ContinueStmt_value;
    }

    private boolean targetOf_compute(ContinueStmt stmt) {
        return !stmt.hasLabel();
    }

    @Override
    public boolean targetOf(BreakStmt stmt) {
        BreakStmt _parameters = stmt;
        if (this.targetOf_BreakStmt_values == null) {
            this.targetOf_BreakStmt_values = new HashMap(4);
        }
        if (this.targetOf_BreakStmt_values.containsKey(_parameters)) {
            return (Boolean)this.targetOf_BreakStmt_values.get(_parameters);
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean targetOf_BreakStmt_value = this.targetOf_compute(stmt);
        if (isFinal && num == boundariesCrossed) {
            this.targetOf_BreakStmt_values.put(_parameters, targetOf_BreakStmt_value);
        }
        return targetOf_BreakStmt_value;
    }

    private boolean targetOf_compute(BreakStmt stmt) {
        return !stmt.hasLabel();
    }

    @Override
    public boolean isDAafter(Variable v) {
        Variable _parameters = v;
        if (this.isDAafter_Variable_values == null) {
            this.isDAafter_Variable_values = new HashMap(4);
        }
        if (this.isDAafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDAafter_Variable_values.get(_parameters);
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        if (isFinal && num == boundariesCrossed) {
            this.isDAafter_Variable_values.put(_parameters, isDAafter_Variable_value);
        }
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        if (this.hasCondition() && !this.getCondition().isDAafterFalse(v)) {
            return false;
        }
        for (BreakStmt stmt : this.targetBreaks()) {
            if (stmt.isDAafterReachedFinallyBlocks(v)) continue;
            return false;
        }
        return true;
    }

    public boolean isDAafterInitialization(Variable v) {
        boolean isDAafterInitialization_Variable_value = this.isDAafterInitialization_compute(v);
        return isDAafterInitialization_Variable_value;
    }

    private boolean isDAafterInitialization_compute(Variable v) {
        return this.getNumInitStmt() == 0 ? this.isDAbefore(v) : this.getInitStmt(this.getNumInitStmt() - 1).isDAafter(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        Variable _parameters = v;
        if (this.isDUafter_Variable_values == null) {
            this.isDUafter_Variable_values = new HashMap(4);
        }
        if (this.isDUafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDUafter_Variable_values.get(_parameters);
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        if (isFinal && num == boundariesCrossed) {
            this.isDUafter_Variable_values.put(_parameters, isDUafter_Variable_value);
        }
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        if (!this.isDUbeforeCondition(v)) {
            return false;
        }
        if (this.hasCondition() && !this.getCondition().isDUafterFalse(v)) {
            return false;
        }
        for (BreakStmt stmt : this.targetBreaks()) {
            if (stmt.isDUafterReachedFinallyBlocks(v)) continue;
            return false;
        }
        return true;
    }

    public boolean isDUafterInit(Variable v) {
        boolean isDUafterInit_Variable_value = this.isDUafterInit_compute(v);
        return isDUafterInit_Variable_value;
    }

    private boolean isDUafterInit_compute(Variable v) {
        return this.getNumInitStmt() == 0 ? this.isDUbefore(v) : this.getInitStmt(this.getNumInitStmt() - 1).isDUafter(v);
    }

    public boolean isDUbeforeCondition(Variable v) {
        Variable _parameters = v;
        if (this.isDUbeforeCondition_Variable_visited == null) {
            this.isDUbeforeCondition_Variable_visited = new HashMap(4);
        }
        if (this.isDUbeforeCondition_Variable_values == null) {
            this.isDUbeforeCondition_Variable_values = new HashMap(4);
        }
        if (this.isDUbeforeCondition_Variable_computed.contains(_parameters)) {
            return (Boolean)this.isDUbeforeCondition_Variable_values.get(_parameters);
        }
        if (!this.isDUbeforeCondition_Variable_initialized.contains(_parameters)) {
            this.isDUbeforeCondition_Variable_initialized.add(_parameters);
            this.isDUbeforeCondition_Variable_values.put(_parameters, true);
        }
        if (!IN_CIRCLE) {
            boolean new_isDUbeforeCondition_Variable_value;
            IN_CIRCLE = true;
            int num = boundariesCrossed;
            boolean isFinal = this.is$Final();
            CIRCLE_INDEX = 1;
            do {
                this.isDUbeforeCondition_Variable_visited.put(_parameters, new Integer(CIRCLE_INDEX));
                CHANGE = false;
                new_isDUbeforeCondition_Variable_value = this.isDUbeforeCondition_compute(v);
                if (new_isDUbeforeCondition_Variable_value != (Boolean)this.isDUbeforeCondition_Variable_values.get(_parameters)) {
                    CHANGE = true;
                }
                this.isDUbeforeCondition_Variable_values.put(_parameters, new_isDUbeforeCondition_Variable_value);
                ++CIRCLE_INDEX;
            } while (CHANGE);
            if (isFinal && num == boundariesCrossed) {
                this.isDUbeforeCondition_Variable_computed.add(_parameters);
            } else {
                RESET_CYCLE = true;
                this.isDUbeforeCondition_compute(v);
                RESET_CYCLE = false;
                this.isDUbeforeCondition_Variable_computed.remove(_parameters);
                this.isDUbeforeCondition_Variable_initialized.remove(_parameters);
            }
            IN_CIRCLE = false;
            return new_isDUbeforeCondition_Variable_value;
        }
        if (!new Integer(CIRCLE_INDEX).equals(this.isDUbeforeCondition_Variable_visited.get(_parameters))) {
            this.isDUbeforeCondition_Variable_visited.put(_parameters, new Integer(CIRCLE_INDEX));
            if (RESET_CYCLE) {
                this.isDUbeforeCondition_Variable_computed.remove(_parameters);
                this.isDUbeforeCondition_Variable_initialized.remove(_parameters);
                return (Boolean)this.isDUbeforeCondition_Variable_values.get(_parameters);
            }
            boolean new_isDUbeforeCondition_Variable_value = this.isDUbeforeCondition_compute(v);
            if (new_isDUbeforeCondition_Variable_value != (Boolean)this.isDUbeforeCondition_Variable_values.get(_parameters)) {
                CHANGE = true;
            }
            this.isDUbeforeCondition_Variable_values.put(_parameters, new_isDUbeforeCondition_Variable_value);
            return new_isDUbeforeCondition_Variable_value;
        }
        return (Boolean)this.isDUbeforeCondition_Variable_values.get(_parameters);
    }

    private boolean isDUbeforeCondition_compute(Variable v) {
        if (!this.isDUafterInit(v)) {
            return false;
        }
        return this.isDUafterUpdate(v);
    }

    public boolean isDUafterUpdate(Variable v) {
        boolean isDUafterUpdate_Variable_value = this.isDUafterUpdate_compute(v);
        return isDUafterUpdate_Variable_value;
    }

    private boolean isDUafterUpdate_compute(Variable v) {
        if (!this.isDUbeforeCondition(v)) {
            return false;
        }
        if (this.getNumUpdateStmt() > 0) {
            return this.getUpdateStmt(this.getNumUpdateStmt() - 1).isDUafter(v);
        }
        if (!this.getStmt().isDUafter(v)) {
            return false;
        }
        for (ContinueStmt stmt : this.targetContinues()) {
            if (stmt.isDUafterReachedFinallyBlocks(v)) continue;
            return false;
        }
        return true;
    }

    public SimpleSet localLookup(String name) {
        String _parameters = name;
        if (this.localLookup_String_values == null) {
            this.localLookup_String_values = new HashMap(4);
        }
        if (this.localLookup_String_values.containsKey(_parameters)) {
            return (SimpleSet)this.localLookup_String_values.get(_parameters);
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        SimpleSet localLookup_String_value = this.localLookup_compute(name);
        if (isFinal && num == boundariesCrossed) {
            this.localLookup_String_values.put(_parameters, localLookup_String_value);
        }
        return localLookup_String_value;
    }

    private SimpleSet localLookup_compute(String name) {
        VariableDeclaration v = this.localVariableDeclaration(name);
        if (v != null) {
            return v;
        }
        return this.lookupVariable(name);
    }

    public VariableDeclaration localVariableDeclaration(String name) {
        String _parameters = name;
        if (this.localVariableDeclaration_String_values == null) {
            this.localVariableDeclaration_String_values = new HashMap(4);
        }
        if (this.localVariableDeclaration_String_values.containsKey(_parameters)) {
            return (VariableDeclaration)this.localVariableDeclaration_String_values.get(_parameters);
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        VariableDeclaration localVariableDeclaration_String_value = this.localVariableDeclaration_compute(name);
        if (isFinal && num == boundariesCrossed) {
            this.localVariableDeclaration_String_values.put(_parameters, localVariableDeclaration_String_value);
        }
        return localVariableDeclaration_String_value;
    }

    private VariableDeclaration localVariableDeclaration_compute(String name) {
        for (int i = 0; i < this.getNumInitStmt(); ++i) {
            if (!this.getInitStmt(i).declaresVariable(name)) continue;
            return (VariableDeclaration)this.getInitStmt(i);
        }
        return null;
    }

    @Override
    public boolean continueLabel() {
        boolean continueLabel_value = this.continueLabel_compute();
        return continueLabel_value;
    }

    private boolean continueLabel_compute() {
        return true;
    }

    @Override
    public boolean canCompleteNormally() {
        if (this.canCompleteNormally_computed) {
            return this.canCompleteNormally_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.canCompleteNormally_value = this.canCompleteNormally_compute();
        if (isFinal && num == boundariesCrossed) {
            this.canCompleteNormally_computed = true;
        }
        return this.canCompleteNormally_value;
    }

    private boolean canCompleteNormally_compute() {
        return this.reachable() && this.hasCondition() && (!this.getCondition().isConstant() || !this.getCondition().isTrue()) || this.reachableBreak();
    }

    @Override
    public boolean definesLabel() {
        boolean definesLabel_value = this.definesLabel_compute();
        return definesLabel_value;
    }

    private boolean definesLabel_compute() {
        return true;
    }

    public soot.jimple.Stmt cond_label() {
        if (this.cond_label_computed) {
            return this.cond_label_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.cond_label_value = this.cond_label_compute();
        if (isFinal && num == boundariesCrossed) {
            this.cond_label_computed = true;
        }
        return this.cond_label_value;
    }

    private soot.jimple.Stmt cond_label_compute() {
        return this.newLabel();
    }

    public soot.jimple.Stmt begin_label() {
        if (this.begin_label_computed) {
            return this.begin_label_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.begin_label_value = this.begin_label_compute();
        if (isFinal && num == boundariesCrossed) {
            this.begin_label_computed = true;
        }
        return this.begin_label_value;
    }

    private soot.jimple.Stmt begin_label_compute() {
        return this.newLabel();
    }

    public soot.jimple.Stmt update_label() {
        if (this.update_label_computed) {
            return this.update_label_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.update_label_value = this.update_label_compute();
        if (isFinal && num == boundariesCrossed) {
            this.update_label_computed = true;
        }
        return this.update_label_value;
    }

    private soot.jimple.Stmt update_label_compute() {
        return this.newLabel();
    }

    public soot.jimple.Stmt end_label() {
        if (this.end_label_computed) {
            return this.end_label_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.end_label_value = this.end_label_compute();
        if (isFinal && num == boundariesCrossed) {
            this.end_label_computed = true;
        }
        return this.end_label_value;
    }

    private soot.jimple.Stmt end_label_compute() {
        return this.newLabel();
    }

    @Override
    public soot.jimple.Stmt break_label() {
        soot.jimple.Stmt break_label_value = this.break_label_compute();
        return break_label_value;
    }

    private soot.jimple.Stmt break_label_compute() {
        return this.end_label();
    }

    @Override
    public soot.jimple.Stmt continue_label() {
        soot.jimple.Stmt continue_label_value = this.continue_label_compute();
        return continue_label_value;
    }

    private soot.jimple.Stmt continue_label_compute() {
        return this.update_label();
    }

    @Override
    public SimpleSet lookupVariable(String name) {
        String _parameters = name;
        if (this.lookupVariable_String_values == null) {
            this.lookupVariable_String_values = new HashMap(4);
        }
        if (this.lookupVariable_String_values.containsKey(_parameters)) {
            return (SimpleSet)this.lookupVariable_String_values.get(_parameters);
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        SimpleSet lookupVariable_String_value = this.getParent().Define_SimpleSet_lookupVariable(this, null, name);
        if (isFinal && num == boundariesCrossed) {
            this.lookupVariable_String_values.put(_parameters, lookupVariable_String_value);
        }
        return lookupVariable_String_value;
    }

    @Override
    public boolean Define_boolean_insideLoop(ASTNode caller, ASTNode child) {
        if (caller == this.getStmtNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_insideLoop(this, caller);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getStmtNoTransform()) {
            return this.localLookup(name);
        }
        if (caller == this.getUpdateStmtListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.localLookup(name);
        }
        if (caller == this.getConditionOptNoTransform()) {
            return this.localLookup(name);
        }
        if (caller == this.getInitStmtListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.localLookup(name);
        }
        return this.getParent().Define_SimpleSet_lookupVariable(this, caller, name);
    }

    @Override
    public soot.jimple.Stmt Define_soot_jimple_Stmt_condition_false_label(ASTNode caller, ASTNode child) {
        if (caller == this.getConditionOptNoTransform()) {
            return this.end_label();
        }
        return this.getParent().Define_soot_jimple_Stmt_condition_false_label(this, caller);
    }

    @Override
    public soot.jimple.Stmt Define_soot_jimple_Stmt_condition_true_label(ASTNode caller, ASTNode child) {
        if (caller == this.getConditionOptNoTransform()) {
            return this.begin_label();
        }
        return this.getParent().Define_soot_jimple_Stmt_condition_true_label(this, caller);
    }

    @Override
    public boolean Define_boolean_reportUnreachable(ASTNode caller, ASTNode child) {
        if (caller == this.getStmtNoTransform()) {
            return this.reachable();
        }
        return this.getParent().Define_boolean_reportUnreachable(this, caller);
    }

    @Override
    public boolean Define_boolean_reachable(ASTNode caller, ASTNode child) {
        if (caller == this.getStmtNoTransform()) {
            return this.reachable() && (!this.hasCondition() || !this.getCondition().isConstant() || !this.getCondition().isFalse());
        }
        return this.getParent().Define_boolean_reachable(this, caller);
    }

    @Override
    public VariableScope Define_VariableScope_outerScope(ASTNode caller, ASTNode child) {
        if (caller == this.getStmtNoTransform()) {
            return this;
        }
        if (caller == this.getInitStmtListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this;
        }
        return this.getParent().Define_VariableScope_outerScope(this, caller);
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getUpdateStmtListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            if (!this.getStmt().isDAafter(v)) {
                return false;
            }
            for (ContinueStmt stmt : this.targetContinues()) {
                if (stmt.isDAafterReachedFinallyBlocks(v)) continue;
                return false;
            }
            return true;
        }
        if (caller == this.getStmtNoTransform()) {
            if (this.hasCondition() && this.getCondition().isDAafterTrue(v)) {
                return true;
            }
            return !this.hasCondition() && this.isDAafterInitialization(v);
        }
        if (caller == this.getConditionOptNoTransform()) {
            return this.isDAafterInitialization(v);
        }
        if (caller == this.getInitStmtListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            return i == 0 ? this.isDAbefore(v) : this.getInitStmt(i - 1).isDAafter(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getUpdateStmtListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            if (!this.isDUbeforeCondition(v)) {
                return false;
            }
            if (i == 0) {
                if (!this.getStmt().isDUafter(v)) {
                    return false;
                }
                for (ContinueStmt stmt : this.targetContinues()) {
                    if (stmt.isDUafterReachedFinallyBlocks(v)) continue;
                    return false;
                }
                return true;
            }
            return this.getUpdateStmt(i - 1).isDUafter(v);
        }
        if (caller == this.getStmtNoTransform()) {
            return this.isDUbeforeCondition(v) && (this.hasCondition() ? this.getCondition().isDUafterTrue(v) : this.isDUafterInit(v));
        }
        if (caller == this.getConditionOptNoTransform()) {
            return this.isDUbeforeCondition(v);
        }
        if (caller == this.getInitStmtListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return childIndex == 0 ? this.isDUbefore(v) : this.getInitStmt(childIndex - 1).isDUafter(v);
        }
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    @Override
    public ASTNode rewriteTo() {
        if (!this.hasCondition()) {
            ++duringDefiniteAssignment;
            ForStmt result = this.rewriteRule0();
            --duringDefiniteAssignment;
            return result;
        }
        return super.rewriteTo();
    }

    private ForStmt rewriteRule0() {
        this.setCondition(new BooleanLiteral("true"));
        return this;
    }
}

