/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.Collection;
import java.util.Iterator;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.AbstractDot;
import soot.JastAddJ.Access;
import soot.JastAddJ.Body;
import soot.JastAddJ.BodyDecl;
import soot.JastAddJ.BooleanType;
import soot.JastAddJ.Constant;
import soot.JastAddJ.ConstructorDecl;
import soot.JastAddJ.Dot;
import soot.JastAddJ.FieldDeclaration;
import soot.JastAddJ.List;
import soot.JastAddJ.NameType;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.Stmt;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.Local;
import soot.Type;
import soot.Value;
import soot.jimple.Jimple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expr
extends ASTNode<ASTNode>
implements Cloneable {
    protected boolean false_label_computed = false;
    protected soot.jimple.Stmt false_label_value;
    protected boolean true_label_computed = false;
    protected soot.jimple.Stmt true_label_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.false_label_computed = false;
        this.false_label_value = null;
        this.true_label_computed = false;
        this.true_label_value = null;
    }

    @Override
    public Expr clone() throws CloneNotSupportedException {
        Expr node = (Expr)super.clone();
        node.false_label_computed = false;
        node.false_label_value = null;
        node.true_label_computed = false;
        node.true_label_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public SimpleSet keepAccessibleTypes(SimpleSet oldSet) {
        SimpleSet newSet = SimpleSet.emptySet;
        TypeDecl hostType = this.hostType();
        Iterator iter = oldSet.iterator();
        while (iter.hasNext()) {
            TypeDecl t = (TypeDecl)iter.next();
            if ((hostType == null || !t.accessibleFrom(hostType)) && (hostType != null || !t.accessibleFromPackage(this.hostPackage()))) continue;
            newSet = newSet.add(t);
        }
        return newSet;
    }

    public SimpleSet keepAccessibleFields(SimpleSet oldSet) {
        SimpleSet newSet = SimpleSet.emptySet;
        Iterator iter = oldSet.iterator();
        while (iter.hasNext()) {
            FieldDeclaration f;
            Variable v = (Variable)iter.next();
            if (!(v instanceof FieldDeclaration) || !this.mayAccess(f = (FieldDeclaration)v)) continue;
            newSet = newSet.add(f);
        }
        return newSet;
    }

    private boolean mayAccess(FieldDeclaration f) {
        if (f.isPublic()) {
            return true;
        }
        if (f.isProtected()) {
            if (f.hostPackage().equals(this.hostPackage())) {
                return true;
            }
            TypeDecl C = f.hostType();
            TypeDecl S = this.hostType().subclassWithinBody(C);
            TypeDecl Q = this.type();
            if (S == null) {
                return false;
            }
            if (f.isInstanceVariable() && !this.isSuperAccess()) {
                return Q.instanceOf(S);
            }
            return true;
        }
        if (f.isPrivate()) {
            return f.hostType().topLevelType() == this.hostType().topLevelType();
        }
        return f.hostPackage().equals(this.hostType().hostPackage());
    }

    public Dot qualifiesAccess(Access access) {
        Dot dot;
        dot.lastDot = dot = new Dot(this, access);
        return dot;
    }

    protected SimpleSet chooseConstructor(Collection constructors, List argList) {
        ConstructorDecl decl;
        SimpleSet potentiallyApplicable = SimpleSet.emptySet;
        for (ConstructorDecl decl2 : constructors) {
            if (!decl2.potentiallyApplicable(argList) || !decl2.accessibleFrom(this.hostType())) continue;
            potentiallyApplicable = potentiallyApplicable.add(decl2);
        }
        SimpleSet maxSpecific = SimpleSet.emptySet;
        Iterator iter = potentiallyApplicable.iterator();
        while (iter.hasNext()) {
            decl = (ConstructorDecl)iter.next();
            if (!decl.applicableBySubtyping(argList)) continue;
            maxSpecific = Expr.mostSpecific(maxSpecific, decl);
        }
        if (maxSpecific.isEmpty()) {
            iter = potentiallyApplicable.iterator();
            while (iter.hasNext()) {
                decl = (ConstructorDecl)iter.next();
                if (!decl.applicableByMethodInvocationConversion(argList)) continue;
                maxSpecific = Expr.mostSpecific(maxSpecific, decl);
            }
        }
        if (maxSpecific.isEmpty()) {
            iter = potentiallyApplicable.iterator();
            while (iter.hasNext()) {
                decl = (ConstructorDecl)iter.next();
                if (!decl.isVariableArity() || !decl.applicableVariableArity(argList)) continue;
                maxSpecific = Expr.mostSpecific(maxSpecific, decl);
            }
        }
        return maxSpecific;
    }

    protected static SimpleSet mostSpecific(SimpleSet maxSpecific, ConstructorDecl decl) {
        if (maxSpecific.isEmpty()) {
            maxSpecific = maxSpecific.add(decl);
        } else if (decl.moreSpecificThan((ConstructorDecl)maxSpecific.iterator().next())) {
            maxSpecific = SimpleSet.emptySet.add(decl);
        } else if (!((ConstructorDecl)maxSpecific.iterator().next()).moreSpecificThan(decl)) {
            maxSpecific = maxSpecific.add(decl);
        }
        return maxSpecific;
    }

    protected Value emitBooleanCondition(Body b) {
        b.setLine(this);
        this.emitEvalBranch(b);
        soot.jimple.Stmt end_label = this.newLabel();
        b.addLabel(this.false_label());
        Local result = b.newTemp(soot.BooleanType.v());
        b.add(Jimple.v().newAssignStmt(result, BooleanType.emitConstant(false)));
        b.add(Jimple.v().newGotoStmt(end_label));
        b.addLabel(this.true_label());
        b.add(Jimple.v().newAssignStmt(result, BooleanType.emitConstant(true)));
        b.addLabel(end_label);
        return result;
    }

    public void refined_BooleanExpressions_emitEvalBranch(Body b) {
        b.setLine(this);
        if (this.isTrue()) {
            b.add(Jimple.v().newGotoStmt(this.true_label()));
        } else if (this.isFalse()) {
            b.add(Jimple.v().newGotoStmt(this.false_label()));
        } else {
            b.add(Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr(this.asImmediate(b, this.eval(b)), BooleanType.emitConstant(false)), this.false_label()));
            b.add(Jimple.v().newGotoStmt(this.true_label()));
        }
    }

    public Value eval(Body b) {
        throw new Error("Operation eval not supported for " + this.getClass().getName());
    }

    public Value emitStore(Body b, Value lvalue, Value rvalue) {
        b.setLine(this);
        b.add(Jimple.v().newAssignStmt(lvalue, this.asLocal(b, rvalue, lvalue.getType())));
        return rvalue;
    }

    @Override
    public void collectTypesToHierarchy(Collection<Type> set) {
        super.collectTypesToHierarchy(set);
        this.addDependencyIfNeeded(set, this.type());
    }

    protected void addDependencyIfNeeded(Collection<Type> set, TypeDecl type) {
        if ((type = type.elementType().erasure()).isReferenceType() && !type.isUnknown()) {
            set.add(type.getSootType());
        }
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void emitEvalBranch(Body b) {
        if (this.type().isReferenceType()) {
            b.setLine(this);
            b.add(Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr(this.asImmediate(b, this.type().emitUnboxingOperation(b, this.eval(b))), BooleanType.emitConstant(false)), this.false_label()));
            b.add(Jimple.v().newGotoStmt(this.true_label()));
        } else {
            this.refined_BooleanExpressions_emitEvalBranch(b);
        }
    }

    public abstract TypeDecl type();

    public Constant constant() {
        Constant constant_value = this.constant_compute();
        return constant_value;
    }

    private Constant constant_compute() {
        throw new UnsupportedOperationException("ConstantExpression operation constant not supported for type " + this.getClass().getName());
    }

    public boolean isPositive() {
        boolean isPositive_value = this.isPositive_compute();
        return isPositive_value;
    }

    private boolean isPositive_compute() {
        return false;
    }

    public boolean representableIn(TypeDecl t) {
        boolean representableIn_TypeDecl_value = this.representableIn_compute(t);
        return representableIn_TypeDecl_value;
    }

    private boolean representableIn_compute(TypeDecl t) {
        if (!(this.type().isByte() || this.type().isChar() || this.type().isShort() || this.type().isInt())) {
            return false;
        }
        if (t.isByte()) {
            return this.constant().intValue() >= -128 && this.constant().intValue() <= 127;
        }
        if (t.isChar()) {
            return this.constant().intValue() >= 0 && this.constant().intValue() <= 65535;
        }
        if (t.isShort()) {
            return this.constant().intValue() >= Short.MIN_VALUE && this.constant().intValue() <= Short.MAX_VALUE;
        }
        if (t.isInt()) {
            return this.constant().intValue() >= Integer.MIN_VALUE && this.constant().intValue() <= Integer.MAX_VALUE;
        }
        return false;
    }

    public boolean isConstant() {
        boolean isConstant_value = this.isConstant_compute();
        return isConstant_value;
    }

    private boolean isConstant_compute() {
        return false;
    }

    public boolean isTrue() {
        boolean isTrue_value = this.isTrue_compute();
        return isTrue_value;
    }

    private boolean isTrue_compute() {
        return this.isConstant() && this.type() instanceof BooleanType && this.constant().booleanValue();
    }

    public boolean isFalse() {
        boolean isFalse_value = this.isFalse_compute();
        return isFalse_value;
    }

    private boolean isFalse_compute() {
        return this.isConstant() && this.type() instanceof BooleanType && !this.constant().booleanValue();
    }

    public Variable varDecl() {
        Variable varDecl_value = this.varDecl_compute();
        return varDecl_value;
    }

    private Variable varDecl_compute() {
        return null;
    }

    public boolean isDAafterFalse(Variable v) {
        boolean isDAafterFalse_Variable_value = this.isDAafterFalse_compute(v);
        return isDAafterFalse_Variable_value;
    }

    private boolean isDAafterFalse_compute(Variable v) {
        return this.isTrue() || this.isDAbefore(v);
    }

    public boolean isDAafterTrue(Variable v) {
        boolean isDAafterTrue_Variable_value = this.isDAafterTrue_compute(v);
        return isDAafterTrue_Variable_value;
    }

    private boolean isDAafterTrue_compute(Variable v) {
        return this.isFalse() || this.isDAbefore(v);
    }

    public boolean isDAafter(Variable v) {
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.isDAafterFalse(v) && this.isDAafterTrue(v) || this.isDAbefore(v);
    }

    public boolean isDUafterFalse(Variable v) {
        boolean isDUafterFalse_Variable_value = this.isDUafterFalse_compute(v);
        return isDUafterFalse_Variable_value;
    }

    private boolean isDUafterFalse_compute(Variable v) {
        if (this.isTrue()) {
            return true;
        }
        return this.isDUbefore(v);
    }

    public boolean isDUafterTrue(Variable v) {
        boolean isDUafterTrue_Variable_value = this.isDUafterTrue_compute(v);
        return isDUafterTrue_Variable_value;
    }

    private boolean isDUafterTrue_compute(Variable v) {
        if (this.isFalse()) {
            return true;
        }
        return this.isDUbefore(v);
    }

    public boolean isDUafter(Variable v) {
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.isDUafterFalse(v) && this.isDUafterTrue(v) || this.isDUbefore(v);
    }

    public SimpleSet mostSpecificConstructor(Collection constructors) {
        SimpleSet mostSpecificConstructor_Collection_value = this.mostSpecificConstructor_compute(constructors);
        return mostSpecificConstructor_Collection_value;
    }

    private SimpleSet mostSpecificConstructor_compute(Collection constructors) {
        SimpleSet maxSpecific = SimpleSet.emptySet;
        for (ConstructorDecl decl : constructors) {
            if (!this.applicableAndAccessible(decl)) continue;
            if (maxSpecific.isEmpty()) {
                maxSpecific = maxSpecific.add(decl);
                continue;
            }
            if (decl.moreSpecificThan((ConstructorDecl)maxSpecific.iterator().next())) {
                maxSpecific = SimpleSet.emptySet.add(decl);
                continue;
            }
            if (((ConstructorDecl)maxSpecific.iterator().next()).moreSpecificThan(decl)) continue;
            maxSpecific = maxSpecific.add(decl);
        }
        return maxSpecific;
    }

    public boolean applicableAndAccessible(ConstructorDecl decl) {
        boolean applicableAndAccessible_ConstructorDecl_value = this.applicableAndAccessible_compute(decl);
        return applicableAndAccessible_ConstructorDecl_value;
    }

    private boolean applicableAndAccessible_compute(ConstructorDecl decl) {
        return false;
    }

    public boolean hasQualifiedPackage(String packageName) {
        boolean hasQualifiedPackage_String_value = this.hasQualifiedPackage_compute(packageName);
        return hasQualifiedPackage_String_value;
    }

    private boolean hasQualifiedPackage_compute(String packageName) {
        return false;
    }

    public SimpleSet qualifiedLookupType(String name) {
        SimpleSet qualifiedLookupType_String_value = this.qualifiedLookupType_compute(name);
        return qualifiedLookupType_String_value;
    }

    private SimpleSet qualifiedLookupType_compute(String name) {
        return this.keepAccessibleTypes(this.type().memberTypes(name));
    }

    public SimpleSet qualifiedLookupVariable(String name) {
        SimpleSet qualifiedLookupVariable_String_value = this.qualifiedLookupVariable_compute(name);
        return qualifiedLookupVariable_String_value;
    }

    private SimpleSet qualifiedLookupVariable_compute(String name) {
        if (this.type().accessibleFrom(this.hostType())) {
            return this.keepAccessibleFields(this.type().memberFields(name));
        }
        return SimpleSet.emptySet;
    }

    public String packageName() {
        String packageName_value = this.packageName_compute();
        return packageName_value;
    }

    private String packageName_compute() {
        return "";
    }

    public String typeName() {
        String typeName_value = this.typeName_compute();
        return typeName_value;
    }

    private String typeName_compute() {
        return "";
    }

    public boolean isTypeAccess() {
        boolean isTypeAccess_value = this.isTypeAccess_compute();
        return isTypeAccess_value;
    }

    private boolean isTypeAccess_compute() {
        return false;
    }

    public boolean isMethodAccess() {
        boolean isMethodAccess_value = this.isMethodAccess_compute();
        return isMethodAccess_value;
    }

    private boolean isMethodAccess_compute() {
        return false;
    }

    public boolean isFieldAccess() {
        boolean isFieldAccess_value = this.isFieldAccess_compute();
        return isFieldAccess_value;
    }

    private boolean isFieldAccess_compute() {
        return false;
    }

    public boolean isSuperAccess() {
        boolean isSuperAccess_value = this.isSuperAccess_compute();
        return isSuperAccess_value;
    }

    private boolean isSuperAccess_compute() {
        return false;
    }

    public boolean isThisAccess() {
        boolean isThisAccess_value = this.isThisAccess_compute();
        return isThisAccess_value;
    }

    private boolean isThisAccess_compute() {
        return false;
    }

    public boolean isPackageAccess() {
        boolean isPackageAccess_value = this.isPackageAccess_compute();
        return isPackageAccess_value;
    }

    private boolean isPackageAccess_compute() {
        return false;
    }

    public boolean isArrayAccess() {
        boolean isArrayAccess_value = this.isArrayAccess_compute();
        return isArrayAccess_value;
    }

    private boolean isArrayAccess_compute() {
        return false;
    }

    public boolean isClassAccess() {
        boolean isClassAccess_value = this.isClassAccess_compute();
        return isClassAccess_value;
    }

    private boolean isClassAccess_compute() {
        return false;
    }

    public boolean isSuperConstructorAccess() {
        boolean isSuperConstructorAccess_value = this.isSuperConstructorAccess_compute();
        return isSuperConstructorAccess_value;
    }

    private boolean isSuperConstructorAccess_compute() {
        return false;
    }

    public boolean isLeftChildOfDot() {
        boolean isLeftChildOfDot_value = this.isLeftChildOfDot_compute();
        return isLeftChildOfDot_value;
    }

    private boolean isLeftChildOfDot_compute() {
        return this.hasParentDot() && this.parentDot().getLeft() == this;
    }

    public boolean isRightChildOfDot() {
        boolean isRightChildOfDot_value = this.isRightChildOfDot_compute();
        return isRightChildOfDot_value;
    }

    private boolean isRightChildOfDot_compute() {
        return this.hasParentDot() && this.parentDot().getRight() == this;
    }

    public AbstractDot parentDot() {
        AbstractDot parentDot_value = this.parentDot_compute();
        return parentDot_value;
    }

    private AbstractDot parentDot_compute() {
        return this.getParent() instanceof AbstractDot ? (AbstractDot)this.getParent() : null;
    }

    public boolean hasParentDot() {
        boolean hasParentDot_value = this.hasParentDot_compute();
        return hasParentDot_value;
    }

    private boolean hasParentDot_compute() {
        return this.parentDot() != null;
    }

    public Access nextAccess() {
        Access nextAccess_value = this.nextAccess_compute();
        return nextAccess_value;
    }

    private Access nextAccess_compute() {
        return this.parentDot().nextAccess();
    }

    public boolean hasNextAccess() {
        boolean hasNextAccess_value = this.hasNextAccess_compute();
        return hasNextAccess_value;
    }

    private boolean hasNextAccess_compute() {
        return this.isLeftChildOfDot();
    }

    public Stmt enclosingStmt() {
        Stmt enclosingStmt_value = this.enclosingStmt_compute();
        return enclosingStmt_value;
    }

    private Stmt enclosingStmt_compute() {
        ASTNode node;
        for (node = this; node != null && !(node instanceof Stmt); node = node.getParent()) {
        }
        return (Stmt)node;
    }

    public boolean isVariable() {
        boolean isVariable_value = this.isVariable_compute();
        return isVariable_value;
    }

    private boolean isVariable_compute() {
        return false;
    }

    public boolean isUnknown() {
        boolean isUnknown_value = this.isUnknown_compute();
        return isUnknown_value;
    }

    private boolean isUnknown_compute() {
        return this.type().isUnknown();
    }

    public boolean staticContextQualifier() {
        boolean staticContextQualifier_value = this.staticContextQualifier_compute();
        return staticContextQualifier_value;
    }

    private boolean staticContextQualifier_compute() {
        return false;
    }

    public soot.jimple.Stmt false_label() {
        if (this.false_label_computed) {
            return this.false_label_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.false_label_value = this.false_label_compute();
        if (isFinal && num == boundariesCrossed) {
            this.false_label_computed = true;
        }
        return this.false_label_value;
    }

    private soot.jimple.Stmt false_label_compute() {
        return this.getParent().definesLabel() ? this.condition_false_label() : this.newLabel();
    }

    public soot.jimple.Stmt true_label() {
        if (this.true_label_computed) {
            return this.true_label_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.true_label_value = this.true_label_compute();
        if (isFinal && num == boundariesCrossed) {
            this.true_label_computed = true;
        }
        return this.true_label_value;
    }

    private soot.jimple.Stmt true_label_compute() {
        return this.getParent().definesLabel() ? this.condition_true_label() : this.newLabel();
    }

    public boolean canBeTrue() {
        boolean canBeTrue_value = this.canBeTrue_compute();
        return canBeTrue_value;
    }

    private boolean canBeTrue_compute() {
        return !this.isFalse();
    }

    public boolean canBeFalse() {
        boolean canBeFalse_value = this.canBeFalse_compute();
        return canBeFalse_value;
    }

    private boolean canBeFalse_compute() {
        return !this.isTrue();
    }

    public boolean isDest() {
        boolean isDest_value = this.getParent().Define_boolean_isDest(this, null);
        return isDest_value;
    }

    public boolean isSource() {
        boolean isSource_value = this.getParent().Define_boolean_isSource(this, null);
        return isSource_value;
    }

    public boolean isIncOrDec() {
        boolean isIncOrDec_value = this.getParent().Define_boolean_isIncOrDec(this, null);
        return isIncOrDec_value;
    }

    public boolean isDAbefore(Variable v) {
        boolean isDAbefore_Variable_value = this.getParent().Define_boolean_isDAbefore(this, null, v);
        return isDAbefore_Variable_value;
    }

    public boolean isDUbefore(Variable v) {
        boolean isDUbefore_Variable_value = this.getParent().Define_boolean_isDUbefore(this, null, v);
        return isDUbefore_Variable_value;
    }

    public Collection lookupMethod(String name) {
        Collection lookupMethod_String_value = this.getParent().Define_Collection_lookupMethod(this, null, name);
        return lookupMethod_String_value;
    }

    public TypeDecl typeBoolean() {
        TypeDecl typeBoolean_value = this.getParent().Define_TypeDecl_typeBoolean(this, null);
        return typeBoolean_value;
    }

    public TypeDecl typeByte() {
        TypeDecl typeByte_value = this.getParent().Define_TypeDecl_typeByte(this, null);
        return typeByte_value;
    }

    public TypeDecl typeShort() {
        TypeDecl typeShort_value = this.getParent().Define_TypeDecl_typeShort(this, null);
        return typeShort_value;
    }

    public TypeDecl typeChar() {
        TypeDecl typeChar_value = this.getParent().Define_TypeDecl_typeChar(this, null);
        return typeChar_value;
    }

    public TypeDecl typeInt() {
        TypeDecl typeInt_value = this.getParent().Define_TypeDecl_typeInt(this, null);
        return typeInt_value;
    }

    public TypeDecl typeLong() {
        TypeDecl typeLong_value = this.getParent().Define_TypeDecl_typeLong(this, null);
        return typeLong_value;
    }

    public TypeDecl typeFloat() {
        TypeDecl typeFloat_value = this.getParent().Define_TypeDecl_typeFloat(this, null);
        return typeFloat_value;
    }

    public TypeDecl typeDouble() {
        TypeDecl typeDouble_value = this.getParent().Define_TypeDecl_typeDouble(this, null);
        return typeDouble_value;
    }

    public TypeDecl typeString() {
        TypeDecl typeString_value = this.getParent().Define_TypeDecl_typeString(this, null);
        return typeString_value;
    }

    public TypeDecl typeVoid() {
        TypeDecl typeVoid_value = this.getParent().Define_TypeDecl_typeVoid(this, null);
        return typeVoid_value;
    }

    public TypeDecl typeNull() {
        TypeDecl typeNull_value = this.getParent().Define_TypeDecl_typeNull(this, null);
        return typeNull_value;
    }

    public TypeDecl unknownType() {
        TypeDecl unknownType_value = this.getParent().Define_TypeDecl_unknownType(this, null);
        return unknownType_value;
    }

    public boolean hasPackage(String packageName) {
        boolean hasPackage_String_value = this.getParent().Define_boolean_hasPackage(this, null, packageName);
        return hasPackage_String_value;
    }

    public TypeDecl lookupType(String packageName, String typeName) {
        TypeDecl lookupType_String_String_value = this.getParent().Define_TypeDecl_lookupType(this, null, packageName, typeName);
        return lookupType_String_String_value;
    }

    public SimpleSet lookupType(String name) {
        SimpleSet lookupType_String_value = this.getParent().Define_SimpleSet_lookupType(this, null, name);
        return lookupType_String_value;
    }

    public SimpleSet lookupVariable(String name) {
        SimpleSet lookupVariable_String_value = this.getParent().Define_SimpleSet_lookupVariable(this, null, name);
        return lookupVariable_String_value;
    }

    public NameType nameType() {
        NameType nameType_value = this.getParent().Define_NameType_nameType(this, null);
        return nameType_value;
    }

    public BodyDecl enclosingBodyDecl() {
        BodyDecl enclosingBodyDecl_value = this.getParent().Define_BodyDecl_enclosingBodyDecl(this, null);
        return enclosingBodyDecl_value;
    }

    public String hostPackage() {
        String hostPackage_value = this.getParent().Define_String_hostPackage(this, null);
        return hostPackage_value;
    }

    public TypeDecl hostType() {
        TypeDecl hostType_value = this.getParent().Define_TypeDecl_hostType(this, null);
        return hostType_value;
    }

    public String methodHost() {
        String methodHost_value = this.getParent().Define_String_methodHost(this, null);
        return methodHost_value;
    }

    public boolean inStaticContext() {
        boolean inStaticContext_value = this.getParent().Define_boolean_inStaticContext(this, null);
        return inStaticContext_value;
    }

    public TypeDecl assignConvertedType() {
        TypeDecl assignConvertedType_value = this.getParent().Define_TypeDecl_assignConvertedType(this, null);
        return assignConvertedType_value;
    }

    public soot.jimple.Stmt condition_false_label() {
        soot.jimple.Stmt condition_false_label_value = this.getParent().Define_soot_jimple_Stmt_condition_false_label(this, null);
        return condition_false_label_value;
    }

    public soot.jimple.Stmt condition_true_label() {
        soot.jimple.Stmt condition_true_label_value = this.getParent().Define_soot_jimple_Stmt_condition_true_label(this, null);
        return condition_true_label_value;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

