/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constant;
import soot.JastAddJ.Expr;
import soot.JastAddJ.MultiplicativeExpr;
import soot.Value;
import soot.jimple.Jimple;

public class DivExpr
extends MultiplicativeExpr
implements Cloneable {
    protected int isConstant_visited;
    protected boolean isConstant_computed = false;
    protected boolean isConstant_initialized = false;
    protected boolean isConstant_value;

    public void flushCache() {
        super.flushCache();
        this.isConstant_visited = 0;
        this.isConstant_computed = false;
        this.isConstant_initialized = false;
    }

    public DivExpr clone() throws CloneNotSupportedException {
        DivExpr node = (DivExpr)super.clone();
        node.isConstant_visited = 0;
        node.isConstant_computed = false;
        node.isConstant_initialized = false;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public DivExpr copy() {
        try {
            DivExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public DivExpr fullCopy() {
        DivExpr res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
        }
        return res;
    }

    public Value emitOperation(Body b, Value left, Value right) {
        return this.asLocal(b, Jimple.v().newDivExpr(this.asImmediate(b, left), this.asImmediate(b, right)));
    }

    public DivExpr() {
    }

    public DivExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    protected int numChildren() {
        return 2;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setLeftOperand(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getLeftOperand() {
        return (Expr)this.getChild(0);
    }

    public Expr getLeftOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void setRightOperand(Expr node) {
        this.setChild(node, 1);
    }

    public Expr getRightOperand() {
        return (Expr)this.getChild(1);
    }

    public Expr getRightOperandNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    public Constant constant() {
        Constant constant_value = this.constant_compute();
        return constant_value;
    }

    private Constant constant_compute() {
        return this.type().div(this.getLeftOperand().constant(), this.getRightOperand().constant());
    }

    public boolean isConstant() {
        if (this.isConstant_computed) {
            return this.isConstant_value;
        }
        if (!this.isConstant_initialized) {
            this.isConstant_initialized = true;
            this.isConstant_value = false;
        }
        if (!IN_CIRCLE) {
            IN_CIRCLE = true;
            int num = boundariesCrossed;
            boolean isFinal = this.is$Final();
            CIRCLE_INDEX = 1;
            do {
                this.isConstant_visited = CIRCLE_INDEX;
                CHANGE = false;
                boolean new_isConstant_value = this.isConstant_compute();
                if (new_isConstant_value != this.isConstant_value) {
                    CHANGE = true;
                }
                this.isConstant_value = new_isConstant_value;
                ++CIRCLE_INDEX;
            } while (CHANGE);
            if (isFinal && num == boundariesCrossed) {
                this.isConstant_computed = true;
            } else {
                RESET_CYCLE = true;
                this.isConstant_compute();
                RESET_CYCLE = false;
                this.isConstant_computed = false;
                this.isConstant_initialized = false;
            }
            IN_CIRCLE = false;
            return this.isConstant_value;
        }
        if (this.isConstant_visited != CIRCLE_INDEX) {
            this.isConstant_visited = CIRCLE_INDEX;
            if (RESET_CYCLE) {
                this.isConstant_computed = false;
                this.isConstant_initialized = false;
                return this.isConstant_value;
            }
            boolean new_isConstant_value = this.isConstant_compute();
            if (new_isConstant_value != this.isConstant_value) {
                CHANGE = true;
            }
            this.isConstant_value = new_isConstant_value;
            return this.isConstant_value;
        }
        return this.isConstant_value;
    }

    private boolean isConstant_compute() {
        return this.getLeftOperand().isConstant() && this.getRightOperand().isConstant() && (!this.getRightOperand().type().isInt() || this.getRightOperand().constant().intValue() != 0);
    }

    public String printOp() {
        String printOp_value = this.printOp_compute();
        return printOp_value;
    }

    private String printOp_compute() {
        return " / ";
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

