/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Case;
import soot.JastAddJ.EnumConstant;
import soot.JastAddJ.Expr;
import soot.JastAddJ.IntegerLiteral;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.VarAccess;

public class ConstCase
extends Case
implements Cloneable {
    public void flushCache() {
        super.flushCache();
    }

    public ConstCase clone() throws CloneNotSupportedException {
        ConstCase node = (ConstCase)super.clone();
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ConstCase copy() {
        try {
            ConstCase node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ConstCase fullCopy() {
        ConstCase res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
        }
        return res;
    }

    public void nameCheck() {
        if (this.getValue().isConstant() && this.bind(this) != this) {
            this.error("constant expression " + this.getValue() + " is multiply declared in two case statements");
        }
    }

    public void toString(StringBuffer s) {
        s.append(ConstCase.indent());
        s.append("case ");
        this.getValue().toString(s);
        s.append(":\n");
    }

    public void refined_TypeCheck_typeCheck() {
        TypeDecl switchType = this.switchType();
        TypeDecl type = this.getValue().type();
        if (!type.assignConversionTo(switchType, this.getValue())) {
            this.error("Constant expression must be assignable to Expression");
        }
        if (!this.getValue().isConstant() && !this.getValue().type().isUnknown()) {
            this.error("Switch expression must be constant");
        }
    }

    public void transformation() {
        if (this.getValue() instanceof VarAccess && this.getValue().varDecl() instanceof EnumConstant) {
            int i = this.hostType().createEnumIndex((EnumConstant)this.getValue().varDecl());
            this.setValue(new IntegerLiteral(new Integer(i).toString()));
        }
        super.transformation();
    }

    public ConstCase() {
    }

    public ConstCase(Expr p0) {
        this.setChild(p0, 0);
    }

    protected int numChildren() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setValue(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getValue() {
        return (Expr)this.getChild(0);
    }

    public Expr getValueNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void typeCheck() {
        if (!(!this.switchType().isEnumDecl() || this.getValue() instanceof VarAccess && this.getValue().varDecl() instanceof EnumConstant)) {
            this.error("Unqualified enumeration constant required");
        } else {
            this.refined_TypeCheck_typeCheck();
        }
    }

    private boolean refined_NameCheck_constValue_Case(Case c) {
        if (!(c instanceof ConstCase) || !this.getValue().isConstant()) {
            return false;
        }
        if (!this.getValue().type().assignableToInt() || !((ConstCase)c).getValue().type().assignableToInt()) {
            return false;
        }
        return this.getValue().constant().intValue() == ((ConstCase)c).getValue().constant().intValue();
    }

    public boolean constValue(Case c) {
        boolean constValue_Case_value = this.constValue_compute(c);
        return constValue_Case_value;
    }

    private boolean constValue_compute(Case c) {
        if (this.switchType().isEnumDecl()) {
            if (!(c instanceof ConstCase) || !this.getValue().isConstant()) {
                return false;
            }
            return this.getValue().varDecl() == ((ConstCase)c).getValue().varDecl();
        }
        return this.refined_NameCheck_constValue_Case(c);
    }

    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getValueNoTransform()) {
            return this.switchType().isEnumDecl() ? this.switchType().memberFields(name) : this.lookupVariable(name);
        }
        return this.getParent().Define_SimpleSet_lookupVariable(this, caller, name);
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

