/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Access;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constant;
import soot.JastAddJ.Expr;
import soot.JastAddJ.NameType;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.Value;
import soot.jimple.NullConstant;

public class CastExpr
extends Expr
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    public CastExpr clone() throws CloneNotSupportedException {
        CastExpr node = (CastExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public CastExpr copy() {
        try {
            CastExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public CastExpr fullCopy() {
        CastExpr res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
        }
        return res;
    }

    public void toString(StringBuffer s) {
        s.append("(");
        this.getTypeAccess().toString(s);
        s.append(")");
        this.getExpr().toString(s);
    }

    public void typeCheck() {
        TypeDecl expr = this.getExpr().type();
        TypeDecl type = this.getTypeAccess().type();
        if (!expr.isUnknown()) {
            if (!expr.castingConversionTo(type)) {
                this.error(expr.typeName() + " can not be cast into " + type.typeName());
            }
            if (!this.getTypeAccess().isTypeAccess()) {
                this.error("" + this.getTypeAccess() + " is not a type access in cast expression");
            }
        }
    }

    public Value eval(Body b) {
        if (this.isConstant()) {
            return CastExpr.emitConstant(this.constant());
        }
        Value operand = this.getExpr().eval(b);
        if (operand == NullConstant.v()) {
            return this.getExpr().type().emitCastTo(b, operand, this.type());
        }
        return this.getExpr().type().emitCastTo(b, this.asLocal(b, operand), this.type());
    }

    public CastExpr() {
    }

    public CastExpr(Access p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    protected int numChildren() {
        return 2;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setTypeAccess(Access node) {
        this.setChild(node, 0);
    }

    public Access getTypeAccess() {
        return (Access)this.getChild(0);
    }

    public Access getTypeAccessNoTransform() {
        return (Access)this.getChildNoTransform(0);
    }

    public void setExpr(Expr node) {
        this.setChild(node, 1);
    }

    public Expr getExpr() {
        return (Expr)this.getChild(1);
    }

    public Expr getExprNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    public Constant constant() {
        Constant constant_value = this.constant_compute();
        return constant_value;
    }

    private Constant constant_compute() {
        return this.type().cast(this.getExpr().constant());
    }

    public boolean isConstant() {
        boolean isConstant_value = this.isConstant_compute();
        return isConstant_value;
    }

    private boolean isConstant_compute() {
        return this.getExpr().isConstant() && (this.getTypeAccess().type().isPrimitive() || this.getTypeAccess().type().isString());
    }

    public boolean isDAafter(Variable v) {
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.getExpr().isDAafter(v);
    }

    public boolean isDUafter(Variable v) {
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.getExpr().isDUafter(v);
    }

    public boolean isSuperAccess() {
        boolean isSuperAccess_value = this.isSuperAccess_compute();
        return isSuperAccess_value;
    }

    private boolean isSuperAccess_compute() {
        return this.getExpr().isSuperAccess();
    }

    public boolean isThisAccess() {
        boolean isThisAccess_value = this.isThisAccess_compute();
        return isThisAccess_value;
    }

    private boolean isThisAccess_compute() {
        return this.getExpr().isThisAccess();
    }

    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.getTypeAccess().type();
    }

    public boolean staticContextQualifier() {
        boolean staticContextQualifier_value = this.staticContextQualifier_compute();
        return staticContextQualifier_value;
    }

    private boolean staticContextQualifier_compute() {
        return this.getExpr().staticContextQualifier();
    }

    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getTypeAccessNoTransform()) {
            return NameType.TYPE_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

