/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.AssignExpr;
import soot.JastAddJ.Body;
import soot.JastAddJ.Expr;
import soot.JastAddJ.TypeDecl;
import soot.Value;

public class AssignSimpleExpr
extends AssignExpr
implements Cloneable {
    public void flushCache() {
        super.flushCache();
    }

    public AssignSimpleExpr clone() throws CloneNotSupportedException {
        AssignSimpleExpr node = (AssignSimpleExpr)super.clone();
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public AssignSimpleExpr copy() {
        try {
            AssignSimpleExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public AssignSimpleExpr fullCopy() {
        AssignSimpleExpr res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
        }
        return res;
    }

    public void typeCheck() {
        if (!this.getDest().isVariable()) {
            this.error("left hand side is not a variable");
        } else if (!this.sourceType().assignConversionTo(this.getDest().type(), this.getSource()) && !this.sourceType().isUnknown()) {
            this.error("can not assign " + this.getDest() + " of type " + this.getDest().type().typeName() + " a value of type " + this.sourceType().typeName());
        }
    }

    public Value eval(Body b) {
        Value lvalue = this.getDest().eval(b);
        Value rvalue = this.asRValue(b, this.getSource().type().emitCastTo(b, this.getSource(), this.getDest().type()));
        return this.getDest().emitStore(b, lvalue, this.asImmediate(b, rvalue));
    }

    public AssignSimpleExpr() {
    }

    public AssignSimpleExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    protected int numChildren() {
        return 2;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setDest(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getDest() {
        return (Expr)this.getChild(0);
    }

    public Expr getDestNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void setSource(Expr node) {
        this.setChild(node, 1);
    }

    public Expr getSource() {
        return (Expr)this.getChild(1);
    }

    public Expr getSourceNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    public String printOp() {
        String printOp_value = this.printOp_compute();
        return printOp_value;
    }

    private String printOp_compute() {
        return " = ";
    }

    public TypeDecl sourceType() {
        TypeDecl sourceType_value = this.sourceType_compute();
        return sourceType_value;
    }

    private TypeDecl sourceType_compute() {
        return this.getSource().type();
    }

    public boolean Define_boolean_isSource(ASTNode caller, ASTNode child) {
        if (caller == this.getDestNoTransform()) {
            return false;
        }
        return super.Define_boolean_isSource(caller, child);
    }

    public TypeDecl Define_TypeDecl_assignConvertedType(ASTNode caller, ASTNode child) {
        if (caller == this.getSourceNoTransform()) {
            return this.getDest().type();
        }
        return this.getParent().Define_TypeDecl_assignConvertedType(this, caller);
    }

    public boolean Define_boolean_isDest(ASTNode caller, ASTNode child) {
        if (caller == this.getDestNoTransform()) {
            return true;
        }
        return super.Define_boolean_isDest(caller, child);
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

