/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.util.FactoryFinder;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.web.NoSuchViewStyleException;
import org.apache.activemq.web.view.MessageRenderer;

public class QueueBrowseServlet
extends HttpServlet {
    private static FactoryFinder factoryFinder = new FactoryFinder("META-INF/services/org/apache/activemq/web/view/");
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private LinkedList sessions = new LinkedList();

    public Connection getConnection() throws JMSException {
        if (this.connection == null) {
            this.connection = this.getConnectionFactory().createConnection();
            this.connection.start();
        }
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Session session = null;
        try {
            session = this.borrowSession();
            Queue queue = this.getQueue(request, session);
            if (queue == null) {
                throw new ServletException("No queue URI specified");
            }
            String selector = this.getSelector(request);
            QueueBrowser browser = session.createBrowser(queue, selector);
            MessageRenderer renderer = this.getMessageRenderer(request);
            this.configureRenderer(request, renderer);
            renderer.renderMessages(request, response, browser);
        }
        catch (JMSException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            this.returnSession(session);
        }
    }

    protected MessageRenderer getMessageRenderer(HttpServletRequest request) throws IOException, ServletException {
        String style = request.getParameter("view");
        if (style == null) {
            style = "simple";
        }
        try {
            return (MessageRenderer)factoryFinder.newInstance(style);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchViewStyleException(style, e);
        }
        catch (InstantiationException e) {
            throw new NoSuchViewStyleException(style, e);
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchViewStyleException(style, e);
        }
    }

    protected void configureRenderer(HttpServletRequest request, MessageRenderer renderer) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Enumeration iter = request.getParameterNames();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            properties.put(name, request.getParameter(name));
        }
        IntrospectionSupport.setProperties((Object)renderer, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session borrowSession() throws JMSException {
        Session answer = null;
        LinkedList linkedList = this.sessions;
        synchronized (linkedList) {
            answer = this.sessions.isEmpty() ? this.createSession() : (Session)this.sessions.removeLast();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnSession(Session session) {
        if (session != null) {
            LinkedList linkedList = this.sessions;
            synchronized (linkedList) {
                this.sessions.add(session);
            }
        }
    }

    protected Session createSession() throws JMSException {
        return this.getConnection().createSession(false, 1);
    }

    protected String getSelector(HttpServletRequest request) {
        return request.getParameter("selector");
    }

    protected Queue getQueue(HttpServletRequest request, Session session) throws JMSException {
        String uri = request.getPathInfo();
        if (uri == null) {
            return null;
        }
        if (uri.startsWith("/") && (uri = uri.substring(1)).length() == 0) {
            return null;
        }
        uri = uri.replace('/', '.');
        System.out.println("destination uri = " + uri);
        return session.createQueue(uri);
    }
}

