/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.server.layers.layer3.engine;

import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.layers.layer3.engine.IFileSystemInterface;
import org.neodatis.odb.core.server.layers.layer2.meta.ClientNonNativeObjectInfo;
import org.neodatis.odb.core.server.layers.layer3.engine.IServerStorageEngine;
import org.neodatis.odb.core.server.layers.layer3.engine.ServerFileSystemInterface;
import org.neodatis.odb.core.server.transaction.ISessionManager;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.core.trigger.ITriggerManager;
import org.neodatis.odb.impl.core.layers.layer3.engine.AbstractObjectWriter;
import org.neodatis.odb.impl.core.server.layers.layer3.oid.DefaultServerIdManager;
import org.neodatis.odb.impl.core.server.transaction.ServerSession;

public class ServerObjectWriter
extends AbstractObjectWriter {
    private ISessionManager sessionManager = OdbConfiguration.getCoreProvider().getClientServerSessionManager();

    public ServerObjectWriter(IStorageEngine engine) {
        super(engine);
    }

    IServerStorageEngine getEngine() {
        return (IServerStorageEngine)this.storageEngine;
    }

    public void initIdManager() {
        this.idManager = new DefaultServerIdManager(this, this.objectReader, this.storageEngine.getCurrentIdBlockPosition(), this.storageEngine.getCurrentIdBlockNumber(), this.storageEngine.getCurrentIdBlockMaxOid());
    }

    public OID writeNonNativeObjectInfo(OID existingOid, NonNativeObjectInfo objectInfo, long position, boolean writeDataInTransaction, boolean isNewObject) {
        ServerSession session;
        ObjectInfoHeader oih;
        if (OdbConfiguration.reconnectObjectsToSession() && objectInfo.getHeader().getOid() != null && (oih = (session = (ServerSession)this.sessionManager.getSession(this.storageEngine.getBaseIdentification().getIdentification(), true)).getCache().getObjectInfoHeaderFromOid(objectInfo.getOid(), false)) == null) {
            session.getCache().addObjectInfo(objectInfo.getHeader());
        }
        OID roid = super.writeNonNativeObjectInfo(existingOid, objectInfo, position, writeDataInTransaction, isNewObject);
        if (objectInfo instanceof ClientNonNativeObjectInfo) {
            ClientNonNativeObjectInfo cnnoi = (ClientNonNativeObjectInfo)objectInfo;
            ServerSession session2 = (ServerSession)this.getSession();
            session2.associateIds(roid, cnnoi.getLocalOid());
            session2.getCache().addObjectInfo(cnnoi.getHeader());
        }
        return roid;
    }

    public OID updateNonNativeObjectInfo(NonNativeObjectInfo nnoi, boolean forceUpdate) {
        ServerSession session;
        ObjectInfoHeader oih;
        if (OdbConfiguration.reconnectObjectsToSession() && nnoi.getHeader().getOid() != null && (oih = (session = (ServerSession)this.sessionManager.getSession(this.storageEngine.getBaseIdentification().getIdentification(), true)).getCache().getObjectInfoHeaderFromOid(nnoi.getOid(), false)) == null) {
            session.getCache().addObjectInfo(nnoi.getHeader());
        }
        OID roid = super.updateNonNativeObjectInfo(nnoi, forceUpdate);
        if (nnoi instanceof ClientNonNativeObjectInfo) {
            ClientNonNativeObjectInfo cnnoi = (ClientNonNativeObjectInfo)nnoi;
            ServerSession session2 = (ServerSession)this.getSession();
            session2.associateIds(cnnoi.getOid(), cnnoi.getLocalOid());
        }
        return roid;
    }

    public ISession getSession() {
        return (ServerSession)this.sessionManager.getSession(this.getEngine().getBaseIdentification().getIdentification(), true);
    }

    public IFileSystemInterface buildFSI() {
        return new ServerFileSystemInterface("server-data", this.storageEngine.getBaseIdentification(), true, OdbConfiguration.getDefaultBufferSizeForData());
    }

    protected ITriggerManager buildTriggerManager() {
        return OdbConfiguration.getCoreProvider().getServerTriggerManager(this.storageEngine);
    }
}

