/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.list.objects;

import java.util.Iterator;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.OrderByConstants;
import org.neodatis.odb.core.layers.layer2.instance.IInstanceBuilder;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.lookup.LookupFactory;
import org.neodatis.tool.wrappers.OdbComparable;
import org.neodatis.tool.wrappers.list.OdbArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazySimpleListOfAOI<T>
extends OdbArrayList<T>
implements Objects<T> {
    private int currentPosition;
    private transient IInstanceBuilder instanceBuilder;
    private String sessionId;
    private boolean returnInstance;

    public LazySimpleListOfAOI() {
        super(10);
    }

    public LazySimpleListOfAOI(int size, IInstanceBuilder builder, boolean returnInstance) {
        super(10);
        if (builder.isLocal()) {
            this.instanceBuilder = builder;
        }
        this.sessionId = builder.getSessionId();
        this.returnInstance = returnInstance;
    }

    @Override
    public boolean addWithKey(OdbComparable key, T object) {
        throw new ODBRuntimeException(NeoDatisError.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public boolean addWithKey(int key, T object) {
        throw new ODBRuntimeException(NeoDatisError.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public T getFirst() {
        try {
            return this.get(0);
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.ERROR_WHILE_GETTING_OBJECT_FROM_LIST_AT_INDEX.addParameter(0), (Throwable)e);
        }
    }

    @Override
    public T get(int index) {
        Object o = super.get(index);
        AbstractObjectInfo aoi = (AbstractObjectInfo)o;
        try {
            if (aoi.isNull()) {
                return null;
            }
            if (this.returnInstance) {
                if (aoi.isNative()) {
                    return (T)aoi.getObject();
                }
                if (this.instanceBuilder == null) {
                    this.instanceBuilder = (IInstanceBuilder)LookupFactory.get(this.sessionId).get("InstanceBuilder");
                    if (this.instanceBuilder == null) {
                        throw new ODBRuntimeException(NeoDatisError.LOOKUP_KEY_NOT_FOUND.addParameter("InstanceBuilder"));
                    }
                }
                return (T)this.instanceBuilder.buildOneInstance((NonNativeObjectInfo)aoi);
            }
            o = aoi;
            return (T)o;
        }
        catch (Throwable e) {
            throw new ODBRuntimeException(NeoDatisError.ERROR_WHILE_GETTING_OBJECT_FROM_LIST_AT_INDEX.addParameter(index), e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentPosition < this.size();
    }

    @Override
    public Iterator<T> iterator(OrderByConstants orderByType) {
        throw new ODBRuntimeException(NeoDatisError.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public T next() {
        try {
            return this.get(this.currentPosition++);
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.ERROR_WHILE_GETTING_OBJECT_FROM_LIST_AT_INDEX.addParameter(0), (Throwable)e);
        }
    }

    @Override
    public void reset() {
        this.currentPosition = 0;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("list with ").append(this.size()).append(" elements");
        return buffer.toString();
    }
}

