/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.list.objects;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.neodatis.btree.IBTree;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.Objects;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.OrderByConstants;
import org.neodatis.tool.wrappers.OdbComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBTreeCollection<E>
implements Objects<E>,
Serializable {
    private IBTree tree = this.buildTree(OdbConfiguration.getDefaultIndexBTreeDegree());
    private int size;
    private transient Iterator<E> currentIterator;
    private OrderByConstants orderByType;

    public AbstractBTreeCollection(int size, OrderByConstants orderByType) {
        this.orderByType = orderByType;
    }

    public AbstractBTreeCollection() {
        this(50, OrderByConstants.ORDER_BY_NONE);
    }

    public abstract IBTree buildTree(int var1);

    @Override
    public E getFirst() {
        return this.iterator(this.orderByType).next();
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == null) {
            this.currentIterator = this.iterator(this.orderByType);
        }
        return this.currentIterator.hasNext();
    }

    @Override
    public E next() {
        if (this.currentIterator == null) {
            this.currentIterator = this.iterator(this.orderByType);
        }
        return this.currentIterator.next();
    }

    @Override
    public boolean add(E o) {
        this.tree.insert(new Integer(this.size), o);
        ++this.size;
        return true;
    }

    @Override
    public boolean addWithKey(OdbComparable key, E o) {
        this.tree.insert(key, o);
        ++this.size;
        return true;
    }

    @Override
    public boolean addWithKey(int key, E o) {
        this.tree.insert(new Integer(key), o);
        ++this.size;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    @Override
    public void clear() {
        this.tree.clear();
    }

    @Override
    public boolean contains(Object o) {
        throw new ODBRuntimeException(NeoDatisError.OPERATION_NOT_IMPLEMENTED.addParameter("contains"));
    }

    @Override
    public boolean containsAll(Collection collection) {
        throw new ODBRuntimeException(NeoDatisError.OPERATION_NOT_IMPLEMENTED.addParameter("containsAll"));
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return this.iterator(this.orderByType);
    }

    @Override
    public Iterator<E> iterator(OrderByConstants newOrderByType) {
        return this.tree.iterator(newOrderByType);
    }

    @Override
    public boolean remove(Object o) {
        throw new ODBRuntimeException(NeoDatisError.OPERATION_NOT_IMPLEMENTED.addParameter("remove"));
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new ODBRuntimeException(NeoDatisError.OPERATION_NOT_IMPLEMENTED.addParameter("removeAll"));
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new ODBRuntimeException(NeoDatisError.OPERATION_NOT_IMPLEMENTED.addParameter("retainAll"));
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size]);
    }

    @Override
    public Object[] toArray(Object[] objects) {
        Iterator<E> iterator = this.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            objects[i++] = iterator.next();
        }
        return objects;
    }

    @Override
    public void reset() {
        this.currentIterator = this.iterator(this.orderByType);
    }

    protected OrderByConstants getOrderByType() {
        return this.orderByType;
    }

    protected IBTree getTree() {
        return this.tree;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("size=").append(this.size).append(" [");
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            s.append(iterator.next());
            if (!iterator.hasNext()) continue;
            s.append(" , ");
        }
        s.append("]");
        return s.toString();
    }
}

