/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.btree;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neodatis.btree.BTreeError;
import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.IBTreePersister;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.IError;
import org.neodatis.odb.core.layers.layer3.ICommitListener;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.impl.core.layers.layer3.engine.Dummy;
import org.neodatis.odb.impl.core.layers.layer3.engine.StorageEngineConstant;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class LazyODBBTreePersister
implements IBTreePersister,
ICommitListener {
    public static final String LOG_ID = "LazyODBBTreePersister";
    private Map<OID, Object> oids = new HashMap<OID, Object>();
    private OdbHashMap<Object, Integer> modifiedObjectOids = new OdbHashMap();
    private IOdbList<OID> modifiedObjectOidList = new OdbArrayList<OID>(500);
    private IStorageEngine engine;
    private IBTree tree;
    private static Map<OID, Object> smap = null;
    private static Map<Object, Integer> smodifiedObjects = null;
    public static int nbSaveNodes = 0;
    public static int nbSaveNodesInCache = 0;
    public static int nbSaveTree = 0;
    public static int nbLoadNodes = 0;
    public static int nbLoadTree = 0;
    public static int nbLoadNodesFromCache = 0;
    private int nbPersist;

    public LazyODBBTreePersister(ODB odb) {
        this(Dummy.getEngine(odb));
    }

    public LazyODBBTreePersister(IStorageEngine engine) {
        this.engine = engine;
        this.engine.addCommitListener(this);
        smap = this.oids;
        smodifiedObjects = this.modifiedObjectOids;
    }

    public IBTreeNode loadNodeById(Object id) {
        OID oid = (OID)id;
        IBTreeNode node = (IBTreeNode)this.oids.get(oid);
        if (node != null) {
            ++nbLoadNodesFromCache;
            return node;
        }
        ++nbLoadNodes;
        try {
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Loading node with id " + oid);
            }
            if (oid == null) {
                throw new ODBRuntimeException(BTreeError.INVALID_ID_FOR_BTREE.addParameter(oid));
            }
            IBTreeNode pn = (IBTreeNode)this.engine.getObjectFromOid(oid);
            pn.setId(oid);
            if (this.tree != null) {
                pn.setBTree(this.tree);
            }
            this.oids.put(oid, pn);
            return pn;
        }
        catch (Exception e) {
            throw new ODBRuntimeException((IError)BTreeError.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public Object saveNode(IBTreeNode node) {
        OID oid = null;
        if (node.getId() == StorageEngineConstant.NULL_OBJECT_ID) {
            try {
                ++nbSaveNodes;
                oid = this.engine.getObjectWriter().getIdManager().getNextObjectId(-2L);
                node.setId(oid);
                oid = this.engine.store(oid, node);
                if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                    DLogger.debug("Saved node id " + oid);
                }
                if (this.tree != null && node.getBTree() == null) {
                    node.setBTree(this.tree);
                }
                this.oids.put(oid, node);
                return oid;
            }
            catch (Exception e) {
                throw new ODBRuntimeException(BTreeError.INTERNAL_ERROR.addParameter("While saving node"), (Throwable)e);
            }
        }
        ++nbSaveNodesInCache;
        oid = (OID)node.getId();
        this.oids.put(oid, node);
        this.addModifiedOid(oid);
        return oid;
    }

    public void close() throws Exception {
        this.persist();
        this.engine.commit();
        this.engine.close();
    }

    public IBTree loadBTree(Object id) {
        ++nbLoadTree;
        OID oid = (OID)id;
        try {
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Loading btree with id " + oid);
            }
            if (oid == StorageEngineConstant.NULL_OBJECT_ID) {
                throw new ODBRuntimeException(BTreeError.INVALID_ID_FOR_BTREE.addParameter(StorageEngineConstant.NULL_OBJECT_ID));
            }
            this.tree = (IBTree)this.engine.getObjectFromOid(oid);
            this.tree.setId(oid);
            this.tree.setPersister(this);
            IBTreeNode root = this.tree.getRoot();
            root.setBTree(this.tree);
            return this.tree;
        }
        catch (Exception e) {
            throw new ODBRuntimeException((IError)BTreeError.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public OID saveBTree(IBTree treeToSave) {
        ++nbSaveTree;
        try {
            OID oid = (OID)treeToSave.getId();
            if (oid == null) {
                oid = this.engine.getObjectWriter().getIdManager().getNextObjectId(-2L);
                treeToSave.setId(oid);
                oid = this.engine.store(oid, treeToSave);
                if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                    DLogger.debug("Saved btree " + treeToSave.getId() + " with id " + oid + " and  root " + treeToSave.getRoot());
                }
                if (this.tree == null) {
                    this.tree = treeToSave;
                }
                this.oids.put(oid, treeToSave);
            } else {
                this.oids.put(oid, treeToSave);
                this.addModifiedOid(oid);
            }
            return oid;
        }
        catch (Exception e) {
            throw new ODBRuntimeException((IError)BTreeError.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public OID getNextNodeId() throws IOException {
        return this.engine.getObjectWriter().getIdManager().getNextObjectId(-1L);
    }

    public void persist() {
        ++this.nbPersist;
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("persist " + this.nbPersist + " : Saving " + this.modifiedObjectOids.size() + " objects - " + this.hashCode());
        }
        OID oid2 = null;
        int nbCommited = 0;
        long t0 = 0L;
        long t1 = 0L;
        int i = 0;
        int size = this.modifiedObjectOids.size();
        for (OID oid2 : this.modifiedObjectOidList) {
            if (oid2 == null) continue;
            ++nbCommited;
            try {
                t0 = OdbTime.getCurrentTimeInMs();
                Object o = this.oids.get(oid2);
                this.engine.store(o);
                t1 = OdbTime.getCurrentTimeInMs();
            }
            catch (Exception e) {
                throw new ODBRuntimeException(BTreeError.INTERNAL_ERROR.addParameter("Error while storing object with oid " + oid2), (Throwable)e);
            }
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Committing oid " + oid2 + " | " + i + "/" + size + " | " + (t1 - t0));
            }
            ++i;
        }
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(nbCommited + " commits / " + size);
        }
    }

    public void afterCommit() {
    }

    public void beforeCommit() {
        this.persist();
        this.clear();
    }

    public Object deleteNode(IBTreeNode o) {
        OID oid = this.engine.delete(o);
        this.oids.remove(oid);
        Integer position = this.modifiedObjectOids.remove2(oid);
        if (position != null) {
            this.modifiedObjectOidList.set(position, null);
        }
        return o;
    }

    public void setBTree(IBTree tree) {
        this.tree = tree;
    }

    public static void resetCounters() {
        nbSaveNodes = 0;
        nbSaveTree = 0;
        nbSaveNodesInCache = 0;
        nbLoadNodes = 0;
        nbLoadTree = 0;
        nbLoadNodesFromCache = 0;
    }

    public static StringBuffer counters() {
        StringBuffer buffer = new StringBuffer("save nodes=").append(nbSaveNodes).append(",").append(nbLoadNodesFromCache).append(" | save tree=").append(nbSaveTree).append(" | loadNodes=").append(nbLoadNodes).append(",").append(nbLoadNodesFromCache).append(" | load tree=").append(nbLoadTree);
        if (smap != null && smodifiedObjects != null) {
            buffer.append(" | map size=").append(smap.size()).append(" | modObjects size=").append(smodifiedObjects.size());
        }
        return buffer;
    }

    public void clear() {
        this.oids.clear();
        this.modifiedObjectOids.clear();
        this.modifiedObjectOidList.clear();
    }

    public void clearModified() {
        this.modifiedObjectOids.clear();
        this.modifiedObjectOidList.clear();
    }

    public void flush() {
        this.persist();
        this.clearModified();
    }

    protected void addModifiedOid(OID oid) {
        Object o = this.modifiedObjectOids.get(oid);
        if (o != null) {
            return;
        }
        this.modifiedObjectOidList.add(oid);
        this.modifiedObjectOids.put(oid, new Integer(this.modifiedObjectOidList.size() - 1));
    }
}

