/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.query;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.query.criteria.And;
import org.neodatis.odb.core.query.criteria.ICriterion;
import org.neodatis.odb.core.query.criteria.Operator;
import org.neodatis.odb.core.query.criteria.Where;
import org.neodatis.odb.gui.IBrowserContainer;
import org.neodatis.odb.gui.Messages;
import org.neodatis.odb.gui.component.GUITool;
import org.neodatis.odb.gui.objectbrowser.flat.FlatQueryResultPanel;
import org.neodatis.odb.gui.objectbrowser.hierarchy.HierarchicObjectBrowserPanel;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.impl.tool.ObjectTool;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.ILogger;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class CriteriaQueryPanel
extends JPanel
implements ActionListener {
    private IStorageEngine storageEngine;
    private ClassInfo classInfo;
    private JButton btExecute;
    private Map<String, JTextField> textFields;
    private Map operatorCombos;
    private IBrowserContainer browser;
    private JComboBox cbBrowserType;
    private JTextField tfFrom;
    private JTextField tfTo;
    private ILogger logger;

    public CriteriaQueryPanel(IStorageEngine aStorageEngine, ClassInfo ci, IBrowserContainer aBrowser, ILogger logger) {
        this.storageEngine = aStorageEngine;
        this.classInfo = ci;
        this.textFields = new OdbHashMap<String, JTextField>();
        this.operatorCombos = new OdbHashMap();
        this.browser = aBrowser;
        this.logger = logger;
        this.init();
    }

    private void init() {
        JTextField textField = null;
        JComboBox operatorCombo = null;
        JButton btHelp = null;
        ClassAttributeInfo cai = null;
        int nbAttributes = this.classInfo.getAttributes().size();
        JPanel fieldsPanel = new JPanel(new GridLayout(nbAttributes + 2, 4, 4, 4));
        this.setLayout(new BorderLayout(4, 4));
        Color headerFontColor = Color.LIGHT_GRAY;
        Color headerCellColor = new Color(0, 100, 15);
        JLabel label1 = new JLabel("Attribute Name");
        label1.setBackground(headerCellColor);
        fieldsPanel.add(label1);
        JLabel label2 = new JLabel("Operator");
        label2.setBackground(headerCellColor);
        fieldsPanel.add(label2);
        JLabel label3 = new JLabel("Value");
        label3.setBackground(headerCellColor);
        fieldsPanel.add(label3);
        JLabel label4 = new JLabel("ToolTip with Type");
        label4.setBackground(headerCellColor);
        fieldsPanel.add(label4);
        for (int i = 0; i < nbAttributes; ++i) {
            cai = this.classInfo.getAttributeInfo(i);
            textField = new JTextField(8);
            operatorCombo = this.buildOperatorCombo();
            fieldsPanel.add(new JLabel(cai.getName(), 2));
            fieldsPanel.add(operatorCombo);
            fieldsPanel.add(textField);
            this.textFields.put(cai.getName(), textField);
            btHelp = new JButton("?");
            btHelp.setToolTipText("Type is " + cai.getFullClassname());
            fieldsPanel.add(btHelp);
            this.operatorCombos.put(cai.getName(), operatorCombo);
        }
        textField = new JTextField(8);
        operatorCombo = this.buildOperatorCombo();
        fieldsPanel.add(textField);
        fieldsPanel.add(operatorCombo);
        this.textFields.put("other.field.name", textField);
        this.operatorCombos.put("other.field.name", operatorCombo);
        textField = new JTextField(8);
        fieldsPanel.add(textField);
        this.textFields.put("other.field.value", textField);
        fieldsPanel.add(new JLabel(""));
        JPanel optionPanel = new JPanel();
        String[] types = new String[]{"Object View", "Table View"};
        this.cbBrowserType = new JComboBox<String>(types);
        this.tfFrom = new JTextField("-1", 5);
        this.tfTo = new JTextField("-1", 5);
        optionPanel.add(this.cbBrowserType);
        optionPanel.add(this.tfFrom);
        optionPanel.add(this.tfTo);
        JPanel panel2 = new JPanel(new FlowLayout());
        panel2.add(fieldsPanel);
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.add((Component)new JScrollPane(panel2), "Center");
        panel.add((Component)optionPanel, "South");
        this.add((Component)panel, "Center");
        JPanel buttonPanel = new JPanel();
        this.btExecute = new JButton(Messages.getString("execute"));
        this.btExecute.setActionCommand("execute");
        this.btExecute.addActionListener(this);
        buttonPanel.add(this.btExecute);
        this.add((Component)buttonPanel, "South");
        this.add((Component)GUITool.buildHeaderPanel("Criteria Query Wizard"), "North");
    }

    private JComboBox buildOperatorCombo() {
        Operator[] operators = new Operator[]{Operator.EQUAL, Operator.LIKE, Operator.GREATER_THAN, Operator.GREATER_OR_EQUAL, Operator.LESS_THAN, Operator.LESS_OR_EQUAL, Operator.CONTAIN};
        return new JComboBox<Operator>(operators);
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if ("execute".equals(action)) {
            this.executeQuery();
        }
    }

    private void executeQuery() {
        JComboBox comboBox;
        JTextField tfValue;
        Iterator<String> iterator = this.textFields.keySet().iterator();
        And and = Where.and();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (key.equals("other.field.value") || key.equals("other.field.name")) continue;
            tfValue = this.textFields.get(key);
            comboBox = (JComboBox)this.operatorCombos.get(key);
            String value = tfValue.getText();
            Operator operator = (Operator)comboBox.getSelectedItem();
            if (value.length() == 0) continue;
            ClassAttributeInfo cai = this.classInfo.getAttributeInfoFromName(key.toString());
            try {
                Object oo = ObjectTool.stringToObject(cai.getAttributeType().getId(), value, ObjectTool.ID_CALLER_IS_ODB_EXPLORER);
                and.add(Where.get(key.toString(), operator, oo));
            }
            catch (Exception e) {
                this.logger.error("Error while executing query", e);
                JOptionPane.showMessageDialog(this, "Error while executing query : " + e.getMessage());
            }
        }
        JTextField tfName = this.textFields.get("other.field.name");
        tfValue = this.textFields.get("other.field.value");
        comboBox = (JComboBox)this.operatorCombos.get("other.field.name");
        Operator operator = (Operator)comboBox.getSelectedItem();
        if (tfName.getText().length() != 0 && tfValue.getText().length() != 0) {
            and.add(Where.get(tfName.getText(), operator, tfValue.getText()));
        }
        CriteriaQuery criteriaQuery = null;
        ICriterion criteria = and;
        if (and.getNbCriteria() == 1) {
            criteria = and.getCriterion(0);
        }
        criteriaQuery = !and.isEmpty() ? new CriteriaQuery(this.classInfo.getFullClassName(), criteria) : new CriteriaQuery(this.classInfo.getFullClassName());
        String browserType = this.cbBrowserType.getSelectedItem().toString();
        int from = Integer.valueOf(this.tfFrom.getText());
        int to = Integer.valueOf(this.tfTo.getText());
        DLogger.info("Executing Restrictions Query on " + this.classInfo.getFullClassName() + " : " + criteriaQuery.toString());
        Objects l = null;
        try {
            l = this.storageEngine.getObjectInfos(criteriaQuery, true, from, to, false);
            String title = this.classInfo.getFullClassName() + " - query : " + criteriaQuery.toString();
            JPanel panel = null;
            if (browserType.equals("Table View")) {
                panel = new FlatQueryResultPanel(this.storageEngine, this.classInfo.getFullClassName(), l);
            } else {
                ArrayList list = new ArrayList(l.size());
                list.addAll(l);
                panel = new HierarchicObjectBrowserPanel(this.browser, this.storageEngine, this.classInfo, list, true, this.logger);
            }
            this.browser.browse(title, panel, l.size());
        }
        catch (Exception e) {
            this.logger.error("Error while executing query", e);
        }
    }
}

