/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server.connection;

import java.util.Iterator;
import java.util.Map;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.server.connection.ConnectionIdGenerator;
import org.neodatis.odb.core.server.connection.IConnection;
import org.neodatis.odb.impl.core.server.connection.DefaultServerConnection;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbThread;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class ConnectionManager {
    public static final String LOG_ID = "IConnectionManager";
    private IStorageEngine storageEngine;
    private Map<String, IConnection> connections;
    private Map<OID, IConnection> lockedOids;
    private Map<String, IConnection> lockedClasses;

    public ConnectionManager(IStorageEngine engine) {
        this.storageEngine = engine;
        this.connections = new OdbHashMap<String, IConnection>();
        this.lockedOids = new OdbHashMap<OID, IConnection>();
        this.lockedClasses = new OdbHashMap<String, IConnection>();
    }

    public IConnection newConnection(String ip, long dateTime, int sequence) {
        String connectionId = ConnectionIdGenerator.newId(ip, dateTime, sequence);
        DefaultServerConnection connection = new DefaultServerConnection(this, connectionId, this.storageEngine);
        this.connections.put(connectionId, connection);
        return connection;
    }

    public IConnection getConnection(String connectionId) {
        IConnection c = this.connections.get(connectionId);
        if (c == null) {
            throw new ODBRuntimeException(NeoDatisError.CLIENT_SERVER_CONNECTION_IS_NULL.addParameter(connectionId).addParameter(this.connections));
        }
        return c;
    }

    public void removeConnection(IConnection connection) {
        this.connections.remove(connection.getId());
    }

    public IStorageEngine getStorageEngine() {
        return this.storageEngine;
    }

    public int getNbConnections() {
        return this.connections.size();
    }

    public String getConnectionDescriptions() {
        Iterator<IConnection> iterator = this.connections.values().iterator();
        IConnection connection = null;
        StringBuffer buffer = new StringBuffer();
        while (iterator.hasNext()) {
            connection = iterator.next();
            buffer.append("\n\t+ ").append(connection.getDescription()).append("\n");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void lockOidForConnection(OID oid, IConnection connection) throws InterruptedException {
        long start = OdbTime.getCurrentTimeInMs();
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            start = OdbTime.getCurrentTimeInMs();
            DLogger.debug("Trying to lock object with oid " + oid + " - id=" + connection.getId());
        }
        try {
            IConnection c = this.lockedOids.get(oid);
            if (c == null) {
                this.lockedOids.put(oid, connection);
                return;
            }
            if (c != null && c.equals(connection)) {
                return;
            }
            while (c != null) {
                OdbThread.sleep(10L);
                c = this.lockedOids.get(oid);
            }
            this.lockedOids.put(oid, connection);
        }
        finally {
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Object with oid " + oid + " locked (" + (OdbTime.getCurrentTimeInMs() - start) + "ms) - " + connection.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void lockClassForConnection(String fullClassName, IConnection connection) throws InterruptedException {
        IConnection c;
        long start;
        block11: {
            block10: {
                start = OdbTime.getCurrentTimeInMs();
                if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                    start = OdbTime.getCurrentTimeInMs();
                    DLogger.debug(String.format("CM:Trying to lock class %s - id=%s", fullClassName, connection.getId()));
                }
                c = this.lockedClasses.get(fullClassName);
                if (c != null) break block10;
                this.lockedClasses.put(fullClassName, connection);
                if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                    DLogger.debug(String.format("Class %s locked (%dms) - %s", fullClassName, OdbTime.getCurrentTimeInMs() - start, connection.getId()));
                }
                return;
            }
            if (c == null || !c.equals(connection)) break block11;
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug(String.format("Class %s locked (%dms) - %s", fullClassName, OdbTime.getCurrentTimeInMs() - start, connection.getId()));
            }
            return;
        }
        try {
            while (c != null) {
                OdbThread.sleep(10L);
                c = this.lockedClasses.get(fullClassName);
            }
            this.lockedClasses.put(fullClassName, connection);
        }
        catch (Throwable throwable) {
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug(String.format("Class %s locked (%dms) - %s", fullClassName, OdbTime.getCurrentTimeInMs() - start, connection.getId()));
            }
            throw throwable;
        }
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(String.format("Class %s locked (%dms) - %s", fullClassName, OdbTime.getCurrentTimeInMs() - start, connection.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockOidForConnection(OID oid, IConnection connection) throws InterruptedException {
        long start = OdbTime.getCurrentTimeInMs();
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            start = OdbTime.getCurrentTimeInMs();
            DLogger.debug("Trying to unlock lock object with oid " + oid + " - id=" + connection.getId());
        }
        try {
            this.lockedOids.remove(oid);
        }
        finally {
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Object with oid " + oid + " unlocked (" + (OdbTime.getCurrentTimeInMs() - start) + "ms) - " + connection.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockClass(String fullClassName, IConnection connection) throws InterruptedException {
        long start = OdbTime.getCurrentTimeInMs();
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            start = OdbTime.getCurrentTimeInMs();
            DLogger.debug("Trying to unlock class " + fullClassName + " - id=" + connection.getId());
        }
        try {
            this.lockedClasses.remove(fullClassName);
        }
        finally {
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Class  " + fullClassName + " unlocked (" + (OdbTime.getCurrentTimeInMs() - start) + "ms) - " + connection.getId());
            }
        }
    }
}

