/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server.connection;

import java.util.List;
import java.util.Map;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.TransactionId;
import org.neodatis.odb.Values;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoList;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.layers.layer3.engine.CheckMetaModelResult;
import org.neodatis.odb.core.query.QueryManager;
import org.neodatis.odb.core.server.connection.ConnectionManager;
import org.neodatis.odb.core.server.connection.IConnection;
import org.neodatis.odb.core.server.layers.layer3.IODBServerExt;
import org.neodatis.odb.core.server.layers.layer3.engine.Message;
import org.neodatis.odb.core.server.message.AddIndexMessage;
import org.neodatis.odb.core.server.message.AddIndexMessageResponse;
import org.neodatis.odb.core.server.message.CheckMetaModelCompatibilityMessage;
import org.neodatis.odb.core.server.message.CheckMetaModelCompatibilityMessageResponse;
import org.neodatis.odb.core.server.message.CloseMessage;
import org.neodatis.odb.core.server.message.CloseMessageResponse;
import org.neodatis.odb.core.server.message.CommitMessage;
import org.neodatis.odb.core.server.message.CommitMessageResponse;
import org.neodatis.odb.core.server.message.ConnectMessage;
import org.neodatis.odb.core.server.message.ConnectMessageResponse;
import org.neodatis.odb.core.server.message.CountMessage;
import org.neodatis.odb.core.server.message.CountMessageResponse;
import org.neodatis.odb.core.server.message.DeleteBaseMessage;
import org.neodatis.odb.core.server.message.DeleteBaseMessageResponse;
import org.neodatis.odb.core.server.message.DeleteIndexMessage;
import org.neodatis.odb.core.server.message.DeleteIndexMessageResponse;
import org.neodatis.odb.core.server.message.DeleteObjectMessage;
import org.neodatis.odb.core.server.message.DeleteObjectMessageResponse;
import org.neodatis.odb.core.server.message.ErrorMessage;
import org.neodatis.odb.core.server.message.GetMessage;
import org.neodatis.odb.core.server.message.GetMessageResponse;
import org.neodatis.odb.core.server.message.GetObjectFromIdMessage;
import org.neodatis.odb.core.server.message.GetObjectFromIdMessageResponse;
import org.neodatis.odb.core.server.message.GetObjectHeaderFromIdMessage;
import org.neodatis.odb.core.server.message.GetObjectHeaderFromIdMessageResponse;
import org.neodatis.odb.core.server.message.GetObjectValuesMessage;
import org.neodatis.odb.core.server.message.GetObjectValuesMessageResponse;
import org.neodatis.odb.core.server.message.GetSessionsMessage;
import org.neodatis.odb.core.server.message.GetSessionsMessageResponse;
import org.neodatis.odb.core.server.message.NewClassInfoListMessage;
import org.neodatis.odb.core.server.message.NewClassInfoListMessageResponse;
import org.neodatis.odb.core.server.message.RebuildIndexMessage;
import org.neodatis.odb.core.server.message.RebuildIndexMessageResponse;
import org.neodatis.odb.core.server.message.RollbackMessage;
import org.neodatis.odb.core.server.message.RollbackMessageResponse;
import org.neodatis.odb.core.server.message.StoreMessage;
import org.neodatis.odb.core.server.message.StoreMessageResponse;
import org.neodatis.odb.core.server.transaction.ISessionManager;
import org.neodatis.odb.impl.core.layers.layer3.engine.StorageEngineConstant;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.impl.core.server.transaction.ServerSession;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.IOUtil;
import org.neodatis.tool.mutex.Mutex;
import org.neodatis.tool.mutex.MutexFactory;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.io.OdbFile;
import org.neodatis.tool.wrappers.list.OdbArrayList;

public abstract class ClientServerConnection {
    private static final String LOG_ID = "ClientServerConnection";
    private static int nbMessages = 0;
    protected boolean connectionIsUp;
    protected String baseIdentifier;
    protected String connectionId;
    protected boolean debug = OdbConfiguration.logServerConnections();
    protected boolean automaticallyCreateDatabase;
    protected IODBServerExt server;
    protected ISessionManager sessionManager;
    private static final String COMMIT_CLOSE_CONNECT_MUTEX_NAME = "commit-close-connect";
    private static final String COUNT_MUTEX_NAME = "commit-close-connect";
    private static final String GET_OBJECT_HEADER_FROM_ID_MUTEX_NAME = "commit-close-connect";
    private static final String GET_OBJECT_FROM_ID_MUTEX_NAME = "commit-close-connect";
    private static final String GET_VALUES_MUTEX_NAME = "commit-close-connect";
    private static final String GET_OBJECTS_MUTEX_NAME = "commit-close-connect";
    private static final String DELETE_OBJECT_MUTEX_NAME = "commit-close-connect";
    private static final String ADD_CLASS_INFO_LIST_MUTEX_NAME = "commit-close-connect";
    private static final String STORE_MUTEX_NAME = "commit-close-connect";

    public ClientServerConnection(IODBServerExt server, boolean automaticallyCreateDatabase) {
        this.automaticallyCreateDatabase = automaticallyCreateDatabase;
        this.server = server;
        this.sessionManager = OdbConfiguration.getCoreProvider().getClientServerSessionManager();
    }

    public abstract String getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message manageMessage(Message message) {
        long start = OdbTime.getCurrentTimeInMs();
        try {
            ++nbMessages;
            int commandId = message.getCommandId();
            switch (commandId) {
                case 1: {
                    Message message2 = this.manageConnectCommand((ConnectMessage)message);
                    return message2;
                }
                case 2: {
                    Message message3 = this.manageGetObjectsCommand((GetMessage)message);
                    return message3;
                }
                case 3: {
                    Message message4 = this.manageGetObjectFromIdCommand((GetObjectFromIdMessage)message);
                    return message4;
                }
                case 15: {
                    Message message5 = this.manageGetObjectHeaderFromIdCommand((GetObjectHeaderFromIdMessage)message);
                    return message5;
                }
                case 4: {
                    Message message6 = this.manageStoreCommand((StoreMessage)message);
                    return message6;
                }
                case 5: {
                    Message message7 = this.manageDeleteObjectCommand((DeleteObjectMessage)message);
                    return message7;
                }
                case 6: {
                    Message message8 = this.manageCloseCommand((CloseMessage)message);
                    return message8;
                }
                case 7: {
                    Message message9 = this.manageCommitCommand((CommitMessage)message);
                    return message9;
                }
                case 8: {
                    Message message10 = this.manageRollbackCommand((RollbackMessage)message);
                    return message10;
                }
                case 9: {
                    Message message11 = this.manageDeleteBaseCommand((DeleteBaseMessage)message);
                    return message11;
                }
                case 10: {
                    Message message12 = this.manageGetSessionsCommand((GetSessionsMessage)message);
                    return message12;
                }
                case 11: {
                    Message message13 = this.manageAddIndexCommand((AddIndexMessage)message);
                    return message13;
                }
                case 16: {
                    Message message14 = this.manageRebuildIndexCommand((RebuildIndexMessage)message);
                    return message14;
                }
                case 17: {
                    Message message15 = this.manageDeleteIndexCommand((DeleteIndexMessage)message);
                    return message15;
                }
                case 12: {
                    Message message16 = this.manageAddClassInfoListCommand((NewClassInfoListMessage)message);
                    return message16;
                }
                case 13: {
                    Message message17 = this.manageCountCommand((CountMessage)message);
                    return message17;
                }
                case 14: {
                    Message message18 = this.manageGetObjectValuesCommand((GetObjectValuesMessage)message);
                    return message18;
                }
                case 18: {
                    CheckMetaModelCompatibilityMessageResponse checkMetaModelCompatibilityMessageResponse = this.manageCheckMetaModelCompatibilityCommand((CheckMetaModelCompatibilityMessage)message);
                    return checkMetaModelCompatibilityMessageResponse;
                }
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("ODBServer.ConnectionThread:command ").append(commandId).append(" not implemented");
            ErrorMessage errorMessage = new ErrorMessage("?", "?", buffer.toString());
            return errorMessage;
        }
        finally {
            long end = OdbTime.getCurrentTimeInMs();
            if (this.debug) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("[").append(nbMessages).append("] ");
                buffer.append(message.toString()).append(" - Thread=").append(this.getName()).append(" - connectionId =").append(this.connectionId).append(" - duration=").append(end - start);
                DLogger.info(buffer);
            }
        }
    }

    public ServerSession getSession(String baseIdentifier) {
        return (ServerSession)this.sessionManager.getSession(baseIdentifier, true);
    }

    private CheckMetaModelCompatibilityMessageResponse manageCheckMetaModelCompatibilityCommand(CheckMetaModelCompatibilityMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        try {
            connectionManager = this.getConnectionManager(baseIdentifier);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                return new CheckMetaModelCompatibilityMessageResponse(baseIdentifier, message.getConnectionId(), buffer.toString());
            }
            connection = connectionManager.getConnection(message.getConnectionId());
            ServerSession session = this.getSession(baseIdentifier);
            IStorageEngine engine = connection.getStorageEngine();
            Map<String, ClassInfo> currentCIs = message.getCurrentCIs();
            CheckMetaModelResult result = engine.checkMetaModelCompatibility(currentCIs);
            MetaModel updatedMetaModel = null;
            if (result.isModelHasBeenUpdated()) {
                updatedMetaModel = session.getMetaModel().duplicate();
                this.clearMessageStreamerCache();
            }
            return new CheckMetaModelCompatibilityMessageResponse(baseIdentifier, message.getConnectionId(), result, updatedMetaModel);
        }
        catch (Exception e) {
            DLogger.error(baseIdentifier + ":Server error while closing", e);
            return new CheckMetaModelCompatibilityMessageResponse(baseIdentifier, message.getConnectionId(), OdbString.exceptionToString(e, false));
        }
    }

    private Message manageAddIndexCommand(AddIndexMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        try {
            connectionManager = this.getConnectionManager(baseIdentifier);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                return new AddIndexMessageResponse(baseIdentifier, message.getConnectionId(), buffer.toString());
            }
            connection = connectionManager.getConnection(message.getConnectionId());
            IStorageEngine engine = connection.getStorageEngine();
            engine.addIndexOn(message.getClassName(), message.getIndexName(), message.getIndexFieldNames(), message.isVerbose(), message.acceptMultipleValuesForSameKey());
        }
        catch (Exception e) {
            DLogger.error(baseIdentifier + ":Server error while closing", e);
            return new AddIndexMessageResponse(baseIdentifier, message.getConnectionId(), OdbString.exceptionToString(e, false));
        }
        return new AddIndexMessageResponse(baseIdentifier, message.getConnectionId());
    }

    private Message manageRebuildIndexCommand(RebuildIndexMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        try {
            connectionManager = this.getConnectionManager(baseIdentifier);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                return new RebuildIndexMessageResponse(baseIdentifier, message.getConnectionId(), buffer.toString());
            }
            connection = connectionManager.getConnection(message.getConnectionId());
            IStorageEngine engine = connection.getStorageEngine();
            engine.rebuildIndex(message.getClassName(), message.getIndexName(), message.isVerbose());
        }
        catch (Exception e) {
            DLogger.error(baseIdentifier + ":Server error while closing", e);
            return new RebuildIndexMessageResponse(baseIdentifier, message.getConnectionId(), OdbString.exceptionToString(e, false));
        }
        return new RebuildIndexMessageResponse(baseIdentifier, message.getConnectionId());
    }

    private Message manageDeleteIndexCommand(DeleteIndexMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        try {
            connectionManager = this.getConnectionManager(baseIdentifier);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                return new DeleteIndexMessageResponse(baseIdentifier, message.getConnectionId(), buffer.toString());
            }
            connection = connectionManager.getConnection(message.getConnectionId());
            IStorageEngine engine = connection.getStorageEngine();
            engine.deleteIndex(message.getClassName(), message.getIndexName(), message.isVerbose());
        }
        catch (Exception e) {
            DLogger.error(baseIdentifier + ":Server error while closing", e);
            return new DeleteIndexMessageResponse(baseIdentifier, message.getConnectionId(), OdbString.exceptionToString(e, false));
        }
        return new DeleteIndexMessageResponse(baseIdentifier, message.getConnectionId());
    }

    private ConnectionManager getConnectionManager(String baseIdentifier) throws Exception {
        return this.getConnectionManager(baseIdentifier, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionManager getConnectionManager(String baseIdentifier, String user, String password, boolean returnNullIfDoesNotExit) throws Exception {
        ConnectionManager connectionManager;
        block6: {
            block5: {
                connectionManager = (ConnectionManager)this.server.getConnectionManagers().get(baseIdentifier);
                if (connectionManager != null || !returnNullIfDoesNotExit) break block5;
                ConnectionManager connectionManager2 = null;
                return connectionManager2;
            }
            if (connectionManager == null && this.automaticallyCreateDatabase) {
                this.server.addBase(baseIdentifier, baseIdentifier, user, password);
                connectionManager = (ConnectionManager)this.server.getConnectionManagers().get(baseIdentifier);
            }
            if (connectionManager != null || this.automaticallyCreateDatabase) break block6;
            StringBuffer buffer = new StringBuffer();
            buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
            ConnectionManager connectionManager3 = null;
            return connectionManager3;
        }
        ConnectionManager connectionManager4 = connectionManager;
        return connectionManager4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageCloseCommand(CloseMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            connectionManager = this.getConnectionManager(baseIdentifier);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                CloseMessageResponse closeMessageResponse = new CloseMessageResponse(baseIdentifier, message.getConnectionId(), buffer.toString());
                return closeMessageResponse;
            }
            connection = connectionManager.getConnection(message.getConnectionId());
            connection.setCurrentAction(6);
            connection.close();
            connectionManager.removeConnection(connection);
            this.sessionManager.removeSession(baseIdentifier);
            this.connectionIsUp = false;
            CloseMessageResponse buffer = new CloseMessageResponse(baseIdentifier, message.getConnectionId());
            return buffer;
        }
        catch (Exception e) {
            DLogger.error(baseIdentifier + ":Server error while closing", e);
            CloseMessageResponse closeMessageResponse = new CloseMessageResponse(baseIdentifier, message.getConnectionId(), OdbString.exceptionToString(e, false));
            return closeMessageResponse;
        }
        finally {
            if (mutex != null) {
                mutex.release("close");
            }
        }
    }

    private Message manageGetSessionsCommand(GetSessionsMessage message) {
        try {
            List<String> descriptions = this.sessionManager.getSessionDescriptions(this.server.getConnectionManagers());
            return new GetSessionsMessageResponse(descriptions);
        }
        catch (Exception e) {
            DLogger.error("Server error while getting session descriptions", e);
            return new GetSessionsMessageResponse(OdbString.exceptionToString(e, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageCommitCommand(CommitMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            connectionManager = this.getConnectionManager(baseIdentifier);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                CommitMessageResponse commitMessageResponse = new CommitMessageResponse(baseIdentifier, message.getConnectionId(), buffer.toString());
                return commitMessageResponse;
            }
            connection = connectionManager.getConnection(message.getConnectionId());
            connection.setCurrentAction(5);
            connection.commit();
            CommitMessageResponse buffer = new CommitMessageResponse(baseIdentifier, message.getConnectionId(), true);
            return buffer;
        }
        catch (Exception e) {
            DLogger.error(baseIdentifier + ":Server error while commiting", e);
            CommitMessageResponse commitMessageResponse = new CommitMessageResponse(baseIdentifier, message.getConnectionId(), OdbString.exceptionToString(e, false));
            return commitMessageResponse;
        }
        finally {
            if (mutex != null) {
                mutex.release("commit");
            }
            connection.endCurrentAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageRollbackCommand(RollbackMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            connectionManager = this.getConnectionManager(baseIdentifier);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                RollbackMessageResponse rollbackMessageResponse = new RollbackMessageResponse(baseIdentifier, message.getConnectionId(), buffer.toString());
                return rollbackMessageResponse;
            }
            connection = connectionManager.getConnection(message.getConnectionId());
            connection.setCurrentAction(7);
            connection.rollback();
        }
        catch (Exception e) {
            DLogger.error(baseIdentifier + ":Server error while rollbacking", e);
            RollbackMessageResponse rollbackMessageResponse = new RollbackMessageResponse(baseIdentifier, message.getConnectionId(), OdbString.exceptionToString(e, false));
            return rollbackMessageResponse;
        }
        finally {
            if (mutex != null) {
                mutex.release("rollback");
            }
            connection.endCurrentAction();
        }
        return new RollbackMessageResponse(baseIdentifier, message.getConnectionId(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageStoreCommand(StoreMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        Mutex mutex = null;
        OID oid = message.getNnoi().getOid();
        try {
            boolean objectIsNew;
            connectionManager = this.getConnectionManager(baseIdentifier);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                StoreMessageResponse storeMessageResponse = new StoreMessageResponse(baseIdentifier, message.getConnectionId(), buffer.toString());
                return storeMessageResponse;
            }
            connection = connectionManager.getConnection(message.getConnectionId());
            ServerSession session = this.getSession(baseIdentifier);
            IStorageEngine engine = connection.getStorageEngine();
            session.setClientIds(message.getClientIds());
            boolean bl = objectIsNew = oid == StorageEngineConstant.NULL_OBJECT_ID;
            if (objectIsNew) {
                connection.setCurrentAction(1);
                mutex = MutexFactory.get(baseIdentifier).acquire("store");
                oid = engine.writeObjectInfo(StorageEngineConstant.NULL_OBJECT_ID, message.getNnoi(), -1L, false);
            } else {
                connection.setCurrentAction(2);
                connection.lockObjectWithOid(oid);
                mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
                oid = engine.updateObject(message.getNnoi(), false);
            }
            StoreMessageResponse storeMessageResponse = new StoreMessageResponse(baseIdentifier, message.getConnectionId(), oid, objectIsNew, message.getClientIds(), session.getServerIds());
            return storeMessageResponse;
        }
        catch (Exception e) {
            if (oid != null) {
                try {
                    connection.unlockObjectWithOid(message.getNnoi().getOid());
                }
                catch (Exception e1) {
                    DLogger.error("Error while unlocking object with oid " + oid + " : " + OdbString.exceptionToString(e1, true));
                }
            }
            String se = OdbString.exceptionToString(e, false);
            String msg = baseIdentifier + ":Error while storing object " + message.getNnoi();
            DLogger.error(msg, e);
            StoreMessageResponse storeMessageResponse = new StoreMessageResponse(baseIdentifier, message.getConnectionId(), msg + ":\n" + se);
            return storeMessageResponse;
        }
        finally {
            if (mutex != null) {
                mutex.release("store");
            }
            connection.endCurrentAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageAddClassInfoListCommand(NewClassInfoListMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            connectionManager = this.getConnectionManager(baseIdentifier);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                StoreMessageResponse storeMessageResponse = new StoreMessageResponse(baseIdentifier, message.getConnectionId(), buffer.toString());
                return storeMessageResponse;
            }
            connection = connectionManager.getConnection(message.getConnectionId());
            ServerSession session = this.getSession(baseIdentifier);
            IStorageEngine engine = connection.getStorageEngine();
            ClassInfoList ciList = message.getClassInfoList();
            ciList = engine.getObjectWriter().addClasses(ciList);
            OdbArrayList<ClassInfo> allClassInfos = new OdbArrayList<ClassInfo>();
            allClassInfos.addAll(session.getMetaModel().getAllClasses());
            NewClassInfoListMessageResponse r = new NewClassInfoListMessageResponse(baseIdentifier, message.getConnectionId(), allClassInfos);
            session.resetClassInfoIds();
            NewClassInfoListMessageResponse newClassInfoListMessageResponse = r;
            return newClassInfoListMessageResponse;
        }
        catch (Exception e) {
            String se = OdbString.exceptionToString(e, false);
            String msg = baseIdentifier + ":Error while adding new Class Info List" + message.getClassInfoList();
            DLogger.error(msg, e);
            NewClassInfoListMessageResponse newClassInfoListMessageResponse = new NewClassInfoListMessageResponse(baseIdentifier, message.getConnectionId(), msg + ":\n" + se);
            return newClassInfoListMessageResponse;
        }
        finally {
            if (mutex != null) {
                mutex.release("addClassInfoList");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageDeleteObjectCommand(DeleteObjectMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            connectionManager = this.getConnectionManager(baseIdentifier, null, null, true);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                StoreMessageResponse storeMessageResponse = new StoreMessageResponse(baseIdentifier, message.getConnectionId(), buffer.toString());
                return storeMessageResponse;
            }
            connection = connectionManager.getConnection(message.getConnectionId());
            connection.setCurrentAction(3);
            ServerSession session = (ServerSession)this.sessionManager.getSession(baseIdentifier, true);
            IStorageEngine engine = connection.getStorageEngine();
            engine.deleteObjectWithOid(message.getOid());
            DeleteObjectMessageResponse deleteObjectMessageResponse = new DeleteObjectMessageResponse(baseIdentifier, message.getConnectionId(), message.getOid());
            return deleteObjectMessageResponse;
        }
        catch (Exception e) {
            String se = OdbString.exceptionToString(e, false);
            String msg = baseIdentifier + ":Error while deleting object " + message.getOid();
            DLogger.error(msg, e);
            DeleteObjectMessageResponse deleteObjectMessageResponse = new DeleteObjectMessageResponse(baseIdentifier, message.getConnectionId(), msg + ":\n" + se);
            return deleteObjectMessageResponse;
        }
        finally {
            if (mutex != null) {
                mutex.release("deleteObject");
            }
            connection.endCurrentAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message manageDeleteBaseCommand(DeleteBaseMessage message) {
        String fileName;
        StringBuffer log;
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        try {
            connectionManager = this.getConnectionManager(baseIdentifier, null, null, true);
            log = new StringBuffer();
            fileName = message.getBaseIdentifier();
            OdbFile file = new OdbFile(fileName);
            if (connectionManager == null) {
                if (this.debug) {
                    log.append("Server:Connection manager is null Deleting base " + file.getFullPath()).append(" | exists?").append(file.exists());
                }
                if (file.exists()) {
                    boolean b = IOUtil.deleteFile(file.getFullPath());
                    if (this.debug) {
                        log.append("| deleted=").append(b);
                    }
                    boolean bl = b = !file.exists();
                    if (this.debug) {
                        log.append("| deleted=").append(b);
                    }
                    if (b) {
                        DeleteBaseMessageResponse deleteBaseMessageResponse = new DeleteBaseMessageResponse(baseIdentifier);
                        return deleteBaseMessageResponse;
                    }
                    DeleteBaseMessageResponse deleteBaseMessageResponse = new DeleteBaseMessageResponse(baseIdentifier, "[1] could not delete base " + file.getFullPath());
                    return deleteBaseMessageResponse;
                }
                DeleteBaseMessageResponse b = new DeleteBaseMessageResponse(baseIdentifier);
                return b;
            }
            IStorageEngine engine = connectionManager.getStorageEngine();
            if (!engine.isClosed()) {
                this.sessionManager.addSession(OdbConfiguration.getCoreProvider().getServerSession(engine, "temp"));
                engine.close();
                this.sessionManager.removeSession(baseIdentifier);
                this.removeConnectionManager(baseIdentifier);
            }
        }
        catch (Exception e) {
            String se = OdbString.exceptionToString(e, false);
            String msg = baseIdentifier + ":Error while deleting base " + message.getBaseIdentifier();
            DLogger.error(msg, e);
            DeleteBaseMessageResponse deleteBaseMessageResponse = new DeleteBaseMessageResponse(baseIdentifier, msg + ":\n" + se);
            return deleteBaseMessageResponse;
        }
        boolean b = IOUtil.deleteFile(fileName);
        log.append("| deleted=").append(b);
        if (!b) return new DeleteBaseMessageResponse(baseIdentifier, "[2] could not delete base " + new OdbFile(message.getBaseIdentifier()).getFullPath());
        return new DeleteBaseMessageResponse(baseIdentifier);
        finally {
            if (this.debug) {
                DLogger.info(log.toString());
            }
        }
        finally {
            this.sessionManager.removeSession(baseIdentifier);
            this.removeConnectionManager(baseIdentifier);
            this.connectionIsUp = false;
        }
    }

    private void removeConnectionManager(String baseId) {
        this.server.getConnectionManagers().remove(baseId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageGetObjectsCommand(GetMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            connectionManager = this.getConnectionManager(baseIdentifier);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                GetMessageResponse getMessageResponse = new GetMessageResponse(baseIdentifier, message.getConnectionId(), buffer.toString());
                return getMessageResponse;
            }
            connection = connectionManager.getConnection(message.getConnectionId());
            connection.setCurrentAction(4);
            if (OdbConfiguration.lockObjectsOnSelect()) {
                String fullClassName = QueryManager.getFullClassName(message.getQuery());
                connection.lockClass(fullClassName);
            }
            IStorageEngine engine = connection.getStorageEngine();
            Objects<NonNativeObjectInfo> metaObjects = null;
            metaObjects = engine.getObjectInfos(message.getQuery(), true, message.getStartIndex(), message.getEndIndex(), false);
            GetMessageResponse getMessageResponse = new GetMessageResponse(baseIdentifier, message.getConnectionId(), metaObjects, message.getQuery().getExecutionPlan());
            return getMessageResponse;
        }
        catch (Exception e) {
            String se = OdbString.exceptionToString(e, false);
            String msg = baseIdentifier + ":Error while getting objects for query " + message.getQuery();
            DLogger.error(msg, e);
            GetMessageResponse getMessageResponse = new GetMessageResponse(baseIdentifier, message.getConnectionId(), msg + ":\n" + se);
            return getMessageResponse;
        }
        finally {
            if (mutex != null) {
                mutex.release("getObjects");
            }
            connection.endCurrentAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageGetObjectValuesCommand(GetObjectValuesMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            connectionManager = this.getConnectionManager(baseIdentifier);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                GetMessageResponse getMessageResponse = new GetMessageResponse(baseIdentifier, message.getConnectionId(), buffer.toString());
                return getMessageResponse;
            }
            connection = connectionManager.getConnection(message.getConnectionId());
            connection.setCurrentAction(4);
            IStorageEngine engine = connection.getStorageEngine();
            Values values = engine.getValues(message.getQuery(), message.getStartIndex(), message.getEndIndex());
            GetObjectValuesMessageResponse getObjectValuesMessageResponse = new GetObjectValuesMessageResponse(baseIdentifier, message.getConnectionId(), values, message.getQuery().getExecutionPlan());
            return getObjectValuesMessageResponse;
        }
        catch (Exception e) {
            String se = OdbString.exceptionToString(e, false);
            String msg = baseIdentifier + ":Error while getting objects for query " + message.getQuery();
            DLogger.error(msg, e);
            GetObjectValuesMessageResponse getObjectValuesMessageResponse = new GetObjectValuesMessageResponse(baseIdentifier, message.getConnectionId(), msg + ":\n" + se);
            return getObjectValuesMessageResponse;
        }
        finally {
            if (mutex != null) {
                mutex.release("getObjects");
            }
            connection.endCurrentAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageGetObjectFromIdCommand(GetObjectFromIdMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        OID oid = null;
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            connectionManager = this.getConnectionManager(baseIdentifier);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                GetObjectFromIdMessageResponse getObjectFromIdMessageResponse = new GetObjectFromIdMessageResponse(baseIdentifier, message.getConnectionId(), buffer.toString());
                return getObjectFromIdMessageResponse;
            }
            connection = connectionManager.getConnection(message.getConnectionId());
            connection.setCurrentAction(4);
            IStorageEngine engine = connection.getStorageEngine();
            oid = message.getOid();
            NonNativeObjectInfo nnoi = engine.getMetaObjectFromOid(oid);
            GetObjectFromIdMessageResponse getObjectFromIdMessageResponse = new GetObjectFromIdMessageResponse(baseIdentifier, message.getConnectionId(), nnoi);
            return getObjectFromIdMessageResponse;
        }
        catch (Exception e) {
            String se = OdbString.exceptionToString(e, false);
            String msg = baseIdentifier + ":Error while getting object of id " + oid;
            DLogger.error(msg, e);
            GetObjectFromIdMessageResponse getObjectFromIdMessageResponse = new GetObjectFromIdMessageResponse(baseIdentifier, message.getConnectionId(), msg + ":\n" + se);
            return getObjectFromIdMessageResponse;
        }
        finally {
            if (mutex != null) {
                mutex.release("getObjectFromId");
            }
            connection.endCurrentAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageGetObjectHeaderFromIdCommand(GetObjectHeaderFromIdMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        OID oid = null;
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            connectionManager = this.getConnectionManager(baseIdentifier);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                GetObjectHeaderFromIdMessageResponse getObjectHeaderFromIdMessageResponse = new GetObjectHeaderFromIdMessageResponse(baseIdentifier, message.getConnectionId(), buffer.toString());
                return getObjectHeaderFromIdMessageResponse;
            }
            connection = connectionManager.getConnection(message.getConnectionId());
            connection.setCurrentAction(4);
            IStorageEngine engine = connection.getStorageEngine();
            oid = message.getOid();
            ObjectInfoHeader oih = engine.getObjectInfoHeaderFromOid(oid, message.useCache());
            GetObjectHeaderFromIdMessageResponse getObjectHeaderFromIdMessageResponse = new GetObjectHeaderFromIdMessageResponse(baseIdentifier, message.getConnectionId(), oih.duplicate());
            return getObjectHeaderFromIdMessageResponse;
        }
        catch (Exception e) {
            String se = OdbString.exceptionToString(e, false);
            String msg = baseIdentifier + ":Error while getting object of id " + oid;
            DLogger.error(msg, e);
            GetObjectHeaderFromIdMessageResponse getObjectHeaderFromIdMessageResponse = new GetObjectHeaderFromIdMessageResponse(baseIdentifier, message.getConnectionId(), msg + ":\n" + se);
            return getObjectHeaderFromIdMessageResponse;
        }
        finally {
            if (mutex != null) {
                mutex.release("getObjectFromId");
            }
            connection.endCurrentAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageCountCommand(CountMessage message) {
        String baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        Mutex mutex = null;
        try {
            mutex = MutexFactory.get(baseIdentifier).acquire("commit-close-connect");
            connectionManager = this.getConnectionManager(baseIdentifier);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("ODBServer.ConnectionThread:Base ").append(baseIdentifier).append(" is not registered on this server!");
                GetObjectFromIdMessageResponse getObjectFromIdMessageResponse = new GetObjectFromIdMessageResponse(baseIdentifier, message.getConnectionId(), buffer.toString());
                return getObjectFromIdMessageResponse;
            }
            connection = connectionManager.getConnection(message.getConnectionId());
            IStorageEngine engine = connection.getStorageEngine();
            CriteriaQuery query = message.getCriteriaQuery();
            long nbObjects = engine.count(query);
            CountMessageResponse countMessageResponse = new CountMessageResponse(baseIdentifier, message.getConnectionId(), nbObjects);
            return countMessageResponse;
        }
        catch (Exception e) {
            String se = OdbString.exceptionToString(e, false);
            String msg = baseIdentifier + ":Error while counting objects for " + message.getCriteriaQuery();
            DLogger.error(msg, e);
            CountMessageResponse countMessageResponse = new CountMessageResponse(baseIdentifier, message.getConnectionId(), msg + ":\n" + se);
            return countMessageResponse;
        }
        finally {
            if (mutex != null) {
                mutex.release("count");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message manageConnectCommand(ConnectMessage message) {
        this.baseIdentifier = message.getBaseIdentifier();
        ConnectionManager connectionManager = null;
        IConnection connection = null;
        Mutex mutex = null;
        try {
            ConnectMessageResponse cmr;
            mutex = MutexFactory.get(this.baseIdentifier).acquire("commit-close-connect");
            connectionManager = this.getConnectionManager(this.baseIdentifier, message.getUser(), message.getPassword(), false);
            if (connectionManager == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Base ").append(this.baseIdentifier).append(" is not registered on this server!");
                ConnectMessageResponse connectMessageResponse = new ConnectMessageResponse(this.baseIdentifier, "?", buffer.toString());
                return connectMessageResponse;
            }
            String ip = message.getIp();
            long dateTime = message.getDateTime();
            connection = connectionManager.newConnection(ip, dateTime, connectionManager.getNbConnections());
            connection.setCurrentAction(0);
            this.connectionId = connection.getId();
            ServerSession session = new ServerSession(connection.getStorageEngine(), this.connectionId);
            IStorageEngine engine = connection.getStorageEngine();
            engine.addSession(session, true);
            TransactionId transactionId = engine.getCurrentTransactionId();
            if (this.debug) {
                DLogger.info(new StringBuffer("Connection from ").append(ip).append(" - cid=").append(connection.getId()).append(" - session=").append(session.getId()).append(" - Base Id=").append(this.baseIdentifier).toString());
            }
            MetaModel metaModel = engine.getSession(true).getMetaModel();
            ConnectMessageResponse connectMessageResponse = cmr = new ConnectMessageResponse(this.baseIdentifier, connection.getId(), metaModel, transactionId);
            return connectMessageResponse;
        }
        catch (Exception e) {
            String se = OdbString.exceptionToString(e, false);
            String msg = this.baseIdentifier + ":Error while connecting to  " + message.getBaseIdentifier();
            DLogger.error(msg, e);
            ConnectMessageResponse connectMessageResponse = new ConnectMessageResponse(this.baseIdentifier, message.getConnectionId(), msg + ":\n" + se);
            return connectMessageResponse;
        }
        finally {
            if (mutex != null) {
                mutex.release("connect");
            }
            if (connection != null) {
                connection.endCurrentAction();
            }
        }
    }

    public abstract void clearMessageStreamerCache();
}

