/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.instance.IInstanceBuilder;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.execution.IQueryExecutor;
import org.neodatis.odb.core.query.execution.MultiClassGenericQueryExecutor;
import org.neodatis.odb.core.query.nq.NativeQuery;
import org.neodatis.odb.core.query.nq.SimpleNativeQuery;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQueryExecutor;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQueryManager;
import org.neodatis.odb.impl.core.query.nq.NativeQueryExecutor;
import org.neodatis.odb.impl.core.query.nq.NativeQueryManager;
import org.neodatis.odb.impl.core.query.values.ValuesCriteriaQuery;
import org.neodatis.odb.impl.core.query.values.ValuesCriteriaQueryExecutor;

public class QueryManager {
    public static boolean match(IQuery query, Object object) {
        if (NativeQuery.class.isAssignableFrom(query.getClass())) {
            return NativeQueryManager.match((NativeQuery)query, object);
        }
        if (SimpleNativeQuery.class.isAssignableFrom(query.getClass())) {
            return NativeQueryManager.match((SimpleNativeQuery)query, object);
        }
        if (CriteriaQuery.class.isAssignableFrom(query.getClass())) {
            return CriteriaQueryManager.match((CriteriaQuery)query, object);
        }
        throw new ODBRuntimeException(NeoDatisError.QUERY_TYPE_NOT_IMPLEMENTED.addParameter(query.getClass().getName()));
    }

    public static String getFullClassName(IQuery query) {
        if (NativeQuery.class.isAssignableFrom(query.getClass())) {
            return NativeQueryManager.getClass((NativeQuery)query);
        }
        if (SimpleNativeQuery.class.isAssignableFrom(query.getClass())) {
            return NativeQueryManager.getFullClassName((SimpleNativeQuery)query);
        }
        if (CriteriaQuery.class == query.getClass() || ValuesCriteriaQuery.class == query.getClass()) {
            return CriteriaQueryManager.getFullClassName((CriteriaQuery)query);
        }
        throw new ODBRuntimeException(NeoDatisError.QUERY_TYPE_NOT_IMPLEMENTED.addParameter(query.getClass().getName()));
    }

    public static boolean needsInstanciation(IQuery query) {
        if (NativeQuery.class.isAssignableFrom(query.getClass())) {
            return true;
        }
        if (SimpleNativeQuery.class.isAssignableFrom(query.getClass())) {
            return true;
        }
        if (CriteriaQuery.class == query.getClass() || ValuesCriteriaQuery.class == query.getClass()) {
            return false;
        }
        throw new ODBRuntimeException(NeoDatisError.QUERY_TYPE_NOT_IMPLEMENTED.addParameter(query.getClass().getName()));
    }

    public static boolean isCriteriaQuery(IQuery query) {
        return CriteriaQuery.class.isAssignableFrom(query.getClass());
    }

    public static int[] getOrderByAttributeIds(ClassInfo classInfo, IQuery query) {
        String[] fieldNames = query.getOrderByFieldNames();
        int[] fieldIds = new int[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldIds[i] = classInfo.getAttributeId(fieldNames[i]);
        }
        return fieldIds;
    }

    public static IQueryExecutor getQueryExecutor(IQuery query, IStorageEngine engine, IInstanceBuilder instanceBuilder) {
        if (query.isPolymorphic()) {
            return QueryManager.getMultiClassQueryExecutor(query, engine, instanceBuilder);
        }
        return QueryManager.getSingleClassQueryExecutor(query, engine, instanceBuilder);
    }

    protected static IQueryExecutor getSingleClassQueryExecutor(IQuery query, IStorageEngine engine, IInstanceBuilder instanceBuilder) {
        if (CriteriaQuery.class == query.getClass()) {
            return new CriteriaQueryExecutor(query, engine);
        }
        if (ValuesCriteriaQuery.class == query.getClass()) {
            return new ValuesCriteriaQueryExecutor(query, engine);
        }
        if (NativeQuery.class.isAssignableFrom(query.getClass())) {
            return new NativeQueryExecutor(query, engine, instanceBuilder);
        }
        if (SimpleNativeQuery.class.isAssignableFrom(query.getClass())) {
            return new NativeQueryExecutor(query, engine, instanceBuilder);
        }
        throw new ODBRuntimeException(NeoDatisError.QUERY_TYPE_NOT_IMPLEMENTED.addParameter(query.getClass().getName()));
    }

    protected static IQueryExecutor getMultiClassQueryExecutor(IQuery query, IStorageEngine engine, IInstanceBuilder instanceBuilder) {
        if (CriteriaQuery.class == query.getClass()) {
            return new MultiClassGenericQueryExecutor(new CriteriaQueryExecutor(query, engine));
        }
        if (ValuesCriteriaQuery.class == query.getClass()) {
            return new MultiClassGenericQueryExecutor(new ValuesCriteriaQueryExecutor(query, engine));
        }
        if (NativeQuery.class.isAssignableFrom(query.getClass())) {
            return new MultiClassGenericQueryExecutor(new NativeQueryExecutor(query, engine, instanceBuilder));
        }
        if (SimpleNativeQuery.class.isAssignableFrom(query.getClass())) {
            return new MultiClassGenericQueryExecutor(new NativeQueryExecutor(query, engine, instanceBuilder));
        }
        throw new ODBRuntimeException(NeoDatisError.QUERY_TYPE_NOT_IMPLEMENTED.addParameter(query.getClass().getName()));
    }
}

