/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer3.engine;

import org.neodatis.btree.impl.AbstractBTree;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.Objects;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.ICoreProvider;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer3.IBaseIdentification;
import org.neodatis.odb.core.layers.layer3.IOFileParameter;
import org.neodatis.odb.core.layers.layer3.IObjectReader;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.execution.IMatchingObjectAction;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.impl.core.btree.LazyODBBTreePersister;
import org.neodatis.odb.impl.core.btree.ODBBTreeMultiple;
import org.neodatis.odb.impl.core.btree.ODBBTreeSingle;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.impl.tool.MemoryMonitor;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStorageEngineReader
implements IStorageEngine {
    private static final String LOG_ID = "LocalStorageEngine";
    protected IObjectReader objectReader;
    protected boolean isClosed;
    protected IBaseIdentification baseIdentification;
    protected ICoreProvider provider;

    @Override
    public <T> Objects<T> getObjects(IQuery query, boolean inMemory, int startIndex, int endIndex) {
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.baseIdentification.getIdentification()));
        }
        return this.objectReader.getObjects(query, inMemory, startIndex, endIndex);
    }

    @Override
    public void defragmentTo(String newFileName) {
        long start = OdbTime.getCurrentTimeInMs();
        long totalNbObjects = 0L;
        IStorageEngine newStorage = OdbConfiguration.getCoreProvider().getClientStorageEngine(new IOFileParameter(newFileName, true, this.baseIdentification.getUserName(), this.baseIdentification.getPassword()));
        Objects defragObjects = null;
        int j = 0;
        ClassInfo ci2 = null;
        for (ClassInfo ci2 : this.getMetaModel().getUserClasses()) {
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Reading " + ci2.getCommitedZoneInfo().getNbObjects() + " objects of type " + ci2.getFullClassName());
            }
            defragObjects = this.getObjects(new CriteriaQuery(ci2.getFullClassName()), true, -1, -1);
            while (defragObjects.hasNext()) {
                newStorage.store(defragObjects.next());
                ++totalNbObjects;
                if (OdbConfiguration.isDebugEnabled(LOG_ID) && j % 10000 == 0) {
                    DLogger.info("\n" + totalNbObjects + " objects saved.");
                }
                ++j;
            }
        }
        for (ClassInfo ci2 : this.getMetaModel().getSystemClasses()) {
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Reading " + ci2.getCommitedZoneInfo().getNbObjects() + " objects of type " + ci2.getFullClassName());
            }
            defragObjects = this.getObjects(new CriteriaQuery(ci2.getFullClassName()), true, -1, -1);
            while (defragObjects.hasNext()) {
                newStorage.store(defragObjects.next());
                ++totalNbObjects;
                if (OdbConfiguration.isDebugEnabled(LOG_ID) && j % 10000 == 0) {
                    DLogger.info("\n" + totalNbObjects + " objects saved.");
                }
                ++j;
            }
        }
        newStorage.commit();
        newStorage.close();
        long time = OdbTime.getCurrentTimeInMs() - start;
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.info("New storage " + newFileName + " created with " + totalNbObjects + " objects in " + time + " ms.");
        }
    }

    protected MetaModel getMetaModel() {
        return this.getSession(true).getMetaModel();
    }

    @Override
    public abstract ISession getSession(boolean var1);

    @Override
    public void deleteIndex(String className, String indexName, boolean verbose) {
        ClassInfo classInfo = this.getMetaModel().getClassInfo(className, true);
        if (!classInfo.hasIndex(indexName)) {
            throw new ODBRuntimeException(NeoDatisError.INDEX_DOES_NOT_EXIST.addParameter(indexName).addParameter(className));
        }
        ClassInfoIndex cii = classInfo.getIndexWithName(indexName);
        if (verbose) {
            DLogger.info("Deleting index " + indexName + " on class " + className);
        }
        this.delete(cii);
        classInfo.removeIndex(cii);
        if (verbose) {
            DLogger.info("Index " + indexName + " deleted");
        }
    }

    @Override
    public void rebuildIndex(String className, String indexName, boolean verbose) {
        ClassInfo classInfo;
        if (verbose) {
            DLogger.info("Rebuilding index " + indexName + " on class " + className);
        }
        if (!(classInfo = this.getMetaModel().getClassInfo(className, true)).hasIndex(indexName)) {
            throw new ODBRuntimeException(NeoDatisError.INDEX_DOES_NOT_EXIST.addParameter(indexName).addParameter(className));
        }
        ClassInfoIndex cii = classInfo.getIndexWithName(indexName);
        this.deleteIndex(className, indexName, verbose);
        this.addIndexOn(className, indexName, classInfo.getAttributeNames(cii.getAttributeIds()), verbose, !cii.isUnique());
    }

    @Override
    public void addIndexOn(String className, String indexName, String[] indexFields, boolean verbose, boolean acceptMultipleValuesForSameKey) {
        ClassInfo classInfo = this.getMetaModel().getClassInfo(className, true);
        if (classInfo.hasIndex(indexName)) {
            throw new ODBRuntimeException(NeoDatisError.INDEX_ALREADY_EXIST.addParameter(indexName).addParameter(className));
        }
        ClassInfoIndex cii = classInfo.addIndexOn(indexName, indexFields, acceptMultipleValuesForSameKey);
        AbstractBTree btree = null;
        btree = acceptMultipleValuesForSameKey ? new ODBBTreeMultiple(className, OdbConfiguration.getDefaultIndexBTreeDegree(), new LazyODBBTreePersister(this)) : new ODBBTreeSingle(className, OdbConfiguration.getDefaultIndexBTreeDegree(), new LazyODBBTreePersister(this));
        cii.setBTree(btree);
        this.store(cii);
        if (classInfo.getNumberOfObjects() == 0L) {
            return;
        }
        if (verbose) {
            DLogger.info("Creating index " + indexName + " on class " + className + " - Class has already " + classInfo.getNumberOfObjects() + " Objects. Updating index");
        }
        if (verbose) {
            DLogger.info(indexName + " : loading " + classInfo.getNumberOfObjects() + " objects from database");
        }
        Objects objects = this.getObjectInfos(new CriteriaQuery(className), false, -1, -1, false);
        if (verbose) {
            DLogger.info(indexName + " : " + classInfo.getNumberOfObjects() + " objects loaded");
        }
        NonNativeObjectInfo nnoi = null;
        int i = 0;
        boolean monitorMemory = OdbConfiguration.isMonitoringMemory();
        while (objects.hasNext()) {
            nnoi = (NonNativeObjectInfo)objects.next();
            btree.insert(cii.computeKey(nnoi), nnoi.getOid());
            if (verbose && i % 1000 == 0 && monitorMemory) {
                MemoryMonitor.displayCurrentMemory("Index " + indexName + " " + i + " objects inserted", true);
            }
            ++i;
        }
        if (verbose) {
            DLogger.info(indexName + " created!");
        }
    }

    @Override
    public <T> Objects<T> getObjectInfos(IQuery query, boolean inMemory, int startIndex, int endIndex, boolean returnObjects) {
        IMatchingObjectAction queryResultAction = this.provider.getCollectionQueryResultAction(this, query, inMemory, returnObjects);
        return this.objectReader.getObjectInfos(query, inMemory, startIndex, endIndex, returnObjects, queryResultAction);
    }

    @Override
    public <T> Objects<T> getObjects(Class clazz, boolean inMemory, int startIndex, int endIndex) {
        if (this.isClosed) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.baseIdentification.getIdentification()));
        }
        return this.objectReader.getObjects(new CriteriaQuery(clazz.getName()), inMemory, startIndex, endIndex);
    }
}

