/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.meta;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.instance.IClassPool;
import org.neodatis.odb.impl.core.oid.OdbClassOID;
import org.neodatis.odb.impl.core.oid.OdbObjectOID;
import org.neodatis.tool.wrappers.OdbClassUtil;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public final class ODBType
implements Serializable {
    public static int nb;
    private static final long serialVersionUID = 341217747918380780L;
    private boolean isPrimitive;
    private final int id;
    private String name;
    private int size;
    private Class superClass;
    private Class defaultInstanciationClass;
    private long position;
    private static transient IClassPool classPool;
    private ODBType subType;
    public static final int NULL_ID = 0;
    public static final int NATIVE_BOOLEAN_ID = 10;
    public static final int NATIVE_BYTE_ID = 20;
    public static final int NATIVE_SIGNED_BYTE_ID = 21;
    public static final int NATIVE_CHAR_ID = 30;
    public static final int NATIVE_SHORT_ID = 40;
    public static final int NATIVE_INT_ID = 50;
    public static final int NATIVE_LONG_ID = 60;
    public static final int NATIVE_FLOAT_ID = 70;
    public static final int NATIVE_DOUBLE_ID = 80;
    public static final int BYTE_ID = 90;
    public static final int SIGNED_BYTE_ID = 91;
    public static final int SHORT_ID = 100;
    public static final int INTEGER_ID = 110;
    public static final int LONG_ID = 120;
    public static final int FLOAT_ID = 130;
    public static final int DOUBLE_ID = 140;
    public static final int CHARACTER_ID = 150;
    public static final int BOOLEAN_ID = 160;
    public static final int DATE_ID = 170;
    public static final int DATE_SQL_ID = 171;
    public static final int DATE_TIMESTAMP_ID = 172;
    public static final int OID_ID = 180;
    public static final int OBJECT_OID_ID = 181;
    public static final int CLASS_OID_ID = 182;
    public static final int BIG_INTEGER_ID = 190;
    public static final int BIG_DECIMAL_ID = 200;
    public static final int STRING_ID = 210;
    public static final int ENUM_ID = 211;
    public static final int NATIVE_FIX_SIZE_MAX_ID = 182;
    public static final int NATIVE_MAX_ID = 210;
    public static final int COLLECTION_ID = 250;
    public static final int ARRAY_ID = 260;
    public static final int MAP_ID = 270;
    public static final int NON_NATIVE_ID = 300;
    public static final ODBType NULL;
    public static final ODBType NATIVE_BOOLEAN;
    public static final ODBType NATIVE_BYTE;
    public static final ODBType NATIVE_CHAR;
    public static final ODBType NATIVE_SHORT;
    public static final ODBType NATIVE_INT;
    public static final ODBType NATIVE_LONG;
    public static final ODBType NATIVE_FLOAT;
    public static final ODBType NATIVE_DOUBLE;
    public static final ODBType BYTE;
    public static final ODBType SHORT;
    public static final ODBType INTEGER;
    public static final ODBType BIG_INTEGER;
    public static final ODBType LONG;
    public static final ODBType FLOAT;
    public static final ODBType DOUBLE;
    public static final ODBType BIG_DECIMAL;
    public static final ODBType CHARACTER;
    public static final ODBType BOOLEAN;
    public static final ODBType DATE;
    public static final ODBType DATE_SQL;
    public static final ODBType DATE_TIMESTAMP;
    public static final ODBType STRING;
    public static final ODBType ENUM;
    public static final ODBType COLLECTION;
    public static final ODBType ARRAY;
    public static final ODBType MAP;
    public static final ODBType OID;
    public static final ODBType OBJECT_OID;
    public static final ODBType CLASS_OID;
    public static final ODBType NON_NATIVE;
    private static final Map<Integer, ODBType> typesById;
    private static final Map<String, ODBType> typesByName;
    private static final Map<String, ODBType> cacheOfTypesByName;
    public static final String DEFAULT_COLLECTION_CLASS_NAME;
    public static final String DEFAULT_MAP_CLASS_NAME;
    public static final String DEFAULT_ARRAY_COMPONENT_CLASS_NAME;
    public static final int SIZE_OF_INT;
    public static final int SIZE_OF_LONG;
    public static final int SIZE_OF_BOOL;
    public static final int SIZE_OF_BYTE;

    protected ODBType(boolean isPrimitive, int id, String name, int size) {
        this.isPrimitive = isPrimitive;
        this.id = id;
        this.name = name;
        this.size = size;
    }

    protected ODBType(boolean isPrimitive, int id, String name, int size, Class superclass) {
        this.isPrimitive = isPrimitive;
        this.id = id;
        this.name = name;
        this.size = size;
        this.superClass = superclass;
    }

    protected ODBType(boolean isPrimitive, int id, String name, int size, Class superclass, Class defaultClass) {
        this(isPrimitive, id, name, size, superclass);
        this.defaultInstanciationClass = defaultClass;
    }

    private synchronized void initClassPool() {
        classPool = OdbConfiguration.getCoreProvider().getClassPool();
    }

    public ODBType copy() {
        ODBType newType = new ODBType(this.isPrimitive, this.id, this.name, this.size);
        if (this.subType != null) {
            newType.subType = this.getSubType().copy();
        }
        return newType;
    }

    public static ODBType getFromId(int id) {
        ODBType odbType = typesById.get(new Integer(id));
        if (odbType == null) {
            throw new ODBRuntimeException(NeoDatisError.ODB_TYPE_ID_DOES_NOT_EXIST.addParameter(id));
        }
        return odbType;
    }

    public static String getNameFromId(int id) {
        return ODBType.getFromId(id).getName();
    }

    public static ODBType getFromName(String fullName) {
        ODBType tc = typesByName.get(fullName);
        if (tc != null) {
            return tc;
        }
        ODBType nonNative = new ODBType(ODBType.NON_NATIVE.isPrimitive, 300, fullName, 0);
        return nonNative;
    }

    public static ODBType getFromClass(Class clazz) {
        String className = clazz.getName();
        if (OdbClassUtil.isEnum(clazz)) {
            ODBType type = new ODBType(ODBType.ENUM.isPrimitive, 211, ENUM.getName(), 0);
            type.setName(clazz.getName());
            return type;
        }
        ODBType tc = typesByName.get(className);
        if (tc != null) {
            return tc;
        }
        tc = cacheOfTypesByName.get(className);
        if (tc != null) {
            return tc;
        }
        if (ODBType.isArray(clazz)) {
            ODBType type = new ODBType(ODBType.ARRAY.isPrimitive, 260, ARRAY.getName(), 0);
            type.subType = ODBType.getFromClass(clazz.getComponentType());
            cacheOfTypesByName.put(className, type);
            return type;
        }
        if (ODBType.isMap(clazz)) {
            cacheOfTypesByName.put(className, MAP);
            return MAP;
        }
        if (ODBType.isCollection(clazz)) {
            cacheOfTypesByName.put(className, COLLECTION);
            return COLLECTION;
        }
        ++nb;
        ODBType nonNative = new ODBType(ODBType.NON_NATIVE.isPrimitive, 300, clazz.getName(), 0);
        cacheOfTypesByName.put(className, nonNative);
        return nonNative;
    }

    public static boolean isArray(Class clazz) {
        return clazz.isArray();
    }

    public static boolean isMap(Class clazz) {
        return ODBType.MAP.superClass.isAssignableFrom(clazz);
    }

    public static boolean isCollection(Class clazz) {
        return ODBType.COLLECTION.superClass.isAssignableFrom(clazz);
    }

    public static boolean isNative(Class clazz) {
        ODBType tc = typesByName.get(clazz.getName());
        if (tc != null) {
            return true;
        }
        if (clazz.isArray()) {
            return true;
        }
        if (ODBType.MAP.superClass.isAssignableFrom(clazz)) {
            return true;
        }
        return ODBType.COLLECTION.superClass.isAssignableFrom(clazz);
    }

    public static boolean exist(String name) {
        return typesByName.get(name) != null;
    }

    public final int getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final int getSize() {
        return this.size;
    }

    public boolean isCollection() {
        return this.id == 250;
    }

    public static boolean isCollection(int odbTypeId) {
        return odbTypeId == 250;
    }

    public boolean isArray() {
        return this.id == 260;
    }

    public static boolean isArray(int odbTypeId) {
        return odbTypeId == 260;
    }

    public boolean isMap() {
        return this.id == 270;
    }

    public static boolean isMap(int odbTypeId) {
        return odbTypeId == 270;
    }

    public boolean isArrayOrCollection() {
        return this.isArray() || this.isCollection();
    }

    public static boolean isNative(int odbtypeId) {
        return odbtypeId != 300;
    }

    public boolean isNative() {
        return this.id != 300;
    }

    public ODBType getSubType() {
        return this.subType;
    }

    public Class getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(Class superClass) {
        this.superClass = superClass;
    }

    public String toString() {
        return this.id + " - " + this.name;
    }

    public void setSubType(ODBType subType) {
        this.subType = subType;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ODBType.class) {
            return false;
        }
        ODBType type = (ODBType)obj;
        return this.getId() == type.getId();
    }

    public Class getNativeClass() {
        switch (this.id) {
            case 10: {
                return Boolean.TYPE;
            }
            case 20: {
                return Byte.TYPE;
            }
            case 30: {
                return Character.TYPE;
            }
            case 80: {
                return Double.TYPE;
            }
            case 70: {
                return Float.TYPE;
            }
            case 50: {
                return Integer.TYPE;
            }
            case 60: {
                return Long.TYPE;
            }
            case 40: {
                return Short.TYPE;
            }
            case 181: {
                return OdbObjectOID.class;
            }
            case 182: {
                return OdbClassOID.class;
            }
            case 180: {
                return OID.class;
            }
        }
        if (classPool == null) {
            this.initClassPool();
        }
        return classPool.getClass(this.getName());
    }

    public boolean isNonNative() {
        return this.id == 300;
    }

    public static boolean isNonNative(int odbtypeId) {
        return odbtypeId == 300;
    }

    public boolean isNull() {
        return this.id == 0;
    }

    public static boolean isNull(int odbTypeId) {
        return odbTypeId == 0;
    }

    public boolean hasFixSize() {
        return ODBType.hasFixSize(this.id);
    }

    public static boolean hasFixSize(int odbId) {
        return odbId > 0 && odbId <= 182;
    }

    public boolean isStringOrBigDicemalOrBigInteger() {
        return ODBType.isStringOrBigDicemalOrBigInteger(this.id);
    }

    public static boolean isStringOrBigDicemalOrBigInteger(int odbTypeId) {
        return odbTypeId == 210 || odbTypeId == 200 || odbTypeId == 190;
    }

    public static boolean isAtomicNative(int odbTypeId) {
        return odbTypeId > 0 && odbTypeId <= 210;
    }

    public boolean isAtomicNative() {
        return ODBType.isAtomicNative(this.id);
    }

    public static boolean isEnum(int odbTypeId) {
        return odbTypeId == 211;
    }

    public boolean isEnum() {
        return ODBType.isEnum(this.id);
    }

    public static boolean isPrimitive(int odbTypeId) {
        return ODBType.getFromId((int)odbTypeId).isPrimitive;
    }

    public static boolean typesAreCompatible(ODBType type1, ODBType type2) {
        if (type1.isArray() && type2.isArray()) {
            return ODBType.typesAreCompatible(type1.getSubType(), type2.getSubType());
        }
        if (type1.getName().equals(type2.getName())) {
            return true;
        }
        if (type1.isNative() && type2.isNative()) {
            return type1.isEquivalent(type2);
        }
        if (type1.isNonNative() && type2.isNonNative()) {
            return type1.getNativeClass() == type2.getNativeClass() || type1.getNativeClass().isAssignableFrom(type2.getNativeClass());
        }
        return false;
    }

    public boolean isBoolean() {
        return this.id == 160 || this.id == 10;
    }

    private boolean isEquivalent(ODBType type2) {
        return this.id == 110 && type2.id == 50 || type2.id == 110 && this.id == 50;
    }

    public Class getDefaultInstanciationClass() {
        return this.defaultInstanciationClass;
    }

    public void init2() {
    }

    public boolean isDate() {
        return this.id == 170 || this.id == 171 || this.id == 172;
    }

    static {
        classPool = null;
        NULL = new ODBType(true, 0, "null", 1);
        NATIVE_BOOLEAN = new ODBType(true, 10, Boolean.TYPE.getName(), 1);
        NATIVE_BYTE = new ODBType(true, 20, Byte.TYPE.getName(), 1);
        NATIVE_CHAR = new ODBType(true, 30, Character.TYPE.getName(), 2);
        NATIVE_SHORT = new ODBType(true, 40, Short.TYPE.getName(), 2);
        NATIVE_INT = new ODBType(true, 50, Integer.TYPE.getName(), 4);
        NATIVE_LONG = new ODBType(true, 60, Long.TYPE.getName(), 8);
        NATIVE_FLOAT = new ODBType(true, 70, Float.TYPE.getName(), 4);
        NATIVE_DOUBLE = new ODBType(true, 80, Double.TYPE.getName(), 8);
        BYTE = new ODBType(false, 90, Byte.class.getName(), 1);
        SHORT = new ODBType(false, 100, Short.class.getName(), 2);
        INTEGER = new ODBType(false, 110, Integer.class.getName(), 4);
        BIG_INTEGER = new ODBType(false, 190, BigInteger.class.getName(), 1);
        LONG = new ODBType(false, 120, Long.class.getName(), 8);
        FLOAT = new ODBType(false, 130, Float.class.getName(), 4);
        DOUBLE = new ODBType(false, 140, Double.class.getName(), 8);
        BIG_DECIMAL = new ODBType(false, 200, BigDecimal.class.getName(), 1);
        CHARACTER = new ODBType(false, 150, Character.class.getName(), 2);
        BOOLEAN = new ODBType(false, 160, Boolean.class.getName(), 1);
        DATE = new ODBType(false, 170, java.util.Date.class.getName(), 8);
        DATE_SQL = new ODBType(false, 171, Date.class.getName(), 8);
        DATE_TIMESTAMP = new ODBType(false, 172, Timestamp.class.getName(), 8);
        STRING = new ODBType(false, 210, String.class.getName(), 1);
        ENUM = new ODBType(false, 211, Enum.class.getName(), 1);
        COLLECTION = new ODBType(false, 250, Collection.class.getName(), 0, Collection.class, ArrayList.class);
        ARRAY = new ODBType(false, 260, "array", 0);
        MAP = new ODBType(false, 270, Map.class.getName(), 0, Map.class, HashMap.class);
        OID = new ODBType(false, 180, OID.class.getName(), 0, OID.class);
        OBJECT_OID = new ODBType(false, 181, OdbObjectOID.class.getName(), 0, OdbObjectOID.class);
        CLASS_OID = new ODBType(false, 182, OdbClassOID.class.getName(), 0, OdbClassOID.class);
        NON_NATIVE = new ODBType(false, 300, "non native", 0);
        typesById = new OdbHashMap<Integer, ODBType>();
        typesByName = new OdbHashMap<String, ODBType>();
        cacheOfTypesByName = new OdbHashMap<String, ODBType>();
        DEFAULT_COLLECTION_CLASS_NAME = ArrayList.class.getName();
        DEFAULT_MAP_CLASS_NAME = HashMap.class.getName();
        DEFAULT_ARRAY_COMPONENT_CLASS_NAME = Object.class.getName();
        SIZE_OF_INT = INTEGER.getSize();
        SIZE_OF_LONG = LONG.getSize();
        SIZE_OF_BOOL = BOOLEAN.getSize();
        SIZE_OF_BYTE = BYTE.getSize();
        OdbArrayList<ODBType> allTypes = new OdbArrayList<ODBType>(100);
        allTypes.add(NULL);
        allTypes.add(NATIVE_BOOLEAN);
        allTypes.add(NATIVE_BYTE);
        allTypes.add(NATIVE_CHAR);
        allTypes.add(NATIVE_SHORT);
        allTypes.add(NATIVE_INT);
        allTypes.add(NATIVE_LONG);
        allTypes.add(NATIVE_FLOAT);
        allTypes.add(NATIVE_DOUBLE);
        allTypes.add(BYTE);
        allTypes.add(SHORT);
        allTypes.add(INTEGER);
        allTypes.add(LONG);
        allTypes.add(FLOAT);
        allTypes.add(DOUBLE);
        allTypes.add(BIG_DECIMAL);
        allTypes.add(BIG_INTEGER);
        allTypes.add(CHARACTER);
        allTypes.add(BOOLEAN);
        allTypes.add(DATE);
        allTypes.add(DATE_SQL);
        allTypes.add(DATE_TIMESTAMP);
        allTypes.add(STRING);
        allTypes.add(ENUM);
        allTypes.add(COLLECTION);
        allTypes.add(ARRAY);
        allTypes.add(MAP);
        allTypes.add(OID);
        allTypes.add(OBJECT_OID);
        allTypes.add(CLASS_OID);
        allTypes.add(NON_NATIVE);
        ODBType type = null;
        for (int i = 0; i < allTypes.size(); ++i) {
            type = (ODBType)allTypes.get(i);
            typesByName.put(type.getName(), type);
            typesById.put(new Integer(type.getId()), type);
        }
    }
}

