/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util.script;

import gov.nasa.jpf.util.script.Alternative;
import gov.nasa.jpf.util.script.CG;
import gov.nasa.jpf.util.script.ElementProcessor;
import gov.nasa.jpf.util.script.Event;
import gov.nasa.jpf.util.script.Repetition;
import gov.nasa.jpf.util.script.ScriptElement;
import gov.nasa.jpf.util.script.Section;
import gov.nasa.jpf.util.script.SetChoice;
import gov.nasa.jpf.util.script.SingleChoice;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class StringSetGenerator
implements ElementProcessor {
    LinkedHashMap<String, ArrayList<CG>> sections = new LinkedHashMap();
    ArrayList<CG> queue = new ArrayList();

    StringSetGenerator() {
        this.sections.put("default", this.queue);
    }

    @Override
    public void process(Section sec) {
        this.queue = new ArrayList();
        sec.processChildren(this);
        for (String id : sec.getIds()) {
            this.sections.put(id, this.queue);
        }
    }

    @Override
    public void process(Event e) {
        for (Event ee : e.expand()) {
            this.queue.add(new SingleChoice(ee));
        }
    }

    @Override
    public void process(Alternative a) {
        SetChoice cg = new SetChoice();
        for (ScriptElement e = a.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (!(e instanceof Event)) continue;
            for (Event ee : ((Event)e).expand()) {
                cg.add(ee);
            }
        }
        this.queue.add(cg);
    }

    @Override
    public void process(Repetition r) {
        int n = r.getRepeatCount();
        for (int i = 0; i < n; ++i) {
            r.processChildren(this);
        }
    }

    public LinkedHashMap<String, ArrayList<CG>> getSections() {
        return this.sections;
    }

    public List<CG> getCGQueue() {
        return this.queue;
    }
}

