/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util.script;

import gov.nasa.jpf.util.script.ElementProcessor;
import gov.nasa.jpf.util.script.ScriptElement;
import java.io.PrintWriter;
import java.util.Iterator;

public abstract class ScriptElementContainer
extends ScriptElement
implements Iterable<ScriptElement> {
    ScriptElement firstChild;

    ScriptElementContainer(ScriptElement parent, int line) {
        super(parent, line);
    }

    public ScriptElement getFirstChild() {
        return this.firstChild;
    }

    public void add(ScriptElement e) {
        e.nextSibling = null;
        if (this.firstChild == null) {
            this.firstChild = e;
        } else {
            ScriptElement p = this.firstChild;
            while (p.nextSibling != null) {
                p = p.nextSibling;
            }
            p.nextSibling = e;
        }
    }

    public int getNumberOfChildren() {
        int n = 0;
        for (ScriptElement e = this.firstChild; e != null; e = e.getNextSibling()) {
            ++n;
        }
        return n;
    }

    public SECIterator iterator() {
        return new SECIterator();
    }

    void dump(PrintWriter w, int level, ScriptElement elem) {
        try {
            while (elem != null) {
                for (int i = 0; i < level; ++i) {
                    w.print("  ");
                }
                w.print(elem);
                if (elem instanceof ScriptElementContainer) {
                    ScriptElementContainer c = (ScriptElementContainer)elem;
                    w.println(" {");
                    this.dump(w, level + 1, c.getFirstChild());
                    for (int i = 0; i < level; ++i) {
                        w.print("  ");
                    }
                    w.println("}");
                } else {
                    w.println();
                }
                elem = elem.getNextSibling();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected String toString(String type) {
        StringBuilder sb = new StringBuilder();
        if (type != null) {
            sb.append(type);
            sb.append(' ');
        }
        sb.append("{");
        int i = 0;
        ScriptElement e = this.firstChild;
        while (e != null) {
            if (i++ > 0) {
                sb.append(',');
            }
            sb.append(e);
            e = e.nextSibling;
        }
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public void dump(PrintWriter w) {
        this.dump(w, 0, this.firstChild);
    }

    public void processChildren(ElementProcessor p) {
        ScriptElement e = this.firstChild;
        while (e != null) {
            e.process(p);
            e = e.nextSibling;
        }
    }

    protected class SECIterator
    implements Iterator<ScriptElement>,
    Cloneable {
        SECIterator prev;
        ScriptElement cur;

        SECIterator() {
            this.cur = ScriptElementContainer.this.firstChild;
        }

        @Override
        public boolean hasNext() {
            return this.cur != null;
        }

        @Override
        public ScriptElement next() {
            if (this.cur != null) {
                ScriptElement ret = this.cur;
                this.cur = this.cur.nextSibling;
                return ret;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("no ScriptElement removal supported");
        }

        public SECIterator getPrev() {
            return this.prev;
        }

        public void setPrev(SECIterator it) {
            this.prev = it;
        }

        public Object clone() {
            try {
                SECIterator it = (SECIterator)super.clone();
                if (this.prev != null) {
                    it.prev = (SECIterator)this.prev.clone();
                }
                return it;
            }
            catch (CloneNotSupportedException cnsx) {
                return null;
            }
        }
    }
}

