/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util.script;

import gov.nasa.jpf.util.script.ElementProcessor;
import gov.nasa.jpf.util.script.ScriptElement;
import gov.nasa.jpf.util.script.ScriptElementContainer;

public class Repetition
extends ScriptElementContainer {
    int repeatCount;

    public Repetition(ScriptElement parent, int n, int line) {
        super(parent, line);
        this.repeatCount = n;
    }

    @Override
    public ScriptElementContainer.SECIterator iterator() {
        return new RepetitionIterator();
    }

    @Override
    public String toString() {
        return this.toString("REPEAT " + this.repeatCount);
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    @Override
    public void process(ElementProcessor p) {
        p.process(this);
    }

    class RepetitionIterator
    extends ScriptElementContainer.SECIterator {
        int count;

        RepetitionIterator() {
            super(Repetition.this);
            this.count = 0;
            this.cur = Repetition.this.firstChild;
        }

        @Override
        public boolean hasNext() {
            return this.cur != null || this.count < Repetition.this.repeatCount || Repetition.this.repeatCount < 0;
        }

        @Override
        public ScriptElement next() {
            if (this.cur != null) {
                ScriptElement ret = this.cur;
                this.cur = this.cur.nextSibling;
                return ret;
            }
            if (++this.count < Repetition.this.repeatCount || Repetition.this.repeatCount < 0) {
                ScriptElement ret = Repetition.this.firstChild;
                this.cur = ret.nextSibling;
                return ret;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("no ScriptElement removal supported");
        }
    }
}

