/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.TraceElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Trace<T>
extends ListenerAdapter
implements Iterable<T> {
    TraceElement<T> lastElement;
    TraceElement<T> lastTransition;
    HashMap<Integer, TraceElement<T>> storedTransition;

    @Override
    public Iterator<T> iterator() {
        return new TraceIterator();
    }

    public void addOp(T o) {
        TraceElement<T> op = new TraceElement<T>(o);
        if (this.lastElement == null) {
            this.lastElement = op;
        } else {
            assert (this.lastElement.stateId == 0);
            op.prevElement = this.lastElement;
            this.lastElement = op;
        }
    }

    public T getLastOp() {
        if (this.lastElement != null) {
            return this.lastElement.getOp();
        }
        return null;
    }

    public int size() {
        int n = 0;
        TraceElement<T> te = this.lastElement;
        while (te != null) {
            ++n;
            te = te.prevElement;
        }
        return n;
    }

    public List<T> getOps() {
        ArrayList<Object> list = new ArrayList<Object>();
        TraceElement<T> te = this.lastElement;
        while (te != null) {
            list.add(te.getOp());
            te = te.prevElement;
        }
        int i = 0;
        for (int j = list.size() - 1; i < j; ++i, --j) {
            Object tmp = list.get(j);
            list.set(j, list.get(i));
            list.set(i, tmp);
        }
        return list;
    }

    @Override
    public void stateAdvanced(Search search) {
        if (search.isNewState() && this.lastElement != null) {
            int stateId = search.getStateNumber();
            TraceElement<T> op = this.lastElement;
            while (op != null) {
                assert (op.stateId == 0);
                op.stateId = stateId;
                op = op.prevElement;
            }
            this.lastElement.prevTransition = this.lastTransition;
            this.lastTransition = this.lastElement;
        }
        this.lastElement = null;
    }

    @Override
    public void stateBacktracked(Search search) {
        int stateId = search.getStateNumber();
        while (this.lastTransition != null && this.lastTransition.stateId > stateId) {
            this.lastTransition = this.lastTransition.prevTransition;
        }
        this.lastElement = null;
    }

    @Override
    public void stateStored(Search search) {
        if (this.storedTransition == null) {
            this.storedTransition = new HashMap();
        }
        this.storedTransition.put(search.getStateNumber(), this.lastTransition);
    }

    @Override
    public void stateRestored(Search search) {
        int stateId = search.getStateNumber();
        TraceElement<T> op = this.storedTransition.get(stateId);
        if (op != null) {
            this.lastTransition = op;
            this.storedTransition.remove(stateId);
        }
    }

    public Trace clone() {
        Object e0 = null;
        Object eLast = null;
        TraceElement<T> e = this.lastElement;
        while (e != null) {
            Object ec = e.clone();
            if (eLast != null) {
                ((TraceElement)eLast).prevElement = ec;
                eLast = ec;
            } else {
                e0 = eLast = ec;
            }
            e = e.prevElement;
        }
        Trace<T> t = new Trace<T>();
        t.lastElement = e0;
        return t;
    }

    class TraceIterator
    implements Iterator<T> {
        TraceElement<T> cur;

        TraceIterator() {
            this.cur = Trace.this.lastElement;
        }

        @Override
        public boolean hasNext() {
            return this.cur != null;
        }

        @Override
        public T next() {
            if (this.cur != null) {
                Object op = this.cur.op;
                this.cur = this.cur.prevElement;
                return op;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("TraceElement removal not supported");
        }
    }
}

