/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringSetMatcher {
    boolean hasAnyPattern;
    Pattern[] pattern;
    Matcher[] matcher;

    public static boolean isMatch(String s, StringSetMatcher includes, StringSetMatcher excludes) {
        if (excludes != null && excludes.matchesAny(s)) {
            return false;
        }
        return includes == null || includes.matchesAny(s);
    }

    public static StringSetMatcher getNonEmpty(String[] set) {
        if (set != null && set.length > 0) {
            return new StringSetMatcher(set);
        }
        return null;
    }

    public StringSetMatcher(String ... set) {
        int n = set.length;
        this.pattern = new Pattern[n];
        this.matcher = new Matcher[n];
        for (int i = 0; i < n; ++i) {
            Pattern p;
            String s = set[i];
            if (s.equals("*")) {
                this.hasAnyPattern = true;
                continue;
            }
            this.pattern[i] = p = this.createPattern(s);
            this.matcher[i] = p.matcher("");
        }
    }

    public String toString() {
        int n = 0;
        StringBuilder sb = new StringBuilder(64);
        sb.append("StringSetMatcher [regex_patterns=");
        if (this.hasAnyPattern) {
            sb.append(".*");
            ++n;
        }
        for (int i = 0; i < this.pattern.length; ++i) {
            if (this.pattern[i] == null) continue;
            if (n++ > 0) {
                sb.append(',');
            }
            sb.append(this.pattern[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public void addPattern(String s) {
        if (s.equals("*")) {
            this.hasAnyPattern = true;
        } else {
            int n = this.pattern.length;
            Pattern[] pNew = new Pattern[n + 1];
            System.arraycopy(this.pattern, 0, pNew, 0, n);
            pNew[n] = this.createPattern(s);
            Matcher[] mNew = new Matcher[pNew.length];
            System.arraycopy(this.matcher, 0, mNew, 0, n);
            mNew[n] = pNew[n].matcher("");
            this.pattern = pNew;
            this.matcher = mNew;
        }
    }

    Pattern createPattern(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block7: for (int j = 0; j < len; ++j) {
            char c = s.charAt(j);
            switch (c) {
                case '.': {
                    sb.append("\\.");
                    continue block7;
                }
                case '$': {
                    sb.append("\\$");
                    continue block7;
                }
                case '[': {
                    sb.append("\\[");
                    continue block7;
                }
                case ']': {
                    sb.append("\\]");
                    continue block7;
                }
                case '*': {
                    sb.append(".*");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        Pattern p = Pattern.compile(sb.toString());
        return p;
    }

    public boolean matchesAny(String s) {
        if (s != null) {
            if (this.hasAnyPattern) {
                return true;
            }
            for (int i = 0; i < this.pattern.length; ++i) {
                Pattern p = this.pattern[i];
                Matcher m = this.matcher[i];
                m.reset(s);
                if (!m.matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchesAll(String s) {
        if (s != null) {
            if (this.hasAnyPattern && this.pattern.length == 1) {
                return true;
            }
            for (int i = 0; i < this.pattern.length; ++i) {
                Pattern p = this.pattern[i];
                Matcher m = this.matcher[i];
                m.reset(s);
                if (m.matches()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean allMatch(String[] set) {
        if (this.hasAnyPattern) {
            return true;
        }
        for (int i = 0; i < set.length; ++i) {
            if (this.matchesAny(set[i])) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String[] s;
        String[] p = args[0].split(":");
        StringSetMatcher sm = new StringSetMatcher(p);
        if (sm.matchesAny((s = args[1].split(":"))[0])) {
            System.out.println("Bingo, \"" + s[0] + "\" matches " + sm);
        } else {
            System.out.println("nope, \"" + s[0] + "\" doesn't match " + sm);
        }
    }
}

