/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.ExpandableStringReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StringExpander {
    ArrayList<String> expandWithSequence(StringBuilder seq, ArrayList<String> list) {
        if (seq.length() > 0) {
            int len = list.size();
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    list.set(i, list.get(i) + seq);
                }
            } else {
                list.add(seq.toString());
            }
        }
        return list;
    }

    ArrayList<String> expandWithSet(StringBuilder set, ArrayList<String> list) {
        int sl = set.length();
        if (sl > 0) {
            int len = list.size();
            if (len > 0) {
                ArrayList<String> newList = new ArrayList<String>(len * sl);
                for (int j = 0; j < len; ++j) {
                    String e = list.get(j);
                    for (int i = 0; i < sl; ++i) {
                        newList.add(e + set.charAt(i));
                    }
                }
                list = newList;
            } else {
                for (int i = 0; i < sl; ++i) {
                    list.add(Character.toString(set.charAt(i)));
                }
            }
        }
        return list;
    }

    StringBuilder getCharSet(ExpandableStringReader r) throws IOException {
        int c;
        StringBuilder set = new StringBuilder();
        while ((c = r.read()) != -1 && c != -3) {
            if (c == 45) {
                c = r.read();
                if (c == -1 || c == -3) continue;
                for (int p = r.last + 1; p <= c; ++p) {
                    set.append((char)p);
                }
                continue;
            }
            set.append((char)c);
        }
        return set;
    }

    List<String> expandCharSets(String s) {
        ArrayList<String> list = new ArrayList<String>();
        ExpandableStringReader r = new ExpandableStringReader(s);
        StringBuilder seq = new StringBuilder();
        try {
            int c;
            while ((c = r.read()) != -1) {
                if (c == -2) {
                    list = this.expandWithSequence(seq, list);
                    StringBuilder set = this.getCharSet(r);
                    list = this.expandWithSet(set, list);
                    seq.setLength(0);
                    continue;
                }
                seq.append((char)c);
            }
            list = this.expandWithSequence(seq, list);
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        return list;
    }

    public List<String> expand(String s) {
        ArrayList<String> list = new ArrayList<String>();
        for (String sub : this.getAlternatives(s)) {
            list.addAll(this.expandCharSets(sub));
        }
        return list;
    }

    List<String> getAlternatives(String s) {
        ExpandableStringReader r = new ExpandableStringReader(s);
        ArrayList<String> list = new ArrayList<String>();
        boolean inLiteral = false;
        boolean inLiteral1 = false;
        try {
            String ss;
            int i = 0;
            int j = 0;
            int c = r.read();
            while (c != -1) {
                inLiteral = inLiteral1;
                i = r.getPosition();
                if (c == -4) {
                    ss = s.substring(j, i);
                    list.add(inLiteral ? this.quote(ss) : ss);
                    j = i + 1;
                } else if (c == 34 || c == 39) {
                    inLiteral1 = !inLiteral1;
                }
                c = r.read();
            }
            if (i >= j) {
                ss = s.substring(j);
                list.add(inLiteral ? this.quote(ss) : ss);
            }
        }
        catch (IOException x) {
            // empty catch block
        }
        return list;
    }

    String quote(String s) {
        int l;
        char c = s.charAt(0);
        if (c != '\"') {
            s = c == '\'' ? "\"" + s.substring(1) : "\"" + s;
        }
        if ((c = s.charAt(l = s.length() - 1)) != '\"') {
            s = c == '\'' ? s.substring(0, l) + '\"' : s + '\"';
        }
        return s;
    }

    public static void main(String[] args) {
        StringExpander ex = new StringExpander();
        for (String s : ex.expand(args[0])) {
            System.out.println(s);
        }
    }
}

