/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.DynamicObjectArray;
import gov.nasa.jpf.util.StateExtensionClient;

public class StateExtensionListener<T>
extends ListenerAdapter {
    StateExtensionClient<T> client;
    DynamicObjectArray<T> states;

    public StateExtensionListener(StateExtensionClient<T> cli) {
        this.client = cli;
        this.states = new DynamicObjectArray();
    }

    @Override
    public void stateAdvanced(Search search) {
        int idx = search.getStateNumber();
        if (idx >= 0) {
            T se = this.client.getStateExtension();
            this.states.set(idx, se);
        }
    }

    @Override
    public void stateBacktracked(Search search) {
        int idx = search.getStateNumber();
        if (idx >= 0) {
            T se = this.states.get(idx);
            this.client.restore(se);
        }
    }

    @Override
    public void stateRestored(Search search) {
        int idx = search.getStateNumber();
        if (idx >= 0) {
            T se = this.states.get(idx);
            this.client.restore(se);
            SystemState ss = search.getVM().getSystemState();
            ChoiceGenerator<?> cgNext = ss.getNextChoiceGenerator();
            cgNext.reset();
        }
    }
}

