/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import java.util.Arrays;

public class SparseObjVector<E> {
    private static final boolean DEBUG = true;
    static final double MAX_LOAD_WIPE = 0.6;
    static final double MAX_LOAD_REHASH = 0.4;
    static final int DEFAULT_POW = 10;
    int[] idxTable;
    Object[] valTable;
    int count;
    int pow;
    int mask;
    int nextWipe;
    int nextRehash;

    public SparseObjVector() {
        this(10);
    }

    public SparseObjVector(int pow) {
        this.pow = pow;
        this.newTable();
        this.count = 0;
        this.mask = this.valTable.length - 1;
        this.nextWipe = (int)(0.6 * (double)this.mask);
        this.nextRehash = (int)(0.4 * (double)this.mask);
    }

    protected void newTable() {
        this.valTable = new Object[1 << this.pow];
        this.idxTable = new int[1 << this.pow];
        Arrays.fill(this.idxTable, Integer.MIN_VALUE);
    }

    protected int mix(int x) {
        int y = -1640531527;
        y += ((x ^= 0x510FB60D) >> 8) + (x << 3);
        return y - (x ^= (y >> 5) + (y << 2));
    }

    public E get(int idx) {
        int code = this.mix(idx);
        int pos = code & this.mask;
        int delta = code >> this.pow - 1 | 1;
        int oidx = pos;
        while (true) {
            int tidx;
            if ((tidx = this.idxTable[pos]) == Integer.MIN_VALUE) {
                return null;
            }
            if (tidx == idx) {
                return (E)this.valTable[pos];
            }
            pos = pos + delta & this.mask;
            assert (pos != oidx);
        }
    }

    public void set(int idx, E e) {
        int tidx;
        int code = this.mix(idx);
        int pos = code & this.mask;
        int delta = code >> this.pow - 1 | 1;
        int oidx = pos;
        while ((tidx = this.idxTable[pos]) != Integer.MIN_VALUE) {
            if (tidx == idx) {
                this.valTable[pos] = e;
                return;
            }
            pos = pos + delta & this.mask;
            assert (pos != oidx);
        }
        ++this.count;
        if (this.count >= this.nextWipe) {
            int oldCount = this.count;
            this.count = 0;
            for (int i = 0; i < this.idxTable.length; ++i) {
                if (this.idxTable[i] == Integer.MIN_VALUE || this.valTable[i] == null) continue;
                ++this.count;
            }
            if (this.count >= this.nextRehash) {
                ++this.pow;
                System.out.println("Rehash to capacity: 2**" + this.pow);
            } else {
                System.out.println("Rehash reclaiming this many nulls: " + (oldCount - this.count));
            }
            Object[] oldValTable = this.valTable;
            int[] oldIdxTable = this.idxTable;
            this.newTable();
            this.mask = this.idxTable.length - 1;
            this.nextWipe = (int)(0.6 * (double)this.mask);
            this.nextRehash = (int)(0.4 * (double)this.mask);
            int oldLen = oldIdxTable.length;
            for (int i = 0; i < oldLen; ++i) {
                Object o;
                int tidx2 = oldIdxTable[i];
                if (tidx2 == Integer.MIN_VALUE || (o = oldValTable[i]) == null) continue;
                code = this.mix(tidx2);
                pos = code & this.mask;
                delta = code >> this.pow - 1 | 1;
                while (this.idxTable[pos] != Integer.MIN_VALUE) {
                    pos = pos + delta & this.mask;
                }
                this.idxTable[pos] = tidx2;
                this.valTable[pos] = o;
            }
            code = this.mix(idx);
            pos = code & this.mask;
            delta = code >> this.pow - 1 | 1;
            while (this.idxTable[pos] != Integer.MIN_VALUE) {
                pos = pos + delta & this.mask;
            }
        }
        this.idxTable[pos] = idx;
        this.valTable[pos] = e;
    }

    public void remove(int idx) {
        this.set(idx, null);
    }

    public static void main(String[] args) {
        Integer v;
        int i;
        SparseObjVector<Integer> vect = new SparseObjVector<Integer>(3);
        for (i = -4200; i < 4200; i += 10) {
            vect.set(i, new Integer(i));
        }
        for (i = -4200; i < 4200; i += 10) {
            v = (Integer)vect.get(i);
            if (v == i) continue;
            throw new IllegalStateException();
        }
        for (i = -4205; i < 4200; i += 10) {
            v = (Integer)vect.get(i);
            if (v == null) continue;
            throw new IllegalStateException();
        }
        for (i = -4201; i < 4200; i += 10) {
            vect.set(i, new Integer(i));
        }
        for (i = -4200; i < 4200; i += 10) {
            v = (Integer)vect.get(i);
            if (v == i) continue;
            throw new IllegalStateException();
        }
        for (i = -4201; i < 4200; i += 10) {
            v = (Integer)vect.get(i);
            if (v == i) continue;
            throw new IllegalStateException();
        }
        for (i = -4200; i < 4200; i += 10) {
            vect.remove(i);
        }
        for (i = -4201; i < 4200; i += 10) {
            v = (Integer)vect.get(i);
            if (v == i) continue;
            throw new IllegalStateException();
        }
        for (i = -4200; i < 4200; i += 10) {
            v = (Integer)vect.get(i);
            if (v == null) continue;
            throw new IllegalStateException();
        }
        for (i = -4203; i < 4200; i += 10) {
            vect.set(i, new Integer(i));
        }
        for (i = -4204; i < 4200; i += 10) {
            vect.set(i, new Integer(i));
        }
    }
}

