/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.Cloner;
import gov.nasa.jpf.util.IndexIterator;
import gov.nasa.jpf.util.Transformer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public final class SparseClusterArray<E>
implements Iterable<E> {
    static final int CHUNK_BITS = 11;
    static final int CHUNK_SIZE = 2048;
    static final int N_ELEM = 2048;
    static final int ELEM_MASK = 2047;
    static final int BM_ENTRIES = 32;
    static final int SEG_BITS = 7;
    static final int N_SEG = 128;
    static final int SEG_MASK = 127;
    static final int S1 = 25;
    static final int S2 = 18;
    static final int S3 = 11;
    static final int CHUNK_BASEMASK = -128;
    Root root = new Root();
    Chunk lastChunk;
    Chunk head;
    int nSet;
    boolean trackChanges = false;
    Entry changes;
    static final int MAX_ROUNDS = 100;
    static final int MAX_N = 10000;
    static final int MAX_T = 6;

    void sortInChunk(Chunk newChunk) {
        if (this.head == null) {
            this.head = newChunk;
        } else {
            int base = newChunk.base;
            if (base < this.head.base) {
                newChunk.next = this.head;
                this.head = newChunk;
            } else {
                Chunk cprev = this.head;
                Chunk c = cprev.next;
                while (c != null) {
                    if (base < c.base) {
                        newChunk.next = c;
                        break;
                    }
                    cprev = c;
                    c = c.next;
                }
                cprev.next = newChunk;
            }
        }
    }

    public E get(int i) {
        ChunkNode l2;
        Chunk l3 = this.lastChunk;
        if (l3 != null && l3.base == (i & 0xFFFFFF80)) {
            return (E)l3.elements[i & 0x7FF];
        }
        int j = i >>> 25;
        Node l1 = this.root.seg[j];
        if (l1 != null && (l2 = l1.seg[j = i >>> 18 & 0x7F]) != null && (l3 = l2.seg[j = i >>> 11 & 0x7F]) != null) {
            this.lastChunk = l3;
            return (E)l3.elements[i & 0x7FF];
        }
        this.lastChunk = null;
        return null;
    }

    public void set(int i, E e) {
        int v;
        int u;
        long[] bm;
        boolean isSet;
        int j;
        Chunk l3 = this.lastChunk;
        if (l3 == null || l3.base != (i & 0xFFFFFF80)) {
            j = i >>> 25;
            Node l1 = this.root.seg[j];
            if (l1 == null) {
                ChunkNode l2;
                this.root.seg[j] = l1 = new Node();
                j = i >>> 18 & 0x7F;
                l1.seg[j] = l2 = new ChunkNode();
                j = i >>> 11 & 0x7F;
                l3 = new Chunk(i & 0xFFFFF800);
                this.sortInChunk(l3);
                l2.seg[j] = l3;
            } else {
                j = i >>> 18 & 0x7F;
                ChunkNode l2 = l1.seg[j];
                if (l2 == null) {
                    l1.seg[j] = l2 = new ChunkNode();
                    j = i >>> 11 & 0x7F;
                    l3 = new Chunk(i & 0xFFFFF800);
                    this.sortInChunk(l3);
                    l2.seg[j] = l3;
                } else {
                    j = i >>> 11 & 0x7F;
                    l3 = l2.seg[j];
                    if (l3 == null) {
                        l3 = new Chunk(i & 0xFFFFF800);
                        this.sortInChunk(l3);
                        l2.seg[j] = l3;
                    }
                }
            }
            this.lastChunk = l3;
        }
        boolean bl = isSet = ((bm = l3.bitmap)[u = (j = i & 0x7FF) >> 6] >> (v = i & 0x3F) & 1L) > 0L;
        if (this.trackChanges) {
            Entry entry = new Entry(i, l3.elements[j]);
            entry.next = this.changes;
            this.changes = entry;
        }
        l3.elements[j] = e;
        if (e != null) {
            if (!isSet) {
                int n = u;
                bm[n] = bm[n] | 1L << v;
                ++this.nSet;
            }
        } else if (isSet) {
            int n = u;
            bm[n] = bm[n] & (1L << v ^ 0xFFFFFFFFFFFFFFFFL);
            --this.nSet;
        }
    }

    public int firstNullIndex(int i, int length) {
        ChunkNode l2;
        int j;
        Node l1;
        Chunk l3 = this.lastChunk;
        int iMax = i + length;
        if ((l3 == null || l3.base != (i & 0xFFFFFF80)) && (l1 = this.root.seg[j = i >>> 25]) != null && (l2 = l1.seg[j = i >>> 18 & 0x7F]) != null) {
            j = i >>> 11 & 0x7F;
            l3 = l2.seg[j];
        }
        int k = i & 0xFFFFFF80;
        while (l3 != null) {
            if ((k = l3.nextClearBit(k)) >= 0) {
                this.lastChunk = l3;
                i = l3.base + k;
                return i < iMax ? i : -1;
            }
            Chunk l3Next = l3.next;
            int nextBase = l3.base + 2048;
            if (l3Next != null && l3Next.base == nextBase) {
                if (nextBase < iMax) {
                    l3 = l3Next;
                    k = 0;
                    continue;
                }
                return -1;
            }
            this.lastChunk = null;
            return nextBase < iMax ? nextBase : -1;
        }
        this.lastChunk = null;
        return i;
    }

    public SparseClusterArray<E> deepCopy(Cloner<E> elementCloner) {
        SparseClusterArray<E> a = new SparseClusterArray<E>();
        a.nSet = this.nSet;
        Node[] newNodeList = a.root.seg;
        Node newNode = null;
        ChunkNode newChunkNode = null;
        Chunk newChunk = null;
        Chunk lastChunk = null;
        Node[] nList = this.root.seg;
        try {
            int i1 = 0;
            for (int i = 0; i < nList.length; ++i) {
                Node n = nList[i];
                if (n != null) {
                    ChunkNode[] cnList = n.seg;
                    int j1 = 0;
                    for (int j = 0; j < cnList.length; ++j) {
                        ChunkNode cn = cnList[j];
                        if (cn != null) {
                            Chunk[] cList = cn.seg;
                            int k1 = 0;
                            for (int k = 0; k < cList.length; ++k) {
                                Chunk c = cList[k];
                                if (c == null || c.isEmpty()) continue;
                                newChunk = c.deepCopy(elementCloner);
                                if (lastChunk == null) {
                                    a.head = lastChunk = newChunk;
                                } else {
                                    lastChunk.next = newChunk;
                                    lastChunk = newChunk;
                                }
                                if (newNode == null) {
                                    newNode = new Node();
                                    k1 = 0;
                                    j1 = 0;
                                    newNodeList[i1++] = newNode;
                                }
                                if (newChunkNode == null) {
                                    newChunkNode = new ChunkNode();
                                    newNode.seg[j1++] = newChunkNode;
                                }
                                newChunkNode.seg[k1++] = newChunk;
                            }
                        }
                        newChunkNode = null;
                    }
                }
                newNode = null;
            }
        }
        catch (CloneNotSupportedException cnsx) {
            return null;
        }
        return a;
    }

    public <T> Snapshot<E, T> getSnapshot(Transformer<E, T> transformer) {
        int n = this.nSet;
        Snapshot snap = new Snapshot();
        int j = 0;
        Chunk c = this.head;
        while (c != null) {
            int base = c.base;
            int i = -1;
            while ((i = c.nextSetBit(i + 1)) >= 0) {
                T val = transformer.transform(c.elements[i]);
                snap.add(base + i, val);
                if (++j < n) continue;
                break;
            }
            c = c.next;
        }
        return snap;
    }

    public <T> void restoreSnapshot(Snapshot<E, T> snap, Transformer<E, T> transformer) {
        this.clear();
        Entry e = snap.first;
        while (e != null) {
            E obj = transformer.restore(e.value);
            this.set(e.index, obj);
            e = e.next;
        }
    }

    public void clear() {
        this.lastChunk = null;
        this.head = null;
        this.root = new Root();
        this.nSet = 0;
        this.changes = null;
    }

    public void trackChanges() {
        this.trackChanges = true;
    }

    public void stopTrackingChanges() {
        this.trackChanges = false;
    }

    public boolean isTrackingChanges() {
        return this.trackChanges;
    }

    public Entry<E> getChanges() {
        return this.changes;
    }

    public void resetChanges() {
        this.changes = null;
    }

    public void revertChanges(Entry<E> changes) {
        Entry<E> e = changes;
        while (e != null) {
            this.set(e.index, e.value);
            e = e.next;
        }
    }

    public String toString() {
        return "SparseClusterArray [nSet=" + this.nSet + ']';
    }

    public int numberOfChunks() {
        int n = 0;
        Chunk c = this.head;
        while (c != null) {
            ++n;
            c = c.next;
        }
        return n;
    }

    public IndexIterator getElementIndexIterator(int startIdx) {
        return new ElementIndexIterator(startIdx);
    }

    @Override
    public Iterator<E> iterator() {
        return new ElementIterator();
    }

    public int cardinality() {
        return this.nSet;
    }

    public static void main(String[] args) {
        SparseClusterArray.testChanges();
    }

    static void testBasic() {
        SparseClusterArray<Integer> arr = new SparseClusterArray<Integer>();
        int ref = 0x200002A;
        arr.set(ref, new Integer(ref));
        Object o = arr.get(ref);
        System.out.println(o);
        ref = 0x4000000;
        arr.set(ref, new Integer(ref));
        System.out.println("n = " + arr.cardinality());
        for (Object e : arr) {
            System.out.println(e);
        }
    }

    static void testNextNull() {
        int i;
        Integer e = new Integer(42);
        SparseClusterArray<Integer> arr = new SparseClusterArray<Integer>();
        int limit = 10000000;
        arr.set(0, e);
        int k = arr.firstNullIndex(0, limit);
        System.out.println("k=" + k);
        arr.set(0, null);
        k = arr.firstNullIndex(0, limit);
        System.out.println("k=" + k);
        for (i = 0; i < 512; ++i) {
            arr.set(i, e);
        }
        long t1 = System.currentTimeMillis();
        for (int j = 0; j < 100000; ++j) {
            k = arr.firstNullIndex(0, limit);
        }
        long t2 = System.currentTimeMillis();
        System.out.println("k=" + k + ", 100000 lookups in: " + (t2 - t1));
        while (i < 2048) {
            arr.set(i, e);
            ++i;
        }
        k = arr.firstNullIndex(0, limit);
        System.out.println("k=" + k);
        k = arr.firstNullIndex(0, 2048);
        System.out.println("k=" + k);
        arr.set(2048, e);
        arr.set(2048, null);
        k = arr.firstNullIndex(0, limit);
        System.out.println("k=" + k);
        while (i < 2500) {
            arr.set(i, e);
            ++i;
        }
        k = arr.firstNullIndex(0, limit);
        System.out.println("k=" + k);
    }

    static void testClone() {
        SparseClusterArray<Integer> arr = new SparseClusterArray<Integer>();
        arr.set(0, new Integer(0));
        arr.set(42, new Integer(42));
        arr.set(6762, new Integer(6762));
        arr.set(6762, null);
        Cloner<Integer> cloner = new Cloner<Integer>(){

            @Override
            public Integer clone(Integer other) {
                return new Integer(other);
            }
        };
        SparseClusterArray<Integer> newArr = arr.deepCopy(cloner);
        for (Integer i : newArr) {
            System.out.println(i);
        }
    }

    static void testSnapshot() {
        SparseClusterArray<Integer> arr = new SparseClusterArray<Integer>();
        arr.set(0, new Integer(0));
        arr.set(42, new Integer(42));
        arr.set(4095, new Integer(4095));
        arr.set(4096, new Integer(4096));
        arr.set(7777, new Integer(7777));
        arr.set(67620, new Integer(67620));
        arr.set(67620, null);
        arr.set(7162827, new Integer(7162827));
        Transformer<Integer, String> transformer = new Transformer<Integer, String>(){

            @Override
            public String transform(Integer n) {
                return n.toString();
            }

            @Override
            public Integer restore(String s) {
                return new Integer(Integer.parseInt(s));
            }
        };
        Snapshot<Integer, String> snap = arr.getSnapshot(transformer);
        Entry e = snap.first;
        while (e != null) {
            System.out.println("a[" + e.index + "] = " + e.value);
            e = e.next;
        }
        arr.set(42, null);
        arr.set(87, new Integer(87));
        arr.set(7162827, new Integer(-1));
        arr.restoreSnapshot(snap, transformer);
        for (Integer i : arr) {
            System.out.println(i);
        }
    }

    static void testChanges() {
        SparseClusterArray<Integer> arr = new SparseClusterArray<Integer>();
        arr.set(42, new Integer(42));
        arr.set(6276, new Integer(6276));
        arr.trackChanges();
        arr.set(0, new Integer(0));
        arr.set(42, new Integer(-1));
        arr.set(4095, new Integer(4095));
        arr.set(4096, new Integer(4096));
        arr.set(7777, new Integer(7777));
        arr.set(7162827, new Integer(7162827));
        Entry changes = arr.getChanges();
        arr.revertChanges(changes);
        for (Integer i : arr) {
            System.out.println(i);
        }
    }

    static void testSparseClusterArray() {
        Random r = new Random(0L);
        Object elem = new Object();
        int n = 0;
        long t1 = System.currentTimeMillis();
        SparseClusterArray<Object> arr = new SparseClusterArray<Object>();
        for (int i = 0; i < 100; ++i) {
            int n2 = r.nextInt(6) << 25;
            for (int j = 0; j < 10000; ++j) {
                arr.set(n2 |= r.nextInt(10000), elem);
                if (arr.get(n2) != null) continue;
                throw new RuntimeException("element not set: " + i);
            }
        }
        long t2 = System.currentTimeMillis();
        System.out.println("SparseArray random write/read of " + arr.cardinality() + " elements: " + (t2 - t1));
        n = 0;
        t1 = System.currentTimeMillis();
        for (Object e : arr) {
            ++n;
        }
        t2 = System.currentTimeMillis();
        System.out.println("SparseArray iteration over " + n + " elements: " + (t2 - t1));
    }

    static void testHashMap() {
        Random r = new Random(0L);
        Object elem = new Object();
        long t1 = System.currentTimeMillis();
        HashMap<Integer, Object> arr = new HashMap<Integer, Object>();
        for (int i = 0; i < 100; ++i) {
            int ref = r.nextInt(6) << 25;
            for (int j = 0; j < 10000; ++j) {
                arr.put(ref |= r.nextInt(10000), elem);
                if (arr.get(ref) != null) continue;
                throw new RuntimeException("element not set: " + i);
            }
        }
        long t2 = System.currentTimeMillis();
        System.out.println("HashMap random write/read of " + arr.size() + " elements: " + (t2 - t1));
        int n = 0;
        t1 = System.currentTimeMillis();
        for (Object e : arr.values()) {
            ++n;
        }
        t2 = System.currentTimeMillis();
        System.out.println("HashMap iteration over " + n + " elements: " + (t2 - t1));
    }

    class ElementIndexIterator
    implements IndexIterator {
        int idx;
        int processed;
        Chunk cur;

        ElementIndexIterator(int startIdx) {
            int i;
            this.idx = i = startIdx & 0x7FF;
            Chunk c = SparseClusterArray.this.head;
            while (c != null) {
                if (c.top > i) {
                    this.cur = c;
                }
                c = c.next;
            }
        }

        @Override
        public int next() {
            Chunk c = this.cur;
            int i = this.idx;
            if (this.processed < SparseClusterArray.this.nSet) {
                while (c != null) {
                    if ((i = c.nextSetBit(i)) < 0) {
                        c = c.next;
                        i = 0;
                        continue;
                    }
                    this.cur = c;
                    this.idx = i + 1;
                    ++this.processed;
                    return i;
                }
            }
            this.cur = null;
            return -1;
        }
    }

    class ElementIterator
    implements Iterator<E> {
        int idx;
        Chunk cur;
        int nVisited;

        ElementIterator() {
            this.cur = SparseClusterArray.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.nVisited < SparseClusterArray.this.nSet;
        }

        @Override
        public E next() {
            Chunk c = this.cur;
            int i = this.idx;
            while (c != null) {
                if ((i = c.nextSetBit(i)) < 0) {
                    c = c.next;
                    i = 0;
                    continue;
                }
                this.cur = c;
                this.idx = i + 1;
                ++this.nVisited;
                return c.elements[i];
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can't remove elements from SparseClusterArray iterator");
        }
    }

    static class Chunk
    implements Cloneable {
        int base;
        int top;
        Chunk next;
        Object[] elements;
        long[] bitmap;

        Chunk() {
        }

        Chunk(int base) {
            this.base = base;
            this.top = base + 2048;
            this.elements = new Object[2048];
            this.bitmap = new long[32];
        }

        public String toString() {
            return "Chunk [base=" + this.base + ",top=" + this.top + ']';
        }

        public <E> Chunk deepCopy(Cloner<E> cloner) throws CloneNotSupportedException {
            Chunk nc = (Chunk)super.clone();
            Object[] elem = this.elements;
            Object[] e = new Object[2048];
            int i = this.nextSetBit(0);
            while (i >= 0) {
                e[i] = cloner.clone(elem[i]);
                i = this.nextSetBit(i + 1);
            }
            nc.elements = e;
            nc.bitmap = (long[])this.bitmap.clone();
            return nc;
        }

        final int nextClearBit(int iStart) {
            long[] bm = this.bitmap;
            if (iStart < 2048) {
                int j = iStart >> 6;
                long l = (bm[j] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << iStart;
                while (true) {
                    if (l != 0L) {
                        int prevHalf;
                        int n;
                        int lowHalf = (int)l;
                        if (lowHalf != 0) {
                            n = 31;
                            prevHalf = lowHalf;
                        } else {
                            n = 63;
                            prevHalf = (int)(l >>> 32);
                        }
                        lowHalf = prevHalf << 16;
                        if (lowHalf != 0) {
                            n -= 16;
                            prevHalf = lowHalf;
                        }
                        if ((lowHalf = prevHalf << 8) != 0) {
                            n -= 8;
                            prevHalf = lowHalf;
                        }
                        if ((lowHalf = prevHalf << 4) != 0) {
                            n -= 4;
                            prevHalf = lowHalf;
                        }
                        if ((lowHalf = prevHalf << 2) != 0) {
                            n -= 2;
                            prevHalf = lowHalf;
                        }
                        return (j << 6) + n - (prevHalf << 1 >>> 31);
                    }
                    if (j >= 31) break;
                    l = bm[++j] ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
            return -1;
        }

        final int nextSetBit(int iStart) {
            long[] bm = this.bitmap;
            if (iStart < 2048) {
                int j = iStart >> 6;
                long l = bm[j] & -1L << iStart;
                while (true) {
                    if (l != 0L) {
                        int prevHalf;
                        int n;
                        int lowHalf = (int)l;
                        if (lowHalf != 0) {
                            n = 31;
                            prevHalf = lowHalf;
                        } else {
                            n = 63;
                            prevHalf = (int)(l >>> 32);
                        }
                        lowHalf = prevHalf << 16;
                        if (lowHalf != 0) {
                            n -= 16;
                            prevHalf = lowHalf;
                        }
                        if ((lowHalf = prevHalf << 8) != 0) {
                            n -= 8;
                            prevHalf = lowHalf;
                        }
                        if ((lowHalf = prevHalf << 4) != 0) {
                            n -= 4;
                            prevHalf = lowHalf;
                        }
                        if ((lowHalf = prevHalf << 2) != 0) {
                            n -= 2;
                            prevHalf = lowHalf;
                        }
                        return (j << 6) + n - (prevHalf << 1 >>> 31);
                    }
                    if (j >= 31) break;
                    l = bm[++j];
                }
            }
            return -1;
        }

        public boolean isEmpty() {
            long[] bm = this.bitmap;
            if ((bm[0] | bm[1] | bm[2] | bm[3]) != 0L) {
                return false;
            }
            if ((bm[4] | bm[5] | bm[6] | bm[7]) != 0L) {
                return false;
            }
            if ((bm[8] | bm[9] | bm[10] | bm[11]) != 0L) {
                return false;
            }
            if ((bm[12] | bm[13] | bm[14] | bm[15]) != 0L) {
                return false;
            }
            if ((bm[16] | bm[17] | bm[18] | bm[19]) != 0L) {
                return false;
            }
            if ((bm[20] | bm[21] | bm[22] | bm[23]) != 0L) {
                return false;
            }
            if ((bm[24] | bm[25] | bm[26] | bm[27]) != 0L) {
                return false;
            }
            return (bm[28] | bm[29] | bm[30] | bm[31]) == 0L;
        }
    }

    static class ChunkNode {
        Chunk[] seg = new Chunk[128];

        ChunkNode() {
        }
    }

    static class Node {
        ChunkNode[] seg = new ChunkNode[128];

        Node() {
        }
    }

    static class Root {
        Node[] seg = new Node[128];

        Root() {
        }
    }

    public static class Entry<E> {
        int index;
        Object value;
        Entry<E> next;

        Entry(int index, Object value) {
            this.index = index;
            this.value = value;
        }
    }

    public static class Snapshot<T, E> {
        Entry<E> first;
        Entry<E> last;

        void add(int index, E value) {
            Entry entry = new Entry(index, value);
            if (this.first == null) {
                this.last = entry;
                this.first = this.last;
            } else {
                this.last.next = entry;
                this.last = entry;
            }
        }
    }
}

