/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.Source;

public class SourceRef {
    public String fileName;
    public int line;

    public SourceRef(String f, int l) {
        this.fileName = f == null ? "?" : f;
        this.line = l;
    }

    public String getLocationString() {
        return this.fileName + ':' + this.line;
    }

    public String getLineString() {
        Source source = Source.getSource(this.fileName);
        if (source != null) {
            return source.getLine(this.line);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SourceRef)) {
            return false;
        }
        SourceRef that = (SourceRef)o;
        if (this.fileName == null) {
            return false;
        }
        if (this.line == -1) {
            return false;
        }
        if (!this.fileName.equals(that.fileName)) {
            return false;
        }
        return this.line == that.line;
    }

    public boolean equals(String f, int l) {
        if (this.fileName == null) {
            return false;
        }
        if (this.line == -1) {
            return false;
        }
        if (!this.fileName.equals(f)) {
            return false;
        }
        return this.line == l;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void set(SourceRef sr) {
        this.fileName = sr.fileName;
        this.line = sr.line;
    }

    public String toString() {
        return this.fileName + ':' + this.line;
    }
}

