/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

public class SimplePool<E> {
    static final double MAX_LOAD = 0.7;
    static final int DEFAULT_POW = 10;
    Object[] table;
    int count;
    int pow;
    int mask;
    int nextRehash;

    public SimplePool() {
        this(10);
    }

    public SimplePool(int pow) {
        this.table = new Object[1 << pow];
        this.count = 0;
        this.pow = pow;
        this.mask = this.table.length - 1;
        this.nextRehash = (int)(0.7 * (double)this.mask);
    }

    public boolean isPooled(E e) {
        return e == null || this.query(e) != null;
    }

    public E query(E e) {
        Object o;
        if (e == null) {
            return null;
        }
        int code = e.hashCode();
        int idx = code & this.mask;
        int delta = code >> this.pow - 1 | 1;
        int oidx = idx;
        while ((o = this.table[idx]) != null) {
            if (e.equals(o)) {
                return (E)o;
            }
            idx = idx + delta & this.mask;
            assert (idx != oidx);
        }
        return null;
    }

    public E pool(E e) {
        Object o;
        if (e == null) {
            return null;
        }
        int code = e.hashCode();
        int idx = code & this.mask;
        int delta = code >> this.pow - 1 | 1;
        int oidx = idx;
        while ((o = this.table[idx]) != null) {
            if (e.equals(o)) {
                return (E)o;
            }
            idx = idx + delta & this.mask;
            assert (idx != oidx);
        }
        assert (this.table[idx] == null);
        ++this.count;
        if (this.count >= this.nextRehash) {
            Object[] oldTable = this.table;
            ++this.pow;
            this.table = new Object[1 << this.pow];
            this.mask = this.table.length - 1;
            this.nextRehash = (int)(0.7 * (double)this.mask);
            for (Object o2 : oldTable) {
                if (o2 == null) continue;
                code = o2.hashCode();
                idx = code & this.mask;
                delta = code >> this.pow - 1 | 1;
                while (this.table[idx] != null) {
                    idx = idx + delta & this.mask;
                }
                this.table[idx] = o2;
            }
            code = e.hashCode();
            idx = code & this.mask;
            delta = code >> this.pow - 1 | 1;
            while (this.table[idx] != null) {
                idx = idx + delta & this.mask;
            }
        }
        this.table[idx] = e;
        return e;
    }

    public boolean isMember(E e) {
        return this.query(e) != null;
    }

    public void add(E e) {
        this.pool(e);
    }

    public static void main(String[] args) {
        Integer p;
        Integer o;
        int i;
        SimplePool<Integer> pool = new SimplePool<Integer>(4);
        for (i = 0; i < 1000000; i += 42) {
            o = new Integer(i);
            p = pool.pool(o);
            if (o != p) {
                throw new RuntimeException();
            }
            Integer q = pool.pool(p);
            if (q == p) continue;
            throw new RuntimeException();
        }
        for (i = 0; i < 1000000; i += 42) {
            o = new Integer(i);
            p = pool.pool(o);
            if (o == p) {
                throw new RuntimeException();
            }
            if (o.equals(p)) continue;
            throw new RuntimeException();
        }
        for (i = 1; i < 1000000; i += 42) {
            o = new Integer(i);
            p = pool.pool(o);
            if (o == p) continue;
            throw new RuntimeException();
        }
    }
}

