/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RepositoryEntry {
    static HashMap<String, RepositoryEntry> dict = new HashMap();
    String fileName;
    String repositoryType;
    String repository;
    String revision;

    public static RepositoryEntry getRepositoryEntry(String fullFileName) {
        RepositoryEntry e = dict.get(fullFileName);
        if (e != null || (e = RepositoryEntry.getSvnRepositoryEntry(fullFileName)) == null) {
            // empty if block
        }
        dict.put(fullFileName, e);
        return e;
    }

    static RepositoryEntry getSvnRepositoryEntry(String fullFileName) {
        File f = new File(fullFileName);
        String fname = f.getName();
        String dName = f.getParent();
        File fEntries = new File(dName + File.separatorChar + ".svn" + File.separatorChar + "entries");
        if (fEntries.exists()) {
            String repository = "?";
            String revision = "?";
            Pattern pName = Pattern.compile(" *name=\"([a-zA-Z0-9.]+)\"");
            Pattern pRep = Pattern.compile(" *url=\"([a-zA-Z0-9.:/\\-]+)\"");
            Pattern pRev = Pattern.compile(" *committed-rev=\"([0-9]+)\"");
            try {
                BufferedReader r = new BufferedReader(new FileReader(fEntries));
                String line = r.readLine();
                while (line != null) {
                    Matcher mRep = pRep.matcher(line);
                    if (mRep.matches()) {
                        repository = mRep.group(1);
                    } else {
                        Matcher mRev = pRev.matcher(line);
                        if (mRev.matches()) {
                            revision = mRev.group(1);
                        } else {
                            Matcher mName = pName.matcher(line);
                            if (mName.matches() && mName.group(1).equals(fname)) {
                                return new RepositoryEntry(fname, "svn", repository, revision);
                            }
                        }
                    }
                    line = r.readLine();
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return null;
    }

    public RepositoryEntry(String fileName, String repositoryType, String repository, String revision) {
        this.fileName = fileName;
        this.repositoryType = repositoryType;
        this.repository = repository;
        this.revision = revision;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getRepositoryType() {
        return this.repositoryType;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getRevision() {
        return this.revision;
    }
}

