/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.Growth;
import gov.nasa.jpf.util.ObjArray;
import gov.nasa.jpf.util.ReadOnlyObjList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ObjVector<E>
implements ReadOnlyObjList<E>,
Cloneable {
    public static final int defaultInitCap = 40;
    protected int size;
    protected Object[] data;
    protected Growth growth;

    public ObjVector(Growth initGrowth, int initCap) {
        this.growth = initGrowth;
        this.data = new Object[initCap];
        this.size = 0;
    }

    public ObjVector(Growth initGrowth) {
        this(initGrowth, 40);
    }

    public ObjVector(int initCap) {
        this(Growth.defaultGrowth, initCap);
    }

    public ObjVector() {
        this(Growth.defaultGrowth, 40);
    }

    public <F extends E> ObjVector(F[] init) {
        this(init.length);
        this.append(init);
    }

    public <F extends E> ObjVector(ObjVector<F> from) {
        this.data = new Object[from.data.length];
        this.size = from.size;
        this.growth = from.growth;
        System.arraycopy(from.data, 0, this.data, 0, this.size);
    }

    public void add(E x) {
        if (this.size >= this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.data[this.size] = x;
        ++this.size;
    }

    public void addNulls(int length) {
        int newSize = this.size + length;
        if (newSize > this.data.length) {
            this.ensureCapacity(this.size + length);
        }
        for (int i = this.size; i < newSize; ++i) {
            this.data[i] = null;
        }
        this.size = newSize;
    }

    public <F extends E> void append(F[] x) {
        if (this.size + x.length > this.data.length) {
            this.ensureCapacity(this.size + x.length);
        }
        System.arraycopy(x, 0, this.data, this.size, x.length);
        this.size += x.length;
    }

    public <F extends E> void append(F[] x, int pos, int len) {
        if (this.size + len > this.data.length) {
            this.ensureCapacity(this.size + len);
        }
        System.arraycopy(x, pos, this.data, this.size, len);
        this.size += len;
    }

    public <F extends E> void append(ObjVector<F> x) {
        if (this.size + x.size > this.data.length) {
            this.ensureCapacity(this.size + x.size);
        }
        System.arraycopy(x.data, 0, this.data, this.size, x.size);
        this.size += x.size;
    }

    public <F extends E> void append(ObjArray<F> x) {
        this.append(x.data);
    }

    public <F extends E> void addAll(Iterable<F> x) {
        if (x instanceof ObjVector) {
            this.append((ObjVector)x);
            return;
        }
        if (x instanceof ObjArray) {
            this.append((ObjArray)x);
            return;
        }
        if (x == null) {
            return;
        }
        for (F e : x) {
            this.add(e);
        }
    }

    @Override
    public E get(int idx) {
        if (idx >= this.size) {
            return null;
        }
        return (E)this.data[idx];
    }

    public void set(int idx, E v) {
        this.ensureSize(idx + 1);
        this.data[idx] = v;
    }

    public <F> F[] toArray(F[] dst) {
        System.arraycopy(this.data, 0, dst, 0, this.size);
        return dst;
    }

    public ObjArray<E> toObjArray() {
        ObjArray dst = new ObjArray(this.size);
        System.arraycopy(this.data, 0, dst.data, 0, this.size);
        return dst;
    }

    public int dumpTo(Object[] dst, int pos) {
        System.arraycopy(this.data, 0, dst, pos, this.size);
        return pos + this.size;
    }

    public ObjVector<E> clone() {
        return new ObjVector<E>(this);
    }

    public void squeeze() {
        while (this.size > 0 && this.data[this.size - 1] == null) {
            --this.size;
        }
    }

    public void setSize(int sz) {
        if (sz > this.size) {
            this.ensureCapacity(sz);
            this.size = sz;
        } else {
            while (this.size > sz) {
                --this.size;
                this.data[this.size] = null;
            }
        }
    }

    public void clear() {
        this.setSize(0);
    }

    public int size() {
        return this.size;
    }

    @Override
    public int length() {
        return this.size;
    }

    public void ensureSize(int sz) {
        if (this.size < sz) {
            this.ensureCapacity(sz);
            this.size = sz;
        }
    }

    public void ensureCapacity(int desiredCap) {
        if (this.data.length < desiredCap) {
            Object[] newData = new Object[this.growth.grow(this.data.length, desiredCap)];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public void sort(Comparator<? super E> comp) {
        Arrays.sort(this.data, 0, this.size, comp);
    }

    public static <E> void copy(ObjVector<? extends E> src, int srcPos, ObjVector<E> dst, int dstPos, int len) {
        src.ensureCapacity(srcPos + len);
        dst.ensureSize(dstPos + len);
        System.arraycopy(src.data, srcPos, dst.data, dstPos, len);
    }

    public static <E> void copy(ObjVector<? extends E> src, int srcPos, E[] dst, int dstPos, int len) {
        src.ensureCapacity(srcPos + len);
        System.arraycopy(src.data, srcPos, dst, dstPos, len);
    }

    @Override
    public Iterator<E> iterator() {
        return new OVIterator();
    }

    class OVIterator
    implements Iterator<E> {
        int idx = 0;

        OVIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.idx < ObjVector.this.size;
        }

        @Override
        public E next() {
            if (this.idx >= ObjVector.this.data.length) {
                throw new NoSuchElementException();
            }
            Object e = ObjVector.this.data[this.idx];
            ++this.idx;
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

