/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.util.LogHandler;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogManager {
    static HashMap<String, Logger> loggers = new HashMap();
    static Level defaultLevel;
    static Handler handler;
    static String[] activeSevere;
    static String[] activeWarning;
    static String[] activeInfo;
    static String[] activeConfig;
    static String[] activeFine;
    static String[] activeFiner;
    static String[] activeFinest;

    public static void init(Config conf) {
        try {
            defaultLevel = Level.parse(conf.getString("log.level", "INFO").toUpperCase());
        }
        catch (Throwable x) {
            defaultLevel = Level.WARNING;
        }
        activeSevere = conf.getStringArray("log.severe");
        activeWarning = conf.getStringArray("log.warning");
        activeInfo = conf.getStringArray("log.info");
        activeConfig = conf.getStringArray("log.config");
        activeFine = conf.getStringArray("log.fine");
        activeFiner = conf.getStringArray("log.finer");
        activeFinest = conf.getStringArray("log.finest");
        try {
            handler = conf.getEssentialInstance("log.handler.class", Handler.class);
        }
        catch (Config.Exception x) {
            handler = new LogHandler(conf);
            System.err.println("error instantiating log.handler.class, fall back to gov.nasa.jpf.util.LogHandler");
        }
    }

    static boolean checkInclusion(String[] actives, String name) {
        if (actives == null) {
            return false;
        }
        for (int i = 0; i < actives.length; ++i) {
            if (!name.matches(actives[i])) continue;
            return true;
        }
        return false;
    }

    static Level getLevel(String name) {
        if (LogManager.checkInclusion(activeSevere, name)) {
            return Level.SEVERE;
        }
        if (LogManager.checkInclusion(activeWarning, name)) {
            return Level.WARNING;
        }
        if (LogManager.checkInclusion(activeInfo, name)) {
            return Level.INFO;
        }
        if (LogManager.checkInclusion(activeConfig, name)) {
            return Level.CONFIG;
        }
        if (LogManager.checkInclusion(activeFine, name)) {
            return Level.FINE;
        }
        if (LogManager.checkInclusion(activeFiner, name)) {
            return Level.FINER;
        }
        if (LogManager.checkInclusion(activeFinest, name)) {
            return Level.FINEST;
        }
        return defaultLevel;
    }

    public static Logger getLogger(String name) {
        Logger logger = loggers.get(name);
        if (logger == null) {
            logger = Logger.getLogger(name);
            logger.setLevel(LogManager.getLevel(name));
            logger.addHandler(handler);
            logger.setUseParentHandlers(false);
            loggers.put(name, logger);
        }
        return logger;
    }

    public static void setOutput(OutputStream out) {
        if (handler instanceof LogHandler) {
            ((LogHandler)handler).setOutput(out);
        }
    }

    public static void printStatus(Logger log) {
        if (handler instanceof LogHandler) {
            ((LogHandler)handler).printStatus(log);
        }
    }
}

