/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.Config;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogHandler
extends Handler {
    public static String LOG_HOST = "localhost";
    public static int LOG_PORT = 20000;
    File file;
    Socket socket;
    OutputStream ostream;
    PrintWriter out;

    public LogHandler(Config conf) {
        LOG_HOST = conf.getString("log.host", LOG_HOST);
        LOG_PORT = conf.getInt("log.port", LOG_PORT);
        String output = conf.getString("log.output", "out");
        if (output.matches("[a-zA-Z0-9.]*:[0-9]*")) {
            int idx = output.indexOf(58);
            String host = output.substring(0, idx);
            String port = output.substring(idx + 1, output.length());
            this.ostream = this.connectSocket(host, port);
        } else {
            this.ostream = output.equalsIgnoreCase("socket") ? this.connectSocket(LOG_HOST, Integer.toString(LOG_PORT)) : (output.equalsIgnoreCase("out") || output.equals("System.out") ? System.out : (output.equalsIgnoreCase("err") || output.equals("System.err") ? System.err : this.openFile(output)));
        }
        if (this.ostream == null) {
            this.ostream = System.out;
        }
        this.setFormatter(new DefaultFormatter(conf));
        this.setOutput(this.ostream);
    }

    OutputStream connectSocket(String host, String portSpec) {
        int port = -1;
        if (host == null || host.length() == 0) {
            host = LOG_HOST;
        }
        if (portSpec != null) {
            try {
                port = Integer.parseInt(portSpec);
            }
            catch (NumberFormatException x) {
                // empty catch block
            }
        }
        if (port == -1) {
            port = LOG_PORT;
        }
        try {
            this.socket = new Socket(host, port);
            return this.socket.getOutputStream();
        }
        catch (UnknownHostException uhx) {
        }
        catch (ConnectException cex) {
        }
        catch (IOException iox) {
            // empty catch block
        }
        return null;
    }

    OutputStream openFile(String fileName) {
        this.file = new File(fileName);
        try {
            if (this.file.exists()) {
                this.file.delete();
            }
            this.file.createNewFile();
            return new FileOutputStream(this.file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setOutput(OutputStream ostream) {
        this.out = new PrintWriter(ostream, true);
    }

    @Override
    public void close() throws SecurityException {
        if (this.ostream != System.err && this.ostream != System.out) {
            this.out.close();
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void publish(LogRecord r) {
        String msg = this.getFormatter().format(r);
        this.out.println(msg);
    }

    public void printStatus(Logger log) {
        if (this.socket != null) {
            log.config("logging to socket: " + this.socket);
        } else if (this.file != null) {
            log.config("logging to file: " + this.file.getAbsolutePath());
        } else if (this.ostream == System.err) {
            log.config("logging to System.err");
        } else if (this.ostream == System.out) {
            log.config("logging to System.out");
        } else {
            log.warning("unknown log destination");
        }
    }

    static class DefaultFormatter
    extends Formatter {
        boolean format;
        boolean showName;
        boolean showLevel;

        DefaultFormatter(Config conf) {
            this.showName = conf.getBoolean("log.show_name", false);
            this.showLevel = conf.getBoolean("log.show_level", true);
            this.format = this.showName || this.showLevel;
        }

        @Override
        public String format(LogRecord r) {
            if (this.format) {
                StringBuilder sb = new StringBuilder();
                sb.append('[');
                if (this.showLevel) {
                    sb.append(r.getLevel().getName());
                }
                if (this.showName) {
                    if (this.showLevel) {
                        sb.append(":");
                    }
                    sb.append(r.getLoggerName());
                }
                sb.append("] ");
                String msg = r.getMessage();
                Object[] params = r.getParameters();
                if (params == null) {
                    sb.append(msg);
                } else {
                    sb.append(String.format(msg, params));
                }
                return sb.toString();
            }
            return r.getMessage();
        }
    }
}

