/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.Error;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.ListenerAdapter;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.search.Search;
import gov.nasa.jpf.util.Inspector;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;

public class JPFRunner
extends JFrame {
    Inspector inspector;
    JPF jpf;
    JPFAdapter adapter;
    boolean stop;
    boolean foundErrors;
    long totalActions;
    String application;
    String script;
    JLabel lStatus;
    JLabel lNew;
    JLabel lVisited;
    JLabel lInsn;
    JLabel lBack;
    JLabel lResult;
    JLabel lTime;
    static final int L_WIDTH = 150;
    static final int F_WIDTH = 200;

    public JPFRunner(Inspector inspector, JPF jpf, String application, String script) {
        super("Checking: " + application);
        this.inspector = inspector;
        this.jpf = jpf;
        this.application = application;
        this.script = script;
        Container c = this.getContentPane();
        BoxLayout layout = new BoxLayout(c, 1);
        c.setLayout(layout);
        if (c instanceof JComponent) {
            ((JComponent)c).setBorder(new EmptyBorder(5, 10, 10, 10));
        }
        c.add(this.createFieldsPanel());
        c.add(Box.createVerticalStrut(10));
        c.add(Box.createVerticalStrut(10));
        c.add(this.createCommandPanel());
        this.adapter = new JPFAdapter();
        jpf.addSearchListener(this.adapter);
        c.setBackground(inspector.getContentPane().getBackground());
        this.setLocation(300, 400);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    JComponent fixedWidth(JComponent c, int w) {
        Dimension d = c.getPreferredSize();
        d.width = w;
        d.height += 5;
        c.setPreferredSize(d);
        c.setMinimumSize(d);
        c.setMaximumSize(d);
        return c;
    }

    JComponent bordered(JComponent c) {
        SoftBevelBorder b = new SoftBevelBorder(1);
        c.setBorder(b);
        c.setOpaque(true);
        c.setBackground(new Color(240, 240, 240));
        c.setForeground(Color.BLUE);
        return c;
    }

    JComponent createFieldsPanel() {
        Box box = Box.createHorizontalBox();
        Box labels = Box.createVerticalBox();
        labels.add(this.fixedWidth(new JLabel("application", 4), 150));
        labels.add(this.fixedWidth(new JLabel("script", 4), 150));
        labels.add(this.fixedWidth(new JLabel("status", 4), 150));
        labels.add(this.fixedWidth(new JLabel("result", 4), 150));
        labels.add(Box.createVerticalStrut(10));
        labels.add(this.fixedWidth(new JLabel("new states", 4), 150));
        labels.add(this.fixedWidth(new JLabel("visited states", 4), 150));
        labels.add(this.fixedWidth(new JLabel("backtracked states", 4), 150));
        labels.add(this.fixedWidth(new JLabel("instructions", 4), 150));
        labels.add(this.fixedWidth(new JLabel("time", 4), 150));
        box.add(labels);
        box.add(Box.createHorizontalStrut(10));
        Box fields = Box.createVerticalBox();
        fields.add(this.bordered(this.fixedWidth(new JLabel(this.application), 200)));
        fields.add(this.bordered(this.fixedWidth(new JLabel(this.script), 200)));
        this.lStatus = new JLabel("?");
        fields.add(this.bordered(this.fixedWidth(this.lStatus, 200)));
        this.lResult = new JLabel("?");
        fields.add(this.bordered(this.fixedWidth(this.lResult, 200)));
        fields.add(Box.createVerticalStrut(10));
        this.lNew = new JLabel("0");
        fields.add(this.bordered(this.fixedWidth(this.lNew, 200)));
        this.lVisited = new JLabel("0");
        fields.add(this.bordered(this.fixedWidth(this.lVisited, 200)));
        this.lBack = new JLabel("0");
        fields.add(this.bordered(this.fixedWidth(this.lBack, 200)));
        this.lInsn = new JLabel("0");
        fields.add(this.bordered(this.fixedWidth(this.lInsn, 200)));
        this.lTime = new JLabel("00:00:00");
        fields.add(this.bordered(this.fixedWidth(this.lTime, 200)));
        box.add(fields);
        box.add(Box.createHorizontalStrut(10));
        return box;
    }

    JComponent createCommandPanel() {
        Box box = Box.createHorizontalBox();
        JButton bStop = new JButton("Stop");
        bStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPFRunner.this.stop = true;
                JPFRunner.this.lStatus.setText("stopping..");
            }
        });
        box.add(bStop);
        JButton bExit = new JButton("Exit");
        bExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPFRunner.this.stop = true;
                JPFRunner.this.setVisible(false);
                JPFRunner.this.dispose();
            }
        });
        box.add(bExit);
        return box;
    }

    public void run() {
        Thread t = new Thread(this.jpf);
        t.start();
        this.adapter.setStartTime();
    }

    class JPFAdapter
    extends ListenerAdapter {
        int nNew;
        int nVisited;
        int nBacktrack;
        int nInsn;
        long tStart;

        JPFAdapter() {
        }

        void checkStop(Search search) {
            if (JPFRunner.this.stop) {
                search.terminate();
                JPFRunner.this.lStatus.setText("canceled..");
            }
        }

        void setStartTime() {
            this.tStart = System.currentTimeMillis();
        }

        void updateTime() {
            long t = System.currentTimeMillis();
            int elapsed = (int)(t - this.tStart) / 1000;
            int s = elapsed % 60;
            int h = elapsed / 3600;
            int m = (elapsed - h * 3600) / 60;
            StringBuilder sb = new StringBuilder(10);
            if (h < 10) {
                sb.append('0');
            }
            sb.append(h);
            sb.append(':');
            if (m < 10) {
                sb.append('0');
            }
            sb.append(m);
            sb.append(':');
            if (s < 10) {
                sb.append('0');
            }
            sb.append(s);
            JPFRunner.this.lTime.setText(sb.toString());
        }

        @Override
        public void stateAdvanced(Search search) {
            if (search.isNewState()) {
                ++this.nNew;
                JPFRunner.this.lNew.setText(Integer.toString(this.nNew));
            } else {
                ++this.nVisited;
                JPFRunner.this.lVisited.setText(Integer.toString(this.nVisited));
            }
            JVM vm = search.getVM();
            SystemState ss = vm.getSystemState();
            this.nInsn += ss.getTrail().getStepCount();
            JPFRunner.this.lInsn.setText(Integer.toString(this.nInsn));
            this.checkStop(search);
            this.updateTime();
        }

        @Override
        public void stateBacktracked(Search search) {
            ++this.nBacktrack;
            JPFRunner.this.lBack.setText(Integer.toString(this.nBacktrack));
            this.checkStop(search);
            this.updateTime();
        }

        @Override
        public void stateRestored(Search search) {
            this.checkStop(search);
            this.updateTime();
        }

        @Override
        public void searchStarted(Search search) {
            JPFRunner.this.lStatus.setText("running..");
            this.updateTime();
        }

        @Override
        public void searchFinished(Search search) {
            if (!JPFRunner.this.foundErrors) {
                JPFRunner.this.lStatus.setText("finished");
                JPFRunner.this.lResult.setText("no defect found");
            }
            this.updateTime();
            JPFRunner.this.inspector.updateTraceContents();
        }

        @Override
        public void propertyViolated(Search search) {
            List<Error> errors = search.getErrors();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (Error e : errors) {
                if (i++ > 0) {
                    sb.append(',');
                }
                sb.append(e.getDescription());
            }
            JPFRunner.this.lResult.setForeground(Color.RED);
            JPFRunner.this.lResult.setText(sb.toString());
            JPFRunner.this.lStatus.setText("finished");
            JPFRunner.this.foundErrors = true;
        }

        @Override
        public void searchConstraintHit(Search search) {
            this.updateTime();
        }

        @Override
        public void stateProcessed(Search search) {
            this.updateTime();
        }
    }
}

