/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.ObjRef;

public class Invocation {
    MethodInfo mi;
    Object[] args;
    Object[] attrs;

    public Invocation(MethodInfo mi, Object[] args, Object[] attrs) {
        this.mi = mi;
        this.args = args;
        this.attrs = attrs;
    }

    public MethodInfo getMethodInfo() {
        return this.mi;
    }

    public Object[] getExplicitArguments() {
        if (!this.mi.isStatic()) {
            Object[] a = new Object[this.args.length - 1];
            System.arraycopy(this.args, 1, a, 0, a.length);
            return a;
        }
        return this.args;
    }

    public String[] getArgumentTypeNames() {
        return this.mi.getArgumentTypeNames();
    }

    public String getArgumentValueLiteral(Object a) {
        Class<?> cls = a.getClass();
        if (cls == Boolean.class) {
            return ((Boolean)a).toString();
        }
        if (cls == Byte.class) {
            return ((Byte)a).toString();
        }
        if (cls == Character.class) {
            return ((Character)a).toString();
        }
        if (cls == Short.class) {
            return ((Short)a).toString();
        }
        if (cls == Integer.class) {
            return ((Integer)a).toString();
        }
        if (cls == Long.class) {
            return ((Long)a).toString();
        }
        if (cls == Float.class) {
            return ((Float)a).toString();
        }
        if (cls == Double.class) {
            return ((Double)a).toString();
        }
        if (cls == ObjRef.class) {
            int ref = ((ObjRef)a).getReference();
            if (ref != -1) {
                Object ei = DynamicArea.getHeap().get(ref);
                ClassInfo ci = ((ElementInfo)ei).getClassInfo();
                String cname = ci.getName();
                if (cname.equals("java.lang.String")) {
                    return "\"" + ((ElementInfo)ei).asString() + '\"';
                }
            } else {
                return "null";
            }
        }
        return null;
    }

    public Object[] getArguments() {
        return this.args;
    }

    public Object[] getAttrs() {
        return this.attrs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("INVOKE[");
        sb.append(this.mi.getName());
        sb.append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.args[i]);
        }
        sb.append(")]");
        return sb.toString();
    }
}

