/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.util.ConsoleStream;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Inspector
extends JFrame {
    static final int TAB_PROP = 0;
    static final int TAB_SCRIPT = 1;
    static final int TAB_TRACE = 2;
    static final int TAB_OUTPUT = 3;
    protected static Logger log;
    protected static PrintStream sysOut;
    protected static PrintStream sysErr;
    protected static Color BACKGROUND_CLR;
    protected Config config;
    protected String application;
    protected String[] appArguments;
    protected int step;
    protected boolean propChanged;
    protected boolean scriptChanged;
    protected boolean traceChanged;
    protected int stepDelay;
    protected JTextField cmdTextField;
    protected JTextField propTextField;
    protected JTextArea propTextPane;
    protected JTextField scriptTextField;
    protected JTextArea scriptTextPane;
    protected JTextField traceTextField;
    protected JTextArea traceTextPane;
    protected JButton bStep;
    protected JTextArea console;
    protected JTabbedPane tab;
    protected TreeModel treeModel;
    protected ConsoleStream cout;

    protected Inspector(String title, Config config, String application, String[] arguments) {
        super(title);
        String traceName;
        String scriptName;
        this.config = config;
        this.application = application;
        this.appArguments = arguments;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Inspector.this.setVisible(false);
                Inspector.this.disposeAllFrames();
                System.exit(0);
            }
        });
        this.getTargets();
        Container c = this.getContentPane();
        c.setBackground(BACKGROUND_CLR);
        BoxLayout layout = new BoxLayout(c, 1);
        c.setLayout(layout);
        if (c instanceof JComponent) {
            ((JComponent)c).setBorder(new EmptyBorder(5, 10, 10, 10));
        }
        c.add(this.createCommandPanel());
        c.add(this.createApplicationPanel());
        c.add(this.createPropPanel());
        c.add(this.createScriptPanel());
        c.add(this.createTracePanel());
        c.add(this.createSplitPane());
        this.pack();
        String propName = config.getString("inspect.properties");
        if (propName != null) {
            this.propTextField.setText(propName);
            this.setPropContents();
        }
        if ((scriptName = config.getString("inspect.script")) != null) {
            this.scriptTextField.setText(scriptName);
            this.setScriptContents();
            this.checkEventScript();
        }
        if ((traceName = config.getString("inspect.trace")) != null) {
            this.traceTextField.setText(traceName);
            this.setTraceContents();
        }
        this.stepDelay = config.getInt("inspect.step_delay", 800);
        this.redirectOutput();
    }

    protected String getAppCommand() {
        String cmd = "";
        if (this.application != null) {
            cmd = cmd + this.application;
        }
        if (this.appArguments != null) {
            for (String a : this.appArguments) {
                cmd = cmd + ' ';
                cmd = cmd + a;
            }
        }
        return cmd;
    }

    protected void parseAppCommand() {
        String cmd = this.cmdTextField.getText().trim();
        if (cmd.length() == 0) {
            this.application = null;
            this.appArguments = null;
        } else {
            String[] a = cmd.split(" ");
            if (a.length > 0) {
                this.application = a[0];
                if (a.length > 1) {
                    this.appArguments = new String[a.length - 1];
                    System.arraycopy(a, 1, this.appArguments, 0, this.appArguments.length);
                }
            }
        }
    }

    protected void redirectOutput() {
        ConsoleStream out = new ConsoleStream(this.console);
        System.setOut(out);
        System.setErr(out);
    }

    protected void disposeAllFrames() {
        Frame[] frames;
        for (Frame f : frames = Frame.getFrames()) {
            f.setVisible(false);
            f.dispose();
        }
    }

    protected boolean saveFile(String fileName, String content) {
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter(fileName));
            w.write(content, 0, content.length());
            w.close();
            return true;
        }
        catch (Throwable t) {
            System.err.println("error writing file: " + fileName);
            return false;
        }
    }

    protected String readFile(File file) {
        int len = (int)file.length();
        StringBuilder sb = new StringBuilder(len);
        char[] buf = new char[256];
        try {
            int n;
            FileReader r = new FileReader(file);
            while ((n = r.read(buf)) >= 0) {
                sb.append(buf, 0, n);
            }
        }
        catch (IOException x) {
            System.err.println("error reading file: " + file.getName());
        }
        return sb.toString();
    }

    protected String chooseFile(String title, int type) {
        FileDialog chooser = new FileDialog((Frame)this, title, type);
        chooser.setVisible(true);
        String dir = chooser.getDirectory();
        String file = chooser.getFile();
        if (file != null) {
            return dir + file;
        }
        return null;
    }

    protected boolean save(JTextField nameField, JTextComponent contentPane, String msg) {
        String fileName = nameField.getText();
        if (fileName.length() == 0) {
            fileName = this.chooseFile(msg, 1);
            if (fileName == null) {
                return false;
            }
            nameField.setText(fileName);
        }
        return this.saveFile(fileName, contentPane.getText());
    }

    protected void error(String msg) {
        System.err.print("ERROR: ");
        System.err.println(msg);
    }

    protected void errorPopup(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Error", 2);
    }

    protected void delay(int ms) {
        if (ms > 0) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void setTextFieldSizeConstraints(JTextField tf) {
        Dimension d = tf.getPreferredSize();
        tf.setMinimumSize(new Dimension(50, d.height));
        tf.setMaximumSize(new Dimension(10000, d.height));
    }

    protected void setButtonSizeConstraints(JButton btn) {
        Dimension d = btn.getPreferredSize();
        btn.setMinimumSize(d);
        btn.setMaximumSize(d);
    }

    protected void setSizeConstraints(JComponent c, int prefLines, int minLines) {
        Font font = c.getFont();
        FontMetrics fm = c.getFontMetrics(font);
        int fontHeight = fm.getHeight();
        int prefHeight = fontHeight * prefLines;
        int minHeight = fontHeight * minLines;
        c.setPreferredSize(new Dimension(300, prefHeight));
        c.setMinimumSize(new Dimension(100, minHeight));
    }

    protected void setLabelSizeConstraints(JLabel label) {
        Dimension d = label.getPreferredSize();
        Dimension fixed = new Dimension(90, d.height);
        label.setPreferredSize(fixed);
        label.setMinimumSize(fixed);
        label.setMaximumSize(fixed);
    }

    protected void extendTextKeyMap(JTextComponent c, KeyStroke k, AbstractAction a) {
        Keymap km = c.getKeymap();
        km.addActionForKeyStroke(k, a);
    }

    protected void loadApplication() {
        sysOut.println("loadApplication");
    }

    protected void launchApplication() {
        sysOut.println("launchApplication");
    }

    protected void checkApplication() {
        sysOut.println("checkApplication");
    }

    protected void terminateApplication() {
        sysOut.println("terminateApplication");
    }

    protected void replayTrace() {
        sysOut.println("replayTrace");
    }

    protected void replayStep() {
        sysOut.println("replayStep");
    }

    protected void checkEventScript() {
        sysOut.println("setEventGeneratorFactory");
    }

    protected void getTargets() {
        sysOut.println("getTargets");
    }

    protected JComponent createTargetPanel() {
        return new JTextArea();
    }

    protected JComponent createCommandPanel() {
        Box box = Box.createHorizontalBox();
        this.addSpecificCommands(box);
        JButton check = new JButton("Check");
        check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspector.this.checkApplication();
            }
        });
        this.setButtonSizeConstraints(check);
        box.add(check);
        JButton bExit = new JButton("Exit");
        bExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspector.this.disposeAllFrames();
                Inspector.this.delay(500);
                System.exit(0);
            }
        });
        this.setButtonSizeConstraints(bExit);
        box.add(bExit);
        return box;
    }

    protected JComponent createApplicationPanel() {
        Box box = Box.createHorizontalBox();
        JLabel label = new JLabel("Application ", 4);
        this.setLabelSizeConstraints(label);
        box.add(label);
        this.cmdTextField = new JTextField(this.getAppCommand());
        this.cmdTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspector.this.loadApplication();
            }
        });
        this.setTextFieldSizeConstraints(this.cmdTextField);
        box.add(this.cmdTextField);
        JButton browse = new JButton("...");
        this.setButtonSizeConstraints(browse);
        box.add(browse);
        return box;
    }

    protected JComponent createPropPanel() {
        Box box = Box.createHorizontalBox();
        JLabel label = new JLabel("Properties ", 4);
        this.setLabelSizeConstraints(label);
        box.add(label);
        this.propTextField = new JTextField();
        this.propTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspector.this.setPropContents();
            }
        });
        this.setTextFieldSizeConstraints(this.propTextField);
        box.add(this.propTextField);
        JButton browse = new JButton("...");
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspector.this.selectProp();
            }
        });
        this.setButtonSizeConstraints(browse);
        box.add(browse);
        return box;
    }

    protected JComponent createScriptPanel() {
        Box box = Box.createHorizontalBox();
        JLabel label = new JLabel("Script ", 4);
        this.setLabelSizeConstraints(label);
        box.add(label);
        this.scriptTextField = new JTextField();
        this.scriptTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspector.this.setScriptContents();
                Inspector.this.checkEventScript();
            }
        });
        this.setTextFieldSizeConstraints(this.scriptTextField);
        box.add(this.scriptTextField);
        JButton browse = new JButton("...");
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspector.this.selectScript();
                Inspector.this.checkEventScript();
            }
        });
        this.setButtonSizeConstraints(browse);
        box.add(browse);
        return box;
    }

    protected JComponent createTracePanel() {
        Box box = Box.createHorizontalBox();
        JLabel label = new JLabel("Trace ", 4);
        this.setLabelSizeConstraints(label);
        box.add(label);
        this.traceTextField = new JTextField();
        this.traceTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspector.this.setTraceContents();
            }
        });
        this.setTextFieldSizeConstraints(this.traceTextField);
        box.add(this.traceTextField);
        JButton browse = new JButton("...");
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspector.this.selectTrace();
            }
        });
        this.setButtonSizeConstraints(browse);
        box.add(browse);
        return box;
    }

    protected JComponent createTextPanel() {
        this.tab = new JTabbedPane();
        Font def = this.tab.getFont();
        Font mono = new Font("Monospaced", 0, def.getSize());
        this.propTextPane = new JTextArea();
        this.propTextPane.setFont(mono);
        this.propTextPane.setLineWrap(false);
        this.propTextPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                Inspector.this.markPropChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Inspector.this.markPropChanged();
            }
        });
        AbstractAction propSaver = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Inspector.this.save(Inspector.this.propTextField, Inspector.this.propTextPane, "Save Properties File")) {
                    Inspector.this.markPropSaved();
                }
            }
        };
        this.extendTextKeyMap(this.propTextPane, KeyStroke.getKeyStroke(83, 4, true), propSaver);
        this.createTextPopup(this.propTextPane, propSaver);
        JScrollPane scroll = new JScrollPane(this.propTextPane);
        this.tab.addTab("Properties", scroll);
        this.scriptTextPane = new JTextArea();
        this.scriptTextPane.setFont(mono);
        this.scriptTextPane.setLineWrap(false);
        this.scriptTextPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                Inspector.this.markScriptChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Inspector.this.markScriptChanged();
            }
        });
        AbstractAction scriptSaver = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Inspector.this.save(Inspector.this.scriptTextField, Inspector.this.scriptTextPane, "Save Script File")) {
                    Inspector.this.markScriptSaved();
                    Inspector.this.checkEventScript();
                }
            }
        };
        this.extendTextKeyMap(this.scriptTextPane, KeyStroke.getKeyStroke(83, 4, true), scriptSaver);
        this.createTextPopup(this.scriptTextPane, scriptSaver);
        scroll = new JScrollPane(this.scriptTextPane);
        this.tab.addTab("Script", scroll);
        this.traceTextPane = new JTextArea();
        this.traceTextPane.setFont(mono);
        this.traceTextPane.setLineWrap(false);
        this.traceTextPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                Inspector.this.markTraceChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Inspector.this.markTraceChanged();
            }
        });
        AbstractAction traceSaver = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Inspector.this.save(Inspector.this.traceTextField, Inspector.this.traceTextPane, "Save Trace File")) {
                    Inspector.this.markTraceSaved();
                }
            }
        };
        this.createTextPopup(this.traceTextPane, traceSaver);
        scroll = new JScrollPane(this.traceTextPane);
        this.tab.addTab("Trace", scroll);
        this.console = new JTextArea();
        this.console.setFont(mono);
        this.console.setEditable(false);
        this.console.setLineWrap(false);
        scroll = new JScrollPane(this.console);
        this.tab.addTab("Output", scroll);
        this.addSpecificTextPanes(this.tab);
        this.setSizeConstraints(this.tab, 20, 10);
        return this.tab;
    }

    protected void addSpecificTextPanes(JTabbedPane tab) {
    }

    protected void addSpecificCommands(Box box) {
    }

    void createTextPopup(final JTextComponent target, ActionListener saver) {
        JPopupMenu popUp = new JPopupMenu();
        JMenuItem item = new JMenuItem("cut");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                target.cut();
            }
        });
        popUp.add(item);
        item = new JMenuItem("copy");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                target.copy();
            }
        });
        popUp.add(item);
        item = new JMenuItem("paste");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                target.paste();
            }
        });
        popUp.add(item);
        item = new JMenuItem("save");
        item.addActionListener(saver);
        popUp.add(item);
        popUp.setCursor(Cursor.getDefaultCursor());
        popUp.setBorder(new BevelBorder(0));
        popUp.addPopupMenuListener(new PopupMenuListener(){
            Cursor cur;

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                target.setCursor(this.cur);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                target.setCursor(this.cur);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                this.cur = target.getCursor();
                target.setCursor(Cursor.getDefaultCursor());
            }
        });
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        target.setComponentPopupMenu(popUp);
    }

    protected JComponent createSplitPane() {
        Box box = Box.createHorizontalBox();
        JComponent tgt = this.createTargetPanel();
        JComponent txt = this.createTextPanel();
        JSplitPane split = new JSplitPane(0, tgt, txt);
        split.setOpaque(false);
        split.setBorder(null);
        split.setOneTouchExpandable(true);
        box.add(split);
        return box;
    }

    protected void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand);
    }

    protected void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    protected void selectProp() {
        String sel = this.chooseFile("Choose Properties File", 0);
        if (sel != null) {
            this.propTextField.setText(sel);
            this.setPropContents();
        }
    }

    protected void selectScript() {
        String sel = this.chooseFile("Choose Script File", 0);
        if (sel != null) {
            this.scriptTextField.setText(sel);
            this.setScriptContents();
        }
    }

    protected void selectTrace() {
        String sel = this.chooseFile("Choose Trace File", 0);
        if (sel != null) {
            this.traceTextField.setText(sel);
            this.setTraceContents();
        }
    }

    protected void setTraceContents() {
        String fileName = this.traceTextField.getText();
        File file = new File(fileName);
        if (file.exists()) {
            String contents = this.readFile(file);
            this.traceTextPane.setText(contents);
            this.traceChanged = false;
            this.tab.setTitleAt(2, "Trace");
            this.tab.setSelectedIndex(2);
        }
    }

    protected void setPropContents() {
        String fileName = this.propTextField.getText();
        File file = new File(fileName);
        if (file.exists()) {
            String contents = this.readFile(file);
            this.propTextPane.setText(contents);
            this.propChanged = false;
            this.tab.setTitleAt(0, "Properties");
            this.tab.setSelectedIndex(0);
        }
    }

    protected void setScriptContents() {
        String fileName = this.scriptTextField.getText();
        if (fileName.length() > 0) {
            File file = new File(fileName);
            if (file.exists()) {
                String contents = this.readFile(file);
                this.scriptTextPane.setText(contents);
            }
        } else {
            this.scriptTextPane.setText(null);
        }
        this.scriptChanged = false;
        this.tab.setTitleAt(1, "Script");
        this.tab.setSelectedIndex(1);
    }

    public void updateTraceContents() {
        File file;
        String traceName = this.traceTextField.getText();
        if (traceName.length() > 0 && (file = new File(traceName)).exists()) {
            String contents = this.readFile(file);
            this.traceTextPane.setText(contents);
        }
    }

    protected void showResetOutput() {
        this.console.setText(null);
    }

    protected void markPropChanged() {
        if (!this.propChanged) {
            this.propChanged = true;
            this.tab.setTitleAt(0, "* Properties");
        }
    }

    protected void markPropSaved() {
        if (this.propChanged) {
            this.propChanged = false;
            this.tab.setTitleAt(0, "Properties");
        }
    }

    protected void markScriptChanged() {
        if (!this.scriptChanged) {
            this.scriptChanged = true;
            this.tab.setTitleAt(1, "* Script");
        }
    }

    protected void markScriptSaved() {
        if (this.scriptChanged) {
            this.scriptChanged = false;
            this.tab.setTitleAt(1, "Script");
        }
    }

    protected void markTraceChanged() {
        if (!this.traceChanged) {
            this.traceChanged = true;
            this.tab.setTitleAt(2, "* Trace");
        }
    }

    protected void markTraceSaved() {
        if (this.traceChanged) {
            this.traceChanged = false;
            this.tab.setTitleAt(2, "Trace");
        }
    }

    static {
        sysOut = System.out;
        sysErr = System.err;
        BACKGROUND_CLR = new Color(220, 220, 250);
    }
}

