/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.IntTable;
import java.util.ArrayList;

public final class HashPool<V> {
    private IntTable<V> pool;
    private ArrayList<V> vect;

    public HashPool() {
        this(8);
    }

    public HashPool(int pow) {
        this.pool = new IntTable(pow);
        this.vect = new ArrayList(1 << pow);
    }

    public HashPool<V> addNull() {
        if (this.size() == 0) {
            this.pool.add(null, 0);
            this.vect.add(null);
            return this;
        }
        throw new IllegalStateException();
    }

    public IntTable.Entry<V> getEntry(V o) {
        int sz = this.pool.size();
        IntTable.Entry<V> e = this.pool.pool(o);
        if (e.val == sz) {
            this.vect.add(o);
        }
        return e;
    }

    public int getIndex(V o) {
        return this.getEntry(o).val;
    }

    public V get(V o) {
        return (V)this.getEntry(o).key;
    }

    public V getObject(int idx) {
        return this.vect.get(idx);
    }

    public void print() {
        System.out.println("{");
        for (IntTable.Entry<V> entry : this.pool) {
            System.out.println("\t" + entry);
        }
        System.out.println("}");
    }

    public int size() {
        return this.pool.size();
    }
}

