/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.util;

import gov.nasa.jpf.util.BitArray;
import gov.nasa.jpf.util.SimplePool;
import java.util.Arrays;

public class FinalBitSet {
    final byte[] data;
    static final SimplePool<FinalBitSet> pool = new SimplePool();
    public static final FinalBitSet empty = FinalBitSet.create(BitArray.empty);

    FinalBitSet(byte[] in) {
        int len;
        for (len = in.length; len > 0 && in[len - 1] == 0; --len) {
        }
        this.data = new byte[len];
        System.arraycopy(in, 0, this.data, 0, len);
    }

    public final boolean get(int idx) {
        int a = idx >> 3;
        return a < this.data.length && a >= 0 && (this.data[a] & 1 << (idx & 7)) != 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FinalBitSet)) {
            return false;
        }
        byte[] thatData = ((FinalBitSet)o).data;
        byte[] thisData = this.data;
        return Arrays.equals(thisData, thatData);
    }

    public static FinalBitSet create(BitArray in) {
        return pool.pool(new FinalBitSet(in.data));
    }

    public static FinalBitSet create(byte[] in) {
        return pool.pool(new FinalBitSet(in));
    }
}

